/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.stubs;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import no.unit.nva.commons.json.JsonUtils;
import nva.commons.core.JacocoGenerated;
import nva.commons.core.attempt.Try;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClient;
import software.amazon.awssdk.services.secretsmanager.model.GetSecretValueRequest;
import software.amazon.awssdk.services.secretsmanager.model.GetSecretValueResponse;

public class FakeSecretsManagerClient
implements SecretsManagerClient {
    private final Map<SecretName, String> plainTextSecrets = new ConcurrentHashMap<SecretName, String>();
    public Map<SecretName, Map<SecretKey, String>> secrets = new ConcurrentHashMap<SecretName, Map<SecretKey, String>>();

    public FakeSecretsManagerClient putSecret(String name, String key, String value) {
        SecretName secretName = new SecretName(name);
        if (this.plainTextSecrets.containsKey(secretName)) {
            throw new IllegalArgumentException(String.format("Secret already present as a plain text secret: %s", name));
        }
        if (this.secrets.containsKey(secretName)) {
            this.addSecretValueToExistingSecret(key, value, secretName);
        } else {
            this.createNewSecret(key, value, secretName);
        }
        return this;
    }

    public FakeSecretsManagerClient putPlainTextSecret(String name, String value) {
        SecretName secretName = new SecretName(name);
        if (this.secrets.containsKey(secretName)) {
            throw new IllegalArgumentException(String.format("Secret already present as a key/value secret: %s", name));
        }
        this.plainTextSecrets.put(secretName, value);
        return this;
    }

    public GetSecretValueResponse getSecretValue(GetSecretValueRequest getSecretValueRequest) {
        return Optional.ofNullable(getSecretValueRequest.secretId()).map(SecretName::new).flatMap(this::resolveSecret).map(secretContents -> FakeSecretsManagerClient.addSecretContents(secretContents, getSecretValueRequest)).orElseThrow();
    }

    @JacocoGenerated
    public String serviceName() {
        return null;
    }

    @JacocoGenerated
    public void close() {
    }

    private static GetSecretValueResponse addSecretContents(String secretContents, GetSecretValueRequest getSecretValueRequest) {
        return (GetSecretValueResponse)GetSecretValueResponse.builder().secretString(secretContents).name(getSecretValueRequest.secretId()).build();
    }

    private static String serializeSecretContents(Map<SecretKey, String> secretContents) {
        return (String)Try.attempt(() -> JsonUtils.dtoObjectMapper.writeValueAsString((Object)secretContents)).orElseThrow();
    }

    private Optional<String> resolveSecret(SecretName secretName) {
        if (this.secrets.containsKey(secretName)) {
            return Optional.of(FakeSecretsManagerClient.serializeSecretContents(this.secrets.get(secretName)));
        }
        if (this.plainTextSecrets.containsKey(secretName)) {
            return Optional.of(this.plainTextSecrets.get(secretName));
        }
        return Optional.empty();
    }

    private void createNewSecret(String key, String value, SecretName secretName) {
        ConcurrentHashMap<SecretKey, String> secretContents = new ConcurrentHashMap<SecretKey, String>();
        secretContents.put(new SecretKey(key), value);
        this.secrets.put(secretName, secretContents);
    }

    private void addSecretValueToExistingSecret(String key, String value, SecretName secretName) {
        this.secrets.get(secretName).put(new SecretKey(key), value);
    }

    private static final class SecretName {
        private final String value;

        @JsonCreator
        private SecretName(String value) {
            this.value = value;
        }

        @JsonValue
        @JacocoGenerated
        public String getValue() {
            return this.value;
        }

        @JacocoGenerated
        public int hashCode() {
            return this.value != null ? this.value.hashCode() : 0;
        }

        @JacocoGenerated
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SecretName)) {
                return false;
            }
            SecretName that = (SecretName)o;
            return Objects.equals(this.value, that.value);
        }
    }

    private static class SecretKey {
        private final String value;

        @JsonCreator
        public SecretKey(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JacocoGenerated
        public int hashCode() {
            return this.value != null ? this.value.hashCode() : 0;
        }

        @JacocoGenerated
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SecretKey)) {
                return false;
            }
            SecretKey secretKey = (SecretKey)o;
            return Objects.equals(this.value, secretKey.value);
        }
    }
}

