/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.hamcrest;

import com.fasterxml.jackson.databind.JsonNode;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class PropertyValuePair {
    public static final String ERROR_INVOKING_GETTER = "Could not get value for field: ";
    public static final String FIELD_PATH_DELIMITER = ".";
    public static final String ROOT_OBJECT_PATH = "";
    public static final String LEFT_BRACE = "[";
    public static final String RIGHT_BRACE = "]";
    public static final String ARRAY_INDEX_INDICATOR = "\\[\\d*\\]";
    public static final String EMPTY_STRING = "";
    private final String propertyName;
    private final Object value;
    private final String fieldPath;
    private final String parentPath;

    public PropertyValuePair(String propertyName, Object value, String parentPath) {
        this.propertyName = propertyName;
        this.value = value;
        this.parentPath = parentPath;
        this.fieldPath = this.formatFieldPathInfo(propertyName, parentPath);
    }

    public static PropertyValuePair rootObject(Object object) {
        return new PropertyValuePair(null, object, "");
    }

    public static PropertyValuePair collectionElement(String propertyName, Object value, String parentPath, int index) {
        return new PropertyValuePair(propertyName + PropertyValuePair.formatArrayIndex(index), value, parentPath);
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public Object getValue() {
        return this.value;
    }

    public String getFieldPath() {
        return this.fieldPath;
    }

    public List<PropertyValuePair> children() {
        List<PropertyDescriptor> properties = this.collectPropertyDescriptors();
        return properties.stream().map(this::extractFieldValue).collect(Collectors.toList());
    }

    public boolean isBaseType() {
        return Objects.isNull(this.value) || this.value.getClass().isPrimitive() || this.value instanceof Class || this.value instanceof String || this.value instanceof Integer || this.value instanceof Double || this.value instanceof Float || this.value instanceof Boolean || this.value instanceof Character || this.value instanceof Byte || this.value instanceof Short || this.value instanceof Long || this.value instanceof Map || this.value instanceof Collection || this.value instanceof JsonNode;
    }

    public boolean isComplexObject() {
        return !this.isBaseType();
    }

    public boolean isCollection() {
        return Objects.nonNull(this.value) && this.value instanceof Collection;
    }

    public List<PropertyValuePair> createPropertyValuePairsForEachCollectionItem() {
        Collection values = (Collection)this.getValue();
        ArrayList<PropertyValuePair> collectionElements = new ArrayList<PropertyValuePair>();
        int index = 0;
        for (Object currentValue : values) {
            PropertyValuePair newElement = PropertyValuePair.collectionElement(this.getPropertyName(), currentValue, this.parentPath, index);
            collectionElements.add(newElement);
            ++index;
        }
        return collectionElements;
    }

    public boolean shouldBeChecked(Set<Class<?>> stopRecursionClasses, Set<String> ignoredFields) {
        return this.classShouldBeChecked(stopRecursionClasses) && this.fieldShouldBeChecked(ignoredFields);
    }

    private static String formatArrayIndex(int index) {
        return LEFT_BRACE + index + RIGHT_BRACE;
    }

    private boolean classShouldBeChecked(Set<Class<?>> stopRecursionClasses) {
        return stopRecursionClasses.stream().noneMatch(stopRecursionClass -> stopRecursionClass.isInstance(this.value));
    }

    private boolean fieldShouldBeChecked(Set<String> ignoreFields) {
        return !ignoreFields.contains(this.createGenericFieldPath());
    }

    private String createGenericFieldPath() {
        return this.getFieldPath().replaceAll(ARRAY_INDEX_INDICATOR, "");
    }

    private String formatFieldPathInfo(String propertyName, String parentPath) {
        if (this.isRootObject()) {
            return "";
        }
        return parentPath + FIELD_PATH_DELIMITER + propertyName;
    }

    private boolean isRootObject() {
        return Objects.isNull(this.propertyName);
    }

    private List<PropertyDescriptor> collectPropertyDescriptors() {
        BeanInfo beanInfo = this.getBeanInfo(this.value);
        return Arrays.stream(beanInfo.getPropertyDescriptors()).collect(Collectors.toList());
    }

    private BeanInfo getBeanInfo(Object actual) {
        try {
            return Introspector.getBeanInfo(actual.getClass());
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e);
        }
    }

    private PropertyValuePair extractFieldValue(PropertyDescriptor propertyDescriptor) {
        try {
            return new PropertyValuePair(propertyDescriptor.getName(), propertyDescriptor.getReadMethod().invoke(this.value, new Object[0]), this.fieldPath);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            String fieldName = this.fieldPath + FIELD_PATH_DELIMITER + propertyDescriptor.getName();
            throw new RuntimeException(ERROR_INVOKING_GETTER + fieldName, e);
        }
    }
}

