/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.testutils;

import com.amazonaws.services.lambda.runtime.events.APIGatewayProxyRequestEvent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.type.MapType;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import nva.commons.apigateway.AccessRight;
import nva.commons.apigateway.AccessRightEntry;
import nva.commons.core.JacocoGenerated;

@JacocoGenerated
public class HandlerRequestBuilder<T> {
    public static final String DELIMITER = System.lineSeparator();
    public static final String AUTHORIZER_NODE = "authorizer";
    public static final String CLAIMS_NODE = "claims";
    public static final String USER_NAME_CLAIM = "custom:nvaUsername";
    public static final String GROUPS_CLAIM = "cognito:groups";
    public static final String APPLICATION_ROLES_CLAIM = "custom:applicationRoles";
    public static final String PERSON_CRISTIN_ID = "custom:cristinId";
    public static final String CUSTOMER_ID = "custom:customerId";
    public static final String FEIDE_ID_CLAIM = "custom:feideId";
    public static final String ENTRIES_DELIMITER = ",";
    public static final String SCOPE_CLAIM = "scope";
    public static final String ISS_CLAIM = "iss";
    public static final String CLIENT_ID_CLAIM = "client_id";
    public static final String PERSON_NIN_CLAIM = "custom:nin";
    private static final String TOP_LEVEL_ORG_CRISTIN_ID_CLAIM = "custom:topOrgCristinId";
    private static final String COMMA = ",";
    private final ObjectMapper objectMapper;
    @JsonProperty(value="body")
    private String body;
    @JsonProperty(value="headers")
    private Map<String, String> headers;
    @JsonProperty(value="queryStringParameters")
    private Map<String, String> queryParameters;
    @JsonProperty(value="multiValueQueryStringParameters")
    private Map<String, List<String>> multiValueQueryParameters;
    @JsonProperty(value="pathParameters")
    private Map<String, String> pathParameters;
    @JsonProperty(value="requestContext")
    private ObjectNode requestContext;
    @JsonProperty(value="httpMethod")
    private String httpMethod;
    @JsonAnySetter
    private Map<String, Object> otherProperties;

    public HandlerRequestBuilder(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        this.otherProperties = new LinkedHashMap<String, Object>();
    }

    public static String toString(InputStream inputStream) {
        return new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8)).lines().collect(Collectors.joining(DELIMITER));
    }

    public HandlerRequestBuilder<T> withBody(T body) throws JsonProcessingException {
        this.body = body instanceof String ? (String)body : this.objectMapper.writeValueAsString(body);
        return this;
    }

    public HandlerRequestBuilder<T> withHeaders(Map<String, String> headers) {
        this.headers = headers;
        return this;
    }

    public HandlerRequestBuilder<T> withQueryParameters(Map<String, String> queryParameters) {
        this.queryParameters = queryParameters;
        return this;
    }

    public HandlerRequestBuilder<T> withMultiValueQueryParameters(Map<String, List<String>> multiValueQueryParameters) {
        this.multiValueQueryParameters = multiValueQueryParameters;
        return this;
    }

    public HandlerRequestBuilder<T> withPathParameters(Map<String, String> pathParameters) {
        this.pathParameters = pathParameters;
        return this;
    }

    public HandlerRequestBuilder<T> withRequestContext(ObjectNode requestContext) {
        this.requestContext = requestContext;
        return this;
    }

    public HandlerRequestBuilder<T> withHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
        return this;
    }

    @Deprecated(since="1.25.0")
    public HandlerRequestBuilder<T> withRequestContext(Map<String, Object> requestContext) {
        this.requestContext = (ObjectNode)this.objectMapper.convertValue(requestContext, ObjectNode.class);
        return this;
    }

    public HandlerRequestBuilder<T> withOtherProperties(Map<String, Object> otherProperties) {
        this.otherProperties.putAll(otherProperties);
        return this;
    }

    public InputStream build() throws JsonProcessingException {
        return new ByteArrayInputStream(this.objectMapper.writeValueAsBytes((Object)this));
    }

    public APIGatewayProxyRequestEvent buildRequestEvent() throws JsonProcessingException {
        String json = this.objectMapper.writeValueAsString((Object)this);
        return (APIGatewayProxyRequestEvent)this.objectMapper.readValue(json, APIGatewayProxyRequestEvent.class);
    }

    public T getBody(TypeReference<T> typeRef) throws JsonProcessingException {
        if (Objects.nonNull(this.body)) {
            return (T)this.objectMapper.readValue(this.body, typeRef);
        }
        return null;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public Map<String, String> getQueryParameters() {
        return this.queryParameters;
    }

    public Map<String, List<String>> getMultiValueQueryParameters() {
        return this.multiValueQueryParameters;
    }

    public Map<String, String> getPathParameters() {
        return this.pathParameters;
    }

    public Map<String, Object> getRequestContext() {
        MapType mapType = this.objectMapper.getTypeFactory().constructMapType(Map.class, String.class, Object.class);
        return (Map)this.objectMapper.convertValue((Object)this.requestContext, (JavaType)mapType);
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    @JsonAnyGetter
    public Map<String, Object> getOtherProperties() {
        return this.otherProperties;
    }

    public void setOtherProperties(Map<String, Object> otherProperties) {
        this.otherProperties = otherProperties;
    }

    public HandlerRequestBuilder<T> withUserName(String userName) {
        ObjectNode claims = this.getAuthorizerClaimsNode();
        claims.put(USER_NAME_CLAIM, userName);
        return this;
    }

    @Deprecated(since="1.25.5")
    @JacocoGenerated
    public HandlerRequestBuilder<T> withNvaUsername(String nvaUsername) {
        return this.withUserName(nvaUsername);
    }

    public HandlerRequestBuilder<T> withCurrentCustomer(URI customerId) {
        ObjectNode claims = this.getAuthorizerClaimsNode();
        claims.put(CUSTOMER_ID, customerId.toString());
        return this;
    }

    public HandlerRequestBuilder<T> withAllowedCustomers(Set<URI> customers) {
        ObjectNode claims = this.getAuthorizerClaimsNode();
        claims.put("custom:allowedCustomers", customers.stream().map(URI::toString).collect(Collectors.joining(",")));
        return this;
    }

    public HandlerRequestBuilder<T> withAuthorizerClaim(String claimName, String claimValue) {
        ObjectNode authorizerClaimsNode = this.getAuthorizerClaimsNode();
        authorizerClaimsNode.put(claimName, claimValue);
        return this;
    }

    public HandlerRequestBuilder<T> withTopLevelCristinOrgId(URI topLevelCristinOrgId) {
        ObjectNode claims = this.getAuthorizerClaimsNode();
        claims.put(TOP_LEVEL_ORG_CRISTIN_ID_CLAIM, topLevelCristinOrgId.toString());
        return this;
    }

    public HandlerRequestBuilder<T> withPersonCristinId(URI personCristinId) {
        ObjectNode claims = this.getAuthorizerClaimsNode();
        claims.put(PERSON_CRISTIN_ID, personCristinId.toString());
        return this;
    }

    public HandlerRequestBuilder<T> withPersonNin(String personNin) {
        ObjectNode claims = this.getAuthorizerClaimsNode();
        claims.put(PERSON_NIN_CLAIM, personNin);
        return this;
    }

    public HandlerRequestBuilder<T> withFeideId(String feideId) {
        ObjectNode claims = this.getAuthorizerClaimsNode();
        claims.put(FEIDE_ID_CLAIM, feideId);
        return this;
    }

    public HandlerRequestBuilder<T> withRoles(String roles) {
        ObjectNode claims = this.getAuthorizerClaimsNode();
        claims.put(APPLICATION_ROLES_CLAIM, roles);
        return this;
    }

    public HandlerRequestBuilder<T> withAccessRights(URI customerId, AccessRight ... accessRights) {
        for (AccessRight accessRight : accessRights) {
            AccessRightEntry accessRightEntry = new AccessRightEntry(accessRight, customerId);
            this.addAccessRightToCognitoGroups(accessRightEntry);
        }
        ObjectNode claims = this.getAuthorizerClaimsNode();
        String accessRightsString = Arrays.stream(accessRights).map(AccessRight::toPersistedString).collect(Collectors.joining(","));
        claims.put("custom:accessRights", accessRightsString);
        return this;
    }

    public HandlerRequestBuilder<T> withRequestContextValue(String propertyName, String value) {
        this.initializeRequestContextIfNotExists();
        this.requestContext.put(propertyName, value);
        return this;
    }

    public HandlerRequestBuilder<T> withScope(String scope) {
        ObjectNode authorizerClaims = this.getAuthorizerClaimsNode();
        authorizerClaims.put(SCOPE_CLAIM, scope);
        return this;
    }

    public HandlerRequestBuilder<T> withIssuer(String issuer) {
        ObjectNode authorizerClaims = this.getAuthorizerClaimsNode();
        authorizerClaims.put(ISS_CLAIM, issuer);
        return this;
    }

    public HandlerRequestBuilder<T> withCognitoUsername(String cognitoUsername) {
        ObjectNode authorizerClaims = this.getAuthorizerClaimsNode();
        authorizerClaims.put("username", cognitoUsername);
        return this;
    }

    public HandlerRequestBuilder<T> withClientId(String clientId) {
        ObjectNode authorizerClaims = this.getAuthorizerClaimsNode();
        authorizerClaims.put(CLIENT_ID_CLAIM, clientId);
        return this;
    }

    private void addAccessRightToCognitoGroups(AccessRightEntry accessRight) {
        ObjectNode claims = this.getAuthorizerClaimsNode();
        this.appendAccessRightClaimToAccessRightClaims(claims, accessRight);
    }

    private void appendAccessRightClaimToAccessRightClaims(ObjectNode claims, AccessRightEntry accessRight) {
        Collection<AccessRightEntry> existingAccessRights = this.extractAccessRights(claims);
        existingAccessRights.add(accessRight);
        String newClaim = existingAccessRights.stream().map(AccessRightEntry::toString).collect(Collectors.joining(","));
        claims.put(GROUPS_CLAIM, newClaim);
    }

    private Collection<AccessRightEntry> extractAccessRights(ObjectNode claims) {
        return new ArrayList<AccessRightEntry>(AccessRightEntry.fromCsv((String)Optional.ofNullable(claims.get(GROUPS_CLAIM)).map(JsonNode::asText).orElse("")).toList());
    }

    private ObjectNode getAuthorizerClaimsNode() {
        ObjectNode authorizerNode = this.populateAuthorizerNode();
        ObjectNode claimsNode = this.getChildNode(authorizerNode, CLAIMS_NODE);
        authorizerNode.set(CLAIMS_NODE, (JsonNode)claimsNode);
        return claimsNode;
    }

    private ObjectNode getChildNode(ObjectNode parentNode, String childNodeName) {
        return Optional.ofNullable(parentNode).map(parent -> parent.get(childNodeName)).filter(JsonNode::isObject).map(ObjectNode.class::cast).orElse(this.objectMapper.createObjectNode());
    }

    private void initializeRequestContextIfNotExists() {
        if (Objects.isNull(this.requestContext)) {
            this.requestContext = this.objectMapper.createObjectNode();
        }
    }

    private ObjectNode populateAuthorizerNode() {
        this.initializeRequestContextIfNotExists();
        ObjectNode authorizerNode = this.getChildNode(this.requestContext, AUTHORIZER_NODE);
        this.requestContext.set(AUTHORIZER_NODE, (JsonNode)authorizerNode);
        return authorizerNode;
    }
}

