/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.testutils;

import java.net.http.HttpRequest;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.Flow;
import nva.commons.core.JacocoGenerated;

@JacocoGenerated
public class RequestBodyReader {
    public static final String NO_BODY_PUBLISHER_ERROR = "HttpRequest has no bodyPublisher";

    @JacocoGenerated
    public static String requestBody(HttpRequest request) {
        HttpRequest.BodyPublisher bodyPublisher = request.bodyPublisher().orElseThrow(() -> new IllegalStateException(NO_BODY_PUBLISHER_ERROR));
        RequestBodySubscriber subscriber = new RequestBodySubscriber();
        bodyPublisher.subscribe(subscriber);
        return subscriber.getBody();
    }

    @JacocoGenerated
    private static final class RequestBodySubscriber
    implements Flow.Subscriber<ByteBuffer> {
        public static final int NUMBER_OF_REQUESTS_TO_PUBLISHER = 1000;
        private final ByteBuffer cache = ByteBuffer.allocate(100);

        private RequestBodySubscriber() {
        }

        public String getBody() {
            return new String(this.cache.array(), StandardCharsets.UTF_8);
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            subscription.request(1000L);
        }

        @Override
        public void onNext(ByteBuffer item) {
            this.cache.put(item);
        }

        @Override
        public void onError(Throwable throwable) {
            System.err.println(throwable.getMessage());
        }

        @Override
        public void onComplete() {
        }
    }
}

