/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.s3;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import no.unit.nva.s3.ListingResult;
import no.unit.nva.s3.StringCompressor;
import nva.commons.core.Environment;
import nva.commons.core.JacocoGenerated;
import nva.commons.core.attempt.Try;
import nva.commons.core.ioutils.IoUtils;
import nva.commons.core.paths.UnixPath;
import nva.commons.core.paths.UriWrapper;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.EnvironmentVariableCredentialsProvider;
import software.amazon.awssdk.core.ResponseBytes;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.core.sync.ResponseTransformer;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.model.DeleteObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Request;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Response;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.S3Object;

public class S3Driver {
    public static final String GZIP_ENDING = ".gz";
    public static final String AWS_ACCESS_KEY_ID_ENV_VARIABLE_NAME = "AWS_ACCESS_KEY_ID";
    public static final String AWS_SECRET_ACCESS_KEY_ENV_VARIABLE_NAME = "AWS_SECRET_ACCESS_KEY";
    public static final int MAX_CONNECTIONS = 10000;
    public static final String LINE_SEPARATOR = System.lineSeparator();
    public static final String AWS_REGION_ENV_VARIABLE = "AWS_REGION";
    public static final String DOUBLE_BACKSLASH = "\\\\\\\\";
    public static final String SINGLE_BACKSLASH = "\\\\";
    public static final String UNIX_SEPARATOR = "/";
    public static final int REMOVE_ROOT = 1;
    public static final int MAX_RESPONSE_SIZE_FOR_S3_LISTING = 1000;
    public static final String S3_SCHEME = "s3";
    public static final int IDLE_TIME = 30;
    public static final int TIMEOUT_TIME = 30;
    private static final Environment ENVIRONMENT = new Environment();
    private final S3Client client;
    private final String bucketName;

    @JacocoGenerated
    public S3Driver(String bucketName) {
        this((S3Client)S3Driver.defaultS3Client().build(), bucketName);
    }

    public S3Driver(S3Client s3Client, String bucketName) {
        this.client = s3Client;
        this.bucketName = bucketName;
    }

    @JacocoGenerated
    public static S3Driver fromPermanentCredentialsInEnvironment(String bucketName) {
        S3Driver.verifyThatRequiredEnvVariablesAreInPlace();
        S3Client s3Client = (S3Client)((S3ClientBuilder)S3Driver.defaultS3Client().credentialsProvider((AwsCredentialsProvider)EnvironmentVariableCredentialsProvider.create())).build();
        return new S3Driver(s3Client, bucketName);
    }

    @JacocoGenerated
    public static S3ClientBuilder defaultS3Client() {
        Region region = ENVIRONMENT.readEnvOpt(AWS_REGION_ENV_VARIABLE).map(Region::of).orElse(Region.EU_WEST_1);
        return (S3ClientBuilder)((S3ClientBuilder)S3Client.builder().region(region)).httpClient(S3Driver.httpClientForConcurrentQueries());
    }

    public URI insertFile(UnixPath fullPath, String content) throws IOException {
        if (fullPath.getLastPathElement().endsWith(GZIP_ENDING)) {
            this.insertCompressedFile(fullPath, content);
        } else {
            this.insertUncompressedFile(fullPath, content);
        }
        return this.s3BucketUri().addChild(fullPath).getUri();
    }

    public URI insertFile(UnixPath fullPath, InputStream content) throws IOException {
        this.client.putObject(this.newPutObjectRequest(fullPath), this.createRequestBody(content));
        return this.s3BucketUri().addChild(fullPath).getUri();
    }

    public URI insertEvent(UnixPath folder, String content) throws IOException {
        UnixPath filePath = folder.addChild(String.valueOf(UUID.randomUUID()) + GZIP_ENDING);
        this.insertCompressedFile(filePath, content);
        return this.s3BucketUri().addChild(filePath).getUri();
    }

    public String readEvent(URI uri) {
        return this.readFile(uri);
    }

    public String readFile(URI uri) {
        UnixPath filePath = UriWrapper.fromUri((URI)uri).toS3bucketPath();
        return this.getFile(filePath);
    }

    @Deprecated
    @JacocoGenerated
    public URI insertAndCompressFiles(UnixPath s3Folder, List<String> content) throws IOException {
        return this.insertAndCompressObjects(s3Folder, content);
    }

    @Deprecated
    @JacocoGenerated
    public URI insertAndCompressFiles(List<String> content) throws IOException {
        return this.insertAndCompressObjects(content);
    }

    public URI insertAndCompressObjects(UnixPath s3Folder, List<String> content) throws IOException {
        UnixPath path = this.filenameForZippedFile(s3Folder);
        PutObjectRequest putObjectRequest = this.newPutObjectRequest(path);
        try (InputStream compressedContent = this.compressContent(content);){
            RequestBody requestBody = this.createRequestBody(compressedContent);
            this.client.putObject(putObjectRequest, requestBody);
        }
        return this.s3BucketUri().addChild(path).getUri();
    }

    public URI insertAndCompressObjects(List<String> content) throws IOException {
        return this.insertAndCompressObjects(UnixPath.EMPTY_PATH, content);
    }

    public List<String> getFiles(UnixPath folder) {
        return this.listAllFiles(folder).stream().map(this::getFile).collect(Collectors.toList());
    }

    public List<UnixPath> listAllFiles(URI s3Uri) {
        return this.listAllFiles(UriWrapper.fromUri((URI)s3Uri).toS3bucketPath());
    }

    public List<UnixPath> listAllFiles(UnixPath folder) {
        String currentStartingPoint;
        ListingResult newBatch;
        ListingResult result = ListingResult.emptyResult();
        do {
            currentStartingPoint = result.getListingStartingPoint();
        } while ((result = result.add(newBatch = this.listFiles(this.calculateListingFolder(folder), currentStartingPoint, 1000))).isTruncated());
        return result.getFiles();
    }

    public ListingResult listFiles(UnixPath folder, String listingStartingPoint, int responseSize) {
        ListObjectsV2Response listingResult = this.fetchNewResultsBatch(folder, listingStartingPoint, responseSize);
        List<UnixPath> files = this.extractResultsFromResponse(listingResult);
        return new ListingResult(files, listingResult.nextContinuationToken(), listingResult.isTruncated());
    }

    public String getUncompressedFile(UnixPath file) {
        return this.getUncompressedFile(file, StandardCharsets.UTF_8);
    }

    public String getUncompressedFile(UnixPath file, Charset charset) {
        GetObjectRequest getObjectRequest = this.createGetObjectRequest(file);
        ResponseBytes<GetObjectResponse> response = this.fetchObject(getObjectRequest);
        return response.asString(charset);
    }

    public GZIPInputStream getCompressedFile(UnixPath file) throws IOException {
        GetObjectRequest getObjectRequest = this.createGetObjectRequest(file);
        ResponseInputStream response = this.client.getObject(getObjectRequest);
        return new GZIPInputStream((InputStream)response);
    }

    public String getFile(UnixPath filename, Charset charset) {
        if (this.isCompressed(filename.getLastPathElement())) {
            return (String)Try.attempt(() -> this.getCompressedFile(filename)).map(stream -> this.readCompressedStream((GZIPInputStream)stream, charset)).orElseThrow();
        }
        return this.getUncompressedFile(filename, charset);
    }

    public String getFile(UnixPath filename) {
        return this.getFile(filename, StandardCharsets.UTF_8);
    }

    public void deleteFile(UnixPath filename) {
        this.client.deleteObject(this.createDeleteObjectRequest(filename));
    }

    @JacocoGenerated
    private static SdkHttpClient httpClientForConcurrentQueries() {
        return ApacheHttpClient.builder().useIdleConnectionReaper(Boolean.valueOf(true)).maxConnections(Integer.valueOf(10000)).connectionMaxIdleTime(Duration.ofMinutes(30L)).connectionTimeout(Duration.ofMinutes(30L)).build();
    }

    @JacocoGenerated
    private static void verifyThatRequiredEnvVariablesAreInPlace() {
        ENVIRONMENT.readEnv(AWS_ACCESS_KEY_ID_ENV_VARIABLE_NAME);
        ENVIRONMENT.readEnv(AWS_SECRET_ACCESS_KEY_ENV_VARIABLE_NAME);
    }

    private UnixPath calculateListingFolder(UnixPath folder) {
        return Objects.isNull(folder) || folder.isEmptyPath() || folder.isRoot() ? UnixPath.EMPTY_PATH : folder;
    }

    private UriWrapper s3BucketUri() {
        return new UriWrapper(S3_SCHEME, this.bucketName);
    }

    private void insertUncompressedFile(UnixPath fullPath, String content) throws IOException {
        try (InputStream inputStream = IoUtils.stringToStream((String)content);){
            this.client.putObject(this.newPutObjectRequest(fullPath), this.createRequestBody(inputStream));
        }
    }

    private void insertCompressedFile(UnixPath fullPath, String content) throws IOException {
        try (InputStream inputStream = this.compressContent(List.of(content));){
            this.insertFile(fullPath, inputStream);
        }
    }

    private UnixPath filenameForZippedFile(UnixPath s3Folder) {
        String folderPath = this.processPath(s3Folder);
        return UnixPath.of((String[])new String[]{folderPath, String.valueOf(UUID.randomUUID()) + GZIP_ENDING});
    }

    private String processPath(UnixPath s3Folder) {
        String unixPath = s3Folder.toString().replaceAll(DOUBLE_BACKSLASH, UNIX_SEPARATOR).replaceAll(SINGLE_BACKSLASH, UNIX_SEPARATOR);
        return unixPath.startsWith(UNIX_SEPARATOR) ? unixPath.substring(1) : unixPath;
    }

    private RequestBody createRequestBody(InputStream input) throws IOException {
        byte[] bytes = IoUtils.inputStreamToBytes((InputStream)input);
        return RequestBody.fromBytes((byte[])bytes);
    }

    private InputStream compressContent(List<String> content) throws IOException {
        return new StringCompressor(content).gzippedData();
    }

    private ListObjectsV2Response fetchNewResultsBatch(UnixPath folder, String listingStartingPoint, int responseSize) {
        ListObjectsV2Request request = this.requestForListingFiles(folder, listingStartingPoint, responseSize);
        return this.client.listObjectsV2(request);
    }

    private ResponseBytes<GetObjectResponse> fetchObject(GetObjectRequest getObjectRequest) {
        return (ResponseBytes)this.client.getObject(getObjectRequest, ResponseTransformer.toBytes());
    }

    private String readCompressedStream(GZIPInputStream gzipInputStream, Charset charset) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)gzipInputStream, charset));){
            String string = reader.lines().collect(Collectors.joining(LINE_SEPARATOR));
            return string;
        }
    }

    private boolean isCompressed(String filename) {
        return filename.endsWith(GZIP_ENDING);
    }

    private GetObjectRequest createGetObjectRequest(UnixPath file) {
        return (GetObjectRequest)GetObjectRequest.builder().bucket(this.bucketName).key(file.toString()).build();
    }

    private DeleteObjectRequest createDeleteObjectRequest(UnixPath filename) {
        return (DeleteObjectRequest)DeleteObjectRequest.builder().bucket(this.bucketName).key(filename.toString()).build();
    }

    private List<UnixPath> extractResultsFromResponse(ListObjectsV2Response result) {
        return result.contents().stream().map(S3Object::key).map(xva$0 -> UnixPath.of((String[])new String[]{xva$0})).collect(Collectors.toList());
    }

    private ListObjectsV2Request requestForListingFiles(UnixPath folder, String startingPoint, int responseSize) {
        return (ListObjectsV2Request)ListObjectsV2Request.builder().bucket(this.bucketName).prefix(folder.toString()).continuationToken(startingPoint).maxKeys(Integer.valueOf(responseSize)).build();
    }

    private PutObjectRequest newPutObjectRequest(UnixPath fullPath) {
        return (PutObjectRequest)PutObjectRequest.builder().bucket(this.bucketName).key(fullPath.toString()).build();
    }
}

