/*
 * Decompiled with CFR 0.152.
 */
package nva.commons.secrets;

import com.fasterxml.jackson.databind.JsonNode;
import no.unit.nva.commons.json.JsonUtils;
import nva.commons.core.Environment;
import nva.commons.core.JacocoGenerated;
import nva.commons.core.attempt.Failure;
import nva.commons.core.attempt.Try;
import nva.commons.secrets.ErrorReadingSecretException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.http.urlconnection.UrlConnectionHttpClient;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClient;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClientBuilder;
import software.amazon.awssdk.services.secretsmanager.model.GetSecretValueRequest;
import software.amazon.awssdk.services.secretsmanager.model.GetSecretValueResponse;

public class SecretsReader {
    public static final String COULD_NOT_READ_SECRET_ERROR = "Could not read secret: ";
    private static final Logger logger = LoggerFactory.getLogger(SecretsReader.class);
    private static final String AWS_REGION = new Environment().readEnvOpt("AWS_REGION").orElse(Region.EU_WEST_1.id());
    private final SecretsManagerClient awsSecretsManager;

    @JacocoGenerated
    public SecretsReader() {
        this(SecretsReader.defaultSecretsManagerClient());
    }

    public SecretsReader(SecretsManagerClient awsSecretsManager) {
        this.awsSecretsManager = awsSecretsManager;
    }

    public String fetchSecret(String secretName, String secretKey) {
        return (String)Try.attempt(() -> this.fetchSecretFromAws(secretName)).map(fetchResult -> this.extractApiKey((GetSecretValueResponse)fetchResult, secretKey, secretName)).orElseThrow(this::logErrorAndThrowException);
    }

    public String errorReadingSecretMessage(String secretName) {
        return COULD_NOT_READ_SECRET_ERROR + secretName;
    }

    @JacocoGenerated
    public static SecretsManagerClient defaultSecretsManagerClient() {
        return (SecretsManagerClient)((SecretsManagerClientBuilder)((SecretsManagerClientBuilder)((SecretsManagerClientBuilder)SecretsManagerClient.builder().region(Region.of((String)AWS_REGION))).credentialsProvider((AwsCredentialsProvider)DefaultCredentialsProvider.create())).httpClient(UrlConnectionHttpClient.create())).build();
    }

    private GetSecretValueResponse fetchSecretFromAws(String secretName) {
        return this.awsSecretsManager.getSecretValue((GetSecretValueRequest)GetSecretValueRequest.builder().secretId(secretName).build());
    }

    private String extractApiKey(GetSecretValueResponse getSecretResult, String secretKey, String secretName) {
        return (String)Try.of((Object)getSecretResult).map(GetSecretValueResponse::secretString).flatMap(this::readStringAsJsonObject).map(secretJson -> secretJson.get(secretKey)).map(JsonNode::textValue).orElseThrow(fail -> this.errorReadingSecret((Failure<String>)fail, secretName));
    }

    private ErrorReadingSecretException errorReadingSecret(Failure<String> fail, String secretName) {
        logger.error(this.errorReadingSecretMessage(secretName), (Throwable)fail.getException());
        return new ErrorReadingSecretException();
    }

    private Try<JsonNode> readStringAsJsonObject(String secretString) {
        return Try.attempt(() -> JsonUtils.dtoObjectMapper.readTree(secretString));
    }

    private <I> ErrorReadingSecretException logErrorAndThrowException(Failure<I> failure) {
        logger.error(failure.getException().getMessage(), (Throwable)failure.getException());
        return new ErrorReadingSecretException();
    }
}

