/*
 * Decompiled with CFR 0.152.
 */
package nva.commons.secrets;

import com.amazonaws.services.secretsmanager.AWSSecretsManager;
import com.amazonaws.services.secretsmanager.AWSSecretsManagerClientBuilder;
import com.amazonaws.services.secretsmanager.model.GetSecretValueRequest;
import com.amazonaws.services.secretsmanager.model.GetSecretValueResult;
import com.fasterxml.jackson.databind.JsonNode;
import nva.commons.core.JacocoGenerated;
import nva.commons.core.JsonUtils;
import nva.commons.core.attempt.Failure;
import nva.commons.core.attempt.Try;
import nva.commons.secrets.ErrorReadingSecretException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecretsReader {
    private static final Logger logger = LoggerFactory.getLogger(SecretsReader.class);
    public static final String COULD_NOT_READ_SECRET_ERROR = "Could not read secret: ";
    private final AWSSecretsManager awsSecretsManager;

    @JacocoGenerated
    public SecretsReader() {
        this(AWSSecretsManagerClientBuilder.defaultClient());
    }

    public SecretsReader(AWSSecretsManager awsSecretsManager) {
        this.awsSecretsManager = awsSecretsManager;
    }

    public String fetchSecret(String secretName, String secretKey) throws ErrorReadingSecretException {
        return (String)Try.attempt(() -> this.fetchSecretFromAws(secretName)).map(fetchResult -> this.extractApiKey((GetSecretValueResult)fetchResult, secretKey, secretName)).orElseThrow(this::logErrorAndThrowException);
    }

    private GetSecretValueResult fetchSecretFromAws(String secretName) {
        return this.awsSecretsManager.getSecretValue(new GetSecretValueRequest().withSecretId(secretName));
    }

    private String extractApiKey(GetSecretValueResult getSecretResult, String secretKey, String secretName) throws ErrorReadingSecretException {
        return (String)Try.of((Object)getSecretResult).map(GetSecretValueResult::getSecretString).flatMap(this::readStringAsJsonObject).map(secretJson -> secretJson.get(secretKey)).map(JsonNode::textValue).orElseThrow(fail -> this.errorReadingSecret((Failure<String>)fail, secretName));
    }

    private ErrorReadingSecretException errorReadingSecret(Failure<String> fail, String secretName) {
        logger.error(this.errorReadingSecretMessage(secretName), (Throwable)fail.getException());
        return new ErrorReadingSecretException();
    }

    public String errorReadingSecretMessage(String secretName) {
        return COULD_NOT_READ_SECRET_ERROR + secretName;
    }

    private Try<JsonNode> readStringAsJsonObject(String secretString) {
        return Try.attempt(() -> JsonUtils.objectMapper.readTree(secretString));
    }

    private <I> ErrorReadingSecretException logErrorAndThrowException(Failure<I> failure) {
        logger.error(failure.getException().getMessage(), (Throwable)failure.getException());
        return new ErrorReadingSecretException();
    }
}

