/*
 * Decompiled with CFR 0.152.
 */
package cn.binarywang.wx.miniapp.bean;

import cn.binarywang.wx.miniapp.config.WxMaConfig;
import cn.binarywang.wx.miniapp.util.crypt.WxMaCryptUtils;
import cn.binarywang.wx.miniapp.util.json.WxMaGsonBuilder;
import cn.binarywang.wx.miniapp.util.xml.XStreamTransformer;
import com.google.gson.annotations.SerializedName;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import me.chanjar.weixin.common.util.ToStringUtils;
import me.chanjar.weixin.common.util.xml.XStreamCDataConverter;
import org.apache.commons.io.IOUtils;

@XStreamAlias(value="xml")
public class WxMaMessage
implements Serializable {
    private static final long serialVersionUID = -3586245291677274914L;
    @SerializedName(value="Encrypt")
    @XStreamAlias(value="Encrypt")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String encrypt;
    @SerializedName(value="ToUserName")
    @XStreamAlias(value="ToUserName")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String toUser;
    @SerializedName(value="FromUserName")
    @XStreamAlias(value="FromUserName")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String fromUser;
    @SerializedName(value="CreateTime")
    @XStreamAlias(value="CreateTime")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private Integer createTime;
    @SerializedName(value="MsgDataFormat")
    @XStreamAlias(value="MsgDataFormat")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String msgType;
    @SerializedName(value="Content")
    @XStreamAlias(value="Content")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String content;
    @SerializedName(value="MsgId")
    @XStreamAlias(value="MsgId")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private Long msgId;
    @SerializedName(value="PicUrl")
    @XStreamAlias(value="PicUrl")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String picUrl;
    @SerializedName(value="MediaId")
    @XStreamAlias(value="MediaId")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String mediaId;
    @SerializedName(value="Event")
    @XStreamAlias(value="Event")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String event;
    @SerializedName(value="SessionFrom")
    @XStreamAlias(value="SessionFrom")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String sessionFrom;

    public static WxMaMessage fromXml(String xml) {
        return XStreamTransformer.fromXml(WxMaMessage.class, xml);
    }

    public static WxMaMessage fromXml(InputStream is) {
        return XStreamTransformer.fromXml(WxMaMessage.class, is);
    }

    public static WxMaMessage fromEncryptedXml(String encryptedXml, WxMaConfig wxMaConfig, String timestamp, String nonce, String msgSignature) {
        String plainText = new WxMaCryptUtils(wxMaConfig).decrypt(msgSignature, timestamp, nonce, encryptedXml);
        return WxMaMessage.fromXml(plainText);
    }

    public static WxMaMessage fromEncryptedXml(InputStream is, WxMaConfig wxMaConfig, String timestamp, String nonce, String msgSignature) {
        try {
            return WxMaMessage.fromEncryptedXml(IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8), wxMaConfig, timestamp, nonce, msgSignature);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static WxMaMessage fromJson(String json) {
        return (WxMaMessage)WxMaGsonBuilder.create().fromJson(json, WxMaMessage.class);
    }

    public static WxMaMessage fromEncryptedJson(String encryptedJson, WxMaConfig config) {
        try {
            WxMaMessage encryptedMessage = WxMaMessage.fromJson(encryptedJson);
            String plainText = new WxMaCryptUtils(config).decrypt(encryptedMessage.getEncrypt());
            return WxMaMessage.fromJson(plainText);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static WxMaMessage fromEncryptedJson(InputStream inputStream, WxMaConfig config) {
        try {
            return WxMaMessage.fromEncryptedJson(IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8), config);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return ToStringUtils.toSimpleString((Object)this);
    }

    public String toJson() {
        return WxMaGsonBuilder.create().toJson((Object)this);
    }

    public String getEncrypt() {
        return this.encrypt;
    }

    public String getToUser() {
        return this.toUser;
    }

    public String getFromUser() {
        return this.fromUser;
    }

    public Integer getCreateTime() {
        return this.createTime;
    }

    public String getMsgType() {
        return this.msgType;
    }

    public String getContent() {
        return this.content;
    }

    public Long getMsgId() {
        return this.msgId;
    }

    public String getPicUrl() {
        return this.picUrl;
    }

    public String getMediaId() {
        return this.mediaId;
    }

    public String getEvent() {
        return this.event;
    }

    public String getSessionFrom() {
        return this.sessionFrom;
    }

    public void setEncrypt(String encrypt) {
        this.encrypt = encrypt;
    }

    public void setToUser(String toUser) {
        this.toUser = toUser;
    }

    public void setFromUser(String fromUser) {
        this.fromUser = fromUser;
    }

    public void setCreateTime(Integer createTime) {
        this.createTime = createTime;
    }

    public void setMsgType(String msgType) {
        this.msgType = msgType;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setMsgId(Long msgId) {
        this.msgId = msgId;
    }

    public void setPicUrl(String picUrl) {
        this.picUrl = picUrl;
    }

    public void setMediaId(String mediaId) {
        this.mediaId = mediaId;
    }

    public void setEvent(String event) {
        this.event = event;
    }

    public void setSessionFrom(String sessionFrom) {
        this.sessionFrom = sessionFrom;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WxMaMessage)) {
            return false;
        }
        WxMaMessage other = (WxMaMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$encrypt = this.getEncrypt();
        String other$encrypt = other.getEncrypt();
        if (this$encrypt == null ? other$encrypt != null : !this$encrypt.equals(other$encrypt)) {
            return false;
        }
        String this$toUser = this.getToUser();
        String other$toUser = other.getToUser();
        if (this$toUser == null ? other$toUser != null : !this$toUser.equals(other$toUser)) {
            return false;
        }
        String this$fromUser = this.getFromUser();
        String other$fromUser = other.getFromUser();
        if (this$fromUser == null ? other$fromUser != null : !this$fromUser.equals(other$fromUser)) {
            return false;
        }
        Integer this$createTime = this.getCreateTime();
        Integer other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        String this$msgType = this.getMsgType();
        String other$msgType = other.getMsgType();
        if (this$msgType == null ? other$msgType != null : !this$msgType.equals(other$msgType)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        Long this$msgId = this.getMsgId();
        Long other$msgId = other.getMsgId();
        if (this$msgId == null ? other$msgId != null : !((Object)this$msgId).equals(other$msgId)) {
            return false;
        }
        String this$picUrl = this.getPicUrl();
        String other$picUrl = other.getPicUrl();
        if (this$picUrl == null ? other$picUrl != null : !this$picUrl.equals(other$picUrl)) {
            return false;
        }
        String this$mediaId = this.getMediaId();
        String other$mediaId = other.getMediaId();
        if (this$mediaId == null ? other$mediaId != null : !this$mediaId.equals(other$mediaId)) {
            return false;
        }
        String this$event = this.getEvent();
        String other$event = other.getEvent();
        if (this$event == null ? other$event != null : !this$event.equals(other$event)) {
            return false;
        }
        String this$sessionFrom = this.getSessionFrom();
        String other$sessionFrom = other.getSessionFrom();
        return !(this$sessionFrom == null ? other$sessionFrom != null : !this$sessionFrom.equals(other$sessionFrom));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WxMaMessage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $encrypt = this.getEncrypt();
        result = result * 59 + ($encrypt == null ? 43 : $encrypt.hashCode());
        String $toUser = this.getToUser();
        result = result * 59 + ($toUser == null ? 43 : $toUser.hashCode());
        String $fromUser = this.getFromUser();
        result = result * 59 + ($fromUser == null ? 43 : $fromUser.hashCode());
        Integer $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        String $msgType = this.getMsgType();
        result = result * 59 + ($msgType == null ? 43 : $msgType.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        Long $msgId = this.getMsgId();
        result = result * 59 + ($msgId == null ? 43 : ((Object)$msgId).hashCode());
        String $picUrl = this.getPicUrl();
        result = result * 59 + ($picUrl == null ? 43 : $picUrl.hashCode());
        String $mediaId = this.getMediaId();
        result = result * 59 + ($mediaId == null ? 43 : $mediaId.hashCode());
        String $event = this.getEvent();
        result = result * 59 + ($event == null ? 43 : $event.hashCode());
        String $sessionFrom = this.getSessionFrom();
        result = result * 59 + ($sessionFrom == null ? 43 : $sessionFrom.hashCode());
        return result;
    }
}

