/*
 * Decompiled with CFR 0.152.
 */
package cn.binarywang.wx.miniapp.api.impl;

import cn.binarywang.wx.miniapp.api.WxMaCodeService;
import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.bean.code.WxMaCategory;
import cn.binarywang.wx.miniapp.bean.code.WxMaCodeAuditStatus;
import cn.binarywang.wx.miniapp.bean.code.WxMaCodeCommitRequest;
import cn.binarywang.wx.miniapp.bean.code.WxMaCodeSubmitAuditRequest;
import cn.binarywang.wx.miniapp.bean.code.WxMaCodeVersionDistribution;
import cn.binarywang.wx.miniapp.util.json.WxMaGsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.http.BaseMediaDownloadRequestExecutor;
import me.chanjar.weixin.common.util.http.RequestExecutor;
import me.chanjar.weixin.common.util.http.RequestHttp;
import me.chanjar.weixin.common.util.json.GsonHelper;
import org.apache.commons.lang3.StringUtils;

public class WxMaCodeServiceImpl
implements WxMaCodeService {
    private static final JsonParser JSON_PARSER = new JsonParser();
    private WxMaService wxMaService;

    public WxMaCodeServiceImpl(WxMaService wxMaService) {
        this.wxMaService = wxMaService;
    }

    @Override
    public void commit(WxMaCodeCommitRequest commitRequest) throws WxErrorException {
        this.wxMaService.post("https://api.weixin.qq.com/wxa/commit", commitRequest.toJson());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] getQrCode(String path) throws WxErrorException {
        byte[] byArray;
        String appId = this.wxMaService.getWxMaConfig().getAppid();
        Path qrCodeFilePath = null;
        try {
            RequestExecutor executor = BaseMediaDownloadRequestExecutor.create((RequestHttp)this.wxMaService.getRequestHttp(), (File)Files.createTempDirectory("weixin-java-tools-ma-" + appId, new FileAttribute[0]).toFile());
            StringBuilder url = new StringBuilder("https://api.weixin.qq.com/wxa/get_qrcode");
            if (StringUtils.isNotBlank((CharSequence)path)) {
                url.append("?path=").append(URLEncoder.encode(path, StandardCharsets.UTF_8.name()));
            }
            qrCodeFilePath = ((File)this.wxMaService.execute(executor, url.toString(), null)).toPath();
            byArray = Files.readAllBytes(qrCodeFilePath);
            if (qrCodeFilePath == null) return byArray;
        }
        catch (IOException e) {
            try {
                throw new WxErrorException(WxError.builder().errorMsg(e.getMessage()).build(), (Throwable)e);
            }
            catch (Throwable throwable) {
                if (qrCodeFilePath == null) throw throwable;
                try {
                    Files.delete(qrCodeFilePath);
                    throw throwable;
                }
                catch (Exception ignored) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        try {
            Files.delete(qrCodeFilePath);
            return byArray;
        }
        catch (Exception ignored) {
            // empty catch block
        }
        return byArray;
    }

    @Override
    public List<WxMaCategory> getCategory() throws WxErrorException {
        String responseContent = this.wxMaService.get("https://api.weixin.qq.com/wxa/get_category", null);
        JsonObject jsonObject = JSON_PARSER.parse(responseContent).getAsJsonObject();
        boolean hasCategoryList = jsonObject.has("category_list");
        if (hasCategoryList) {
            return (List)WxMaGsonBuilder.create().fromJson((JsonElement)jsonObject.getAsJsonArray("category_list"), new TypeToken<List<WxMaCategory>>(){}.getType());
        }
        return null;
    }

    @Override
    public List<String> getPage() throws WxErrorException {
        String responseContent = this.wxMaService.get("https://api.weixin.qq.com/wxa/get_page", null);
        JsonObject jsonObject = JSON_PARSER.parse(responseContent).getAsJsonObject();
        boolean hasPageList = jsonObject.has("page_list");
        if (hasPageList) {
            return (List)WxMaGsonBuilder.create().fromJson((JsonElement)jsonObject.getAsJsonArray("page_list"), new TypeToken<List<String>>(){}.getType());
        }
        return null;
    }

    @Override
    public long submitAudit(WxMaCodeSubmitAuditRequest auditRequest) throws WxErrorException {
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/wxa/submit_audit", auditRequest.toJson());
        JsonObject jsonObject = JSON_PARSER.parse(responseContent).getAsJsonObject();
        return GsonHelper.getLong((JsonObject)jsonObject, (String)"auditid");
    }

    @Override
    public WxMaCodeAuditStatus getAuditStatus(long auditId) throws WxErrorException {
        JsonObject param = new JsonObject();
        param.addProperty("auditid", (Number)auditId);
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/wxa/get_auditstatus", param.toString());
        return WxMaCodeAuditStatus.fromJson(responseContent);
    }

    @Override
    public WxMaCodeAuditStatus getLatestAuditStatus() throws WxErrorException {
        String responseContent = this.wxMaService.get("https://api.weixin.qq.com/wxa/get_latest_auditstatus", null);
        return WxMaCodeAuditStatus.fromJson(responseContent);
    }

    @Override
    public void release() throws WxErrorException {
        this.wxMaService.post("https://api.weixin.qq.com/wxa/release", "{}");
    }

    @Override
    public void changeVisitStatus(String action) throws WxErrorException {
        JsonObject param = new JsonObject();
        param.addProperty("action", action);
        this.wxMaService.post("https://api.weixin.qq.com/wxa/change_visitstatus", param.toString());
    }

    @Override
    public void revertCodeRelease() throws WxErrorException {
        this.wxMaService.get("https://api.weixin.qq.com/wxa/revertcoderelease", null);
    }

    @Override
    public WxMaCodeVersionDistribution getSupportVersion() throws WxErrorException {
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/cgi-bin/wxopen/getweappsupportversion", "{}");
        return WxMaCodeVersionDistribution.fromJson(responseContent);
    }

    @Override
    public void setSupportVersion(String version) throws WxErrorException {
        JsonObject param = new JsonObject();
        param.addProperty("version", version);
        this.wxMaService.post("https://api.weixin.qq.com/cgi-bin/wxopen/setweappsupportversion", param.toString());
    }

    @Override
    public void undoCodeAudit() throws WxErrorException {
        this.wxMaService.get("https://api.weixin.qq.com/wxa/undocodeaudit", null);
    }
}

