/*
 * Decompiled with CFR 0.152.
 */
package cn.binarywang.wx.miniapp.config;

import cn.binarywang.wx.miniapp.config.WxMaConfig;
import cn.binarywang.wx.miniapp.util.json.WxMaGsonBuilder;
import com.github.jedis.lock.JedisLock;
import java.io.File;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import me.chanjar.weixin.common.bean.WxAccessToken;
import me.chanjar.weixin.common.util.http.apache.ApacheHttpClientBuilder;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

public class WxMaInRedisConfig
implements WxMaConfig {
    private static final String ACCESS_TOKEN = "accessToken";
    private static final String JSAPI_TICKET = "jsapiTicket";
    private static final String CARD_API_TICKET = "cardApiTicket";
    private static final String HASH_VALUE_FIELD = "value";
    private static final String HASH_EXPIRE_FIELD = "expire";
    protected JedisPool jedisPool;
    protected String maId;
    protected volatile String msgDataFormat;
    protected volatile String appid;
    protected volatile String secret;
    protected volatile String token;
    protected volatile String aesKey;
    protected volatile String httpProxyHost;
    protected volatile int httpProxyPort;
    protected volatile String httpProxyUsername;
    protected volatile String httpProxyPassword;
    protected Lock accessTokenLock;
    protected Lock jsapiTicketLock;
    protected Lock cardApiTicketLock;
    protected volatile File tmpDirFile;
    protected volatile ApacheHttpClientBuilder apacheHttpClientBuilder;

    private String getRedisKey(String key) {
        StringBuilder redisKey = new StringBuilder("maConfig:");
        if (this.maId == null) {
            return redisKey.append(key).toString();
        }
        return redisKey.append(this.maId).append(":").append(key).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getValueFromRedis(String key) {
        try (Jedis jedis = this.jedisPool.getResource();){
            String string = jedis.hget(this.getRedisKey(key), HASH_VALUE_FIELD);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setValueToRedis(String key, long expiresTime, String value) {
        try (Jedis jedis = this.jedisPool.getResource();){
            HashMap<String, String> hash = new HashMap<String, String>();
            hash.put(HASH_VALUE_FIELD, value);
            hash.put(HASH_EXPIRE_FIELD, String.valueOf(expiresTime));
            jedis.hmset(this.getRedisKey(key), hash);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getExpireFromRedis(String key) {
        try (Jedis jedis = this.jedisPool.getResource();){
            String expire = jedis.hget(this.getRedisKey(key), HASH_EXPIRE_FIELD);
            long l = expire == null ? 0L : Long.valueOf(expire);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setExpire(String key, long expiresTime) {
        try (Jedis jedis = this.jedisPool.getResource();){
            jedis.hset(this.getRedisKey(key), HASH_EXPIRE_FIELD, String.valueOf(expiresTime));
        }
    }

    public void setJedisPool(JedisPool jedisPool) {
        this.jedisPool = jedisPool;
    }

    public void setMaId(String maId) {
        this.maId = maId;
    }

    @Override
    public String getAccessToken() {
        return this.getValueFromRedis(ACCESS_TOKEN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Lock getAccessTokenLock() {
        if (this.accessTokenLock == null) {
            WxMaInRedisConfig wxMaInRedisConfig = this;
            synchronized (wxMaInRedisConfig) {
                if (this.accessTokenLock == null) {
                    this.accessTokenLock = new DistributedLock(this.getRedisKey("accessTokenLock"));
                }
            }
        }
        return this.accessTokenLock;
    }

    @Override
    public boolean isAccessTokenExpired() {
        return System.currentTimeMillis() > this.getExpireFromRedis(ACCESS_TOKEN);
    }

    @Override
    public synchronized void updateAccessToken(WxAccessToken accessToken) {
        this.updateAccessToken(accessToken.getAccessToken(), accessToken.getExpiresIn());
    }

    @Override
    public synchronized void updateAccessToken(String accessToken, int expiresInSeconds) {
        this.setValueToRedis(ACCESS_TOKEN, System.currentTimeMillis() + (long)(expiresInSeconds - 200) * 1000L, accessToken);
    }

    @Override
    public String getJsapiTicket() {
        return this.getValueFromRedis(JSAPI_TICKET);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Lock getJsapiTicketLock() {
        if (this.jsapiTicketLock == null) {
            WxMaInRedisConfig wxMaInRedisConfig = this;
            synchronized (wxMaInRedisConfig) {
                if (this.jsapiTicketLock == null) {
                    this.jsapiTicketLock = new DistributedLock(this.getRedisKey("jsapiTicketLock"));
                }
            }
        }
        return this.jsapiTicketLock;
    }

    @Override
    public boolean isJsapiTicketExpired() {
        return System.currentTimeMillis() > this.getExpireFromRedis(JSAPI_TICKET);
    }

    @Override
    public void expireJsapiTicket() {
        this.setExpire(JSAPI_TICKET, 0L);
    }

    @Override
    public void updateJsapiTicket(String jsapiTicket, int expiresInSeconds) {
        this.setValueToRedis(JSAPI_TICKET, System.currentTimeMillis() + (long)(expiresInSeconds - 200) * 1000L, jsapiTicket);
    }

    @Override
    public String getCardApiTicket() {
        return this.getValueFromRedis(CARD_API_TICKET);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Lock getCardApiTicketLock() {
        if (this.cardApiTicketLock == null) {
            WxMaInRedisConfig wxMaInRedisConfig = this;
            synchronized (wxMaInRedisConfig) {
                if (this.cardApiTicketLock == null) {
                    this.cardApiTicketLock = new DistributedLock(this.getRedisKey("cardApiTicketLock"));
                }
            }
        }
        return this.cardApiTicketLock;
    }

    @Override
    public boolean isCardApiTicketExpired() {
        return System.currentTimeMillis() > this.getExpireFromRedis(CARD_API_TICKET);
    }

    @Override
    public void expireCardApiTicket() {
        this.setExpire(CARD_API_TICKET, 0L);
    }

    @Override
    public void updateCardApiTicket(String cardApiTicket, int expiresInSeconds) {
        this.setValueToRedis(CARD_API_TICKET, System.currentTimeMillis() + (long)(expiresInSeconds - 200) * 1000L, cardApiTicket);
    }

    @Override
    public void expireAccessToken() {
        this.setExpire(ACCESS_TOKEN, 0L);
    }

    @Override
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    @Override
    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    @Override
    public long getExpiresTime() {
        return this.getExpireFromRedis(ACCESS_TOKEN);
    }

    @Override
    public String getAesKey() {
        return this.aesKey;
    }

    public void setAesKey(String aesKey) {
        this.aesKey = aesKey;
    }

    @Override
    public String getMsgDataFormat() {
        return this.msgDataFormat;
    }

    public void setMsgDataFormat(String msgDataFormat) {
        this.msgDataFormat = msgDataFormat;
    }

    @Override
    public String getHttpProxyHost() {
        return this.httpProxyHost;
    }

    public void setHttpProxyHost(String httpProxyHost) {
        this.httpProxyHost = httpProxyHost;
    }

    @Override
    public int getHttpProxyPort() {
        return this.httpProxyPort;
    }

    public void setHttpProxyPort(int httpProxyPort) {
        this.httpProxyPort = httpProxyPort;
    }

    @Override
    public String getHttpProxyUsername() {
        return this.httpProxyUsername;
    }

    public void setHttpProxyUsername(String httpProxyUsername) {
        this.httpProxyUsername = httpProxyUsername;
    }

    @Override
    public String getHttpProxyPassword() {
        return this.httpProxyPassword;
    }

    public void setHttpProxyPassword(String httpProxyPassword) {
        this.httpProxyPassword = httpProxyPassword;
    }

    public String toString() {
        return WxMaGsonBuilder.create().toJson((Object)this);
    }

    @Override
    public ApacheHttpClientBuilder getApacheHttpClientBuilder() {
        return this.apacheHttpClientBuilder;
    }

    public void setApacheHttpClientBuilder(ApacheHttpClientBuilder apacheHttpClientBuilder) {
        this.apacheHttpClientBuilder = apacheHttpClientBuilder;
    }

    @Override
    public boolean autoRefreshToken() {
        return true;
    }

    @Override
    public String getAppid() {
        return this.appid;
    }

    public void setAppid(String appid) {
        this.appid = appid;
    }

    private class DistributedLock
    implements Lock {
        private JedisLock lock;

        private DistributedLock(String key) {
            this.lock = new JedisLock(WxMaInRedisConfig.this.getRedisKey(key));
        }

        @Override
        public void lock() {
            try (Jedis jedis = WxMaInRedisConfig.this.jedisPool.getResource();){
                if (!this.lock.acquire(jedis)) {
                    throw new RuntimeException("acquire timeouted");
                }
            }
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            try (Jedis jedis = WxMaInRedisConfig.this.jedisPool.getResource();){
                if (!this.lock.acquire(jedis)) {
                    throw new RuntimeException("acquire timeouted");
                }
            }
        }

        @Override
        public boolean tryLock() {
            try (Jedis jedis = WxMaInRedisConfig.this.jedisPool.getResource();){
                boolean bl = this.lock.acquire(jedis);
                return bl;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
            try (Jedis jedis = WxMaInRedisConfig.this.jedisPool.getResource();){
                boolean bl = this.lock.acquire(jedis);
                return bl;
            }
        }

        @Override
        public void unlock() {
            try (Jedis jedis = WxMaInRedisConfig.this.jedisPool.getResource();){
                this.lock.release(jedis);
            }
        }

        @Override
        public Condition newCondition() {
            throw new RuntimeException("unsupported method");
        }
    }
}

