/*
 * Decompiled with CFR 0.152.
 */
package cn.binarywang.wx.miniapp.message;

import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.bean.WxMaMessage;
import cn.binarywang.wx.miniapp.message.WxMaMessageHandler;
import cn.binarywang.wx.miniapp.message.WxMaMessageInterceptor;
import cn.binarywang.wx.miniapp.message.WxMaMessageMatcher;
import cn.binarywang.wx.miniapp.message.WxMaMessageRouter;
import cn.binarywang.wx.miniapp.message.WxMaXmlOutMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import me.chanjar.weixin.common.api.WxErrorExceptionHandler;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.session.WxSessionManager;

public class WxMaMessageRouterRule {
    private final WxMaMessageRouter routerBuilder;
    private boolean async = true;
    private String fromUser;
    private String msgType;
    private String event;
    private String eventKey;
    private String content;
    private String rContent;
    private String title;
    private WxMaMessageMatcher matcher;
    private boolean reEnter = false;
    private List<WxMaMessageHandler> handlers = new ArrayList<WxMaMessageHandler>();
    private List<WxMaMessageInterceptor> interceptors = new ArrayList<WxMaMessageInterceptor>();

    public WxMaMessageRouterRule(WxMaMessageRouter routerBuilder) {
        this.routerBuilder = routerBuilder;
    }

    public WxMaMessageRouterRule async(boolean async) {
        this.async = async;
        return this;
    }

    public WxMaMessageRouterRule msgType(String msgType) {
        this.msgType = msgType;
        return this;
    }

    public WxMaMessageRouterRule title(String title) {
        this.title = title;
        return this;
    }

    public WxMaMessageRouterRule event(String event) {
        this.event = event;
        return this;
    }

    public WxMaMessageRouterRule eventKey(String eventKey) {
        this.eventKey = eventKey;
        return this;
    }

    public WxMaMessageRouterRule content(String content) {
        this.content = content;
        return this;
    }

    public WxMaMessageRouterRule rContent(String regex) {
        this.rContent = regex;
        return this;
    }

    public WxMaMessageRouterRule fromUser(String fromUser) {
        this.fromUser = fromUser;
        return this;
    }

    public WxMaMessageRouterRule matcher(WxMaMessageMatcher matcher) {
        this.matcher = matcher;
        return this;
    }

    public WxMaMessageRouterRule interceptor(WxMaMessageInterceptor interceptor) {
        return this.interceptor(interceptor, null);
    }

    public WxMaMessageRouterRule interceptor(WxMaMessageInterceptor interceptor, WxMaMessageInterceptor ... otherInterceptors) {
        this.interceptors.add(interceptor);
        if (otherInterceptors != null && otherInterceptors.length > 0) {
            for (WxMaMessageInterceptor i : otherInterceptors) {
                this.interceptors.add(i);
            }
        }
        return this;
    }

    public WxMaMessageRouterRule handler(WxMaMessageHandler handler) {
        return this.handler(handler, null);
    }

    public WxMaMessageRouterRule handler(WxMaMessageHandler handler, WxMaMessageHandler ... otherHandlers) {
        this.handlers.add(handler);
        if (otherHandlers != null && otherHandlers.length > 0) {
            for (WxMaMessageHandler i : otherHandlers) {
                this.handlers.add(i);
            }
        }
        return this;
    }

    public WxMaMessageRouter end() {
        this.routerBuilder.getRules().add(this);
        return this.routerBuilder;
    }

    public WxMaMessageRouter next() {
        this.reEnter = true;
        return this.end();
    }

    protected boolean test(WxMaMessage wxMessage) {
        return !(this.fromUser != null && !this.fromUser.equals(wxMessage.getFromUser()) || this.msgType != null && !this.msgType.toLowerCase().equals(wxMessage.getMsgType() == null ? null : wxMessage.getMsgType().toLowerCase()) || this.event != null && !this.event.toLowerCase().equals(wxMessage.getEvent() == null ? null : wxMessage.getEvent().toLowerCase()) || this.content != null && !this.content.equals(wxMessage.getContent() == null ? null : wxMessage.getContent().trim()) || this.rContent != null && !Pattern.matches(this.rContent, wxMessage.getContent() == null ? "" : wxMessage.getContent().trim()) || this.matcher != null && !this.matcher.match(wxMessage) || this.title != null && !this.title.equals(wxMessage.getTitle() == null ? null : wxMessage.getTitle().trim()));
    }

    protected WxMaXmlOutMessage service(WxMaMessage wxMessage, Map<String, Object> context, WxMaService wxMaService, WxSessionManager sessionManager, WxErrorExceptionHandler exceptionHandler) {
        if (context == null) {
            context = new HashMap<String, Object>(16);
        }
        WxMaXmlOutMessage outMessage = null;
        try {
            for (WxMaMessageInterceptor interceptor : this.interceptors) {
                if (interceptor.intercept(wxMessage, context, wxMaService, sessionManager)) continue;
                return null;
            }
            for (WxMaMessageHandler handler : this.handlers) {
                if (handler == null) continue;
                outMessage = handler.handle(wxMessage, context, wxMaService, sessionManager);
            }
        }
        catch (WxErrorException e) {
            exceptionHandler.handle(e);
        }
        return outMessage;
    }

    public WxMaMessageRouter getRouterBuilder() {
        return this.routerBuilder;
    }

    public boolean isAsync() {
        return this.async;
    }

    public void setAsync(boolean async) {
        this.async = async;
    }

    public String getFromUser() {
        return this.fromUser;
    }

    public void setFromUser(String fromUser) {
        this.fromUser = fromUser;
    }

    public String getMsgType() {
        return this.msgType;
    }

    public void setMsgType(String msgType) {
        this.msgType = msgType;
    }

    public String getEvent() {
        return this.event;
    }

    public void setEvent(String event) {
        this.event = event;
    }

    public String getEventKey() {
        return this.eventKey;
    }

    public void setEventKey(String eventKey) {
        this.eventKey = eventKey;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getrContent() {
        return this.rContent;
    }

    public void setrContent(String rContent) {
        this.rContent = rContent;
    }

    public WxMaMessageMatcher getMatcher() {
        return this.matcher;
    }

    public void setMatcher(WxMaMessageMatcher matcher) {
        this.matcher = matcher;
    }

    public boolean isReEnter() {
        return this.reEnter;
    }

    public void setReEnter(boolean reEnter) {
        this.reEnter = reEnter;
    }

    public List<WxMaMessageHandler> getHandlers() {
        return this.handlers;
    }

    public void setHandlers(List<WxMaMessageHandler> handlers) {
        this.handlers = handlers;
    }

    public List<WxMaMessageInterceptor> getInterceptors() {
        return this.interceptors;
    }

    public void setInterceptors(List<WxMaMessageInterceptor> interceptors) {
        this.interceptors = interceptors;
    }
}

