/*
 * Decompiled with CFR 0.152.
 */
package cn.binarywang.wx.miniapp.api.impl;

import cn.binarywang.wx.miniapp.api.WxMaJsapiService;
import cn.binarywang.wx.miniapp.api.WxMaService;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.concurrent.locks.Lock;
import me.chanjar.weixin.common.bean.WxJsapiSignature;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.RandomUtils;
import me.chanjar.weixin.common.util.crypto.SHA1;

public class WxMaJsapiServiceImpl
implements WxMaJsapiService {
    private static final JsonParser JSON_PARSER = new JsonParser();
    private WxMaService wxMaService;

    @Override
    public String getCardApiTicket() throws WxErrorException {
        return this.getCardApiTicket(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCardApiTicket(boolean forceRefresh) throws WxErrorException {
        Lock lock = this.wxMaService.getWxMaConfig().getCardApiTicketLock();
        try {
            lock.lock();
            if (forceRefresh) {
                this.wxMaService.getWxMaConfig().expireCardApiTicket();
            }
            if (this.wxMaService.getWxMaConfig().isCardApiTicketExpired()) {
                String responseContent = this.wxMaService.get("https://api.weixin.qq.com/cgi-bin/ticket/getticket?type=wx_card", null);
                JsonElement tmpJsonElement = JSON_PARSER.parse(responseContent);
                JsonObject tmpJsonObject = tmpJsonElement.getAsJsonObject();
                String jsapiTicket = tmpJsonObject.get("ticket").getAsString();
                int expiresInSeconds = tmpJsonObject.get("expires_in").getAsInt();
                this.wxMaService.getWxMaConfig().updateCardApiTicket(jsapiTicket, expiresInSeconds);
            }
        }
        finally {
            lock.unlock();
        }
        return this.wxMaService.getWxMaConfig().getCardApiTicket();
    }

    @Override
    public String getJsapiTicket() throws WxErrorException {
        return this.getJsapiTicket(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getJsapiTicket(boolean forceRefresh) throws WxErrorException {
        Lock lock = this.wxMaService.getWxMaConfig().getJsapiTicketLock();
        try {
            lock.lock();
            if (forceRefresh) {
                this.wxMaService.getWxMaConfig().expireJsapiTicket();
            }
            if (this.wxMaService.getWxMaConfig().isJsapiTicketExpired()) {
                String responseContent = this.wxMaService.get("https://api.weixin.qq.com/cgi-bin/ticket/getticket?type=jsapi", null);
                JsonElement tmpJsonElement = JSON_PARSER.parse(responseContent);
                JsonObject tmpJsonObject = tmpJsonElement.getAsJsonObject();
                String jsapiTicket = tmpJsonObject.get("ticket").getAsString();
                int expiresInSeconds = tmpJsonObject.get("expires_in").getAsInt();
                this.wxMaService.getWxMaConfig().updateJsapiTicket(jsapiTicket, expiresInSeconds);
            }
        }
        finally {
            lock.unlock();
        }
        return this.wxMaService.getWxMaConfig().getJsapiTicket();
    }

    @Override
    public WxJsapiSignature createJsapiSignature(String url) throws WxErrorException {
        long timestamp = System.currentTimeMillis() / 1000L;
        String randomStr = RandomUtils.getRandomStr();
        String jsapiTicket = this.getJsapiTicket(false);
        String signature = SHA1.genWithAmple((String[])new String[]{"jsapi_ticket=" + jsapiTicket, "noncestr=" + randomStr, "timestamp=" + timestamp, "url=" + url});
        return WxJsapiSignature.builder().appId(this.wxMaService.getWxMaConfig().getAppid()).timestamp(timestamp).nonceStr(randomStr).url(url).signature(signature).build();
    }

    public WxMaJsapiServiceImpl(WxMaService wxMaService) {
        this.wxMaService = wxMaService;
    }
}

