/*
 * Decompiled with CFR 0.152.
 */
package cn.binarywang.wx.miniapp.config.impl;

import cn.binarywang.wx.miniapp.config.impl.WxMaDefaultConfigImpl;
import com.github.jedis.lock.JedisLock;
import java.io.File;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import redis.clients.jedis.Jedis;

public abstract class AbstractWxMaRedisConfig
extends WxMaDefaultConfigImpl {
    private static final String ACCESS_TOKEN = "accessToken";
    private static final String JSAPI_TICKET = "jsapiTicket";
    private static final String CARD_API_TICKET = "cardApiTicket";
    private static final String HASH_VALUE_FIELD = "value";
    private static final String HASH_EXPIRE_FIELD = "expire";
    private String redisKeyPrefix = "maConfig";
    private String maId;
    private Lock accessTokenLock;
    private Lock jsapiTicketLock;
    private Lock cardApiTicketLock;
    protected volatile File tmpDirFile;
    private JedisConfig jedisConfig;

    protected abstract Jedis getJedis();

    private Jedis getConfiguredJedis() {
        Jedis jedis = this.getJedis();
        if (this.jedisConfig != null) {
            return this.jedisConfig.config(jedis);
        }
        return jedis;
    }

    private String getRedisKey(String key) {
        StringBuilder redisKey = new StringBuilder(this.redisKeyPrefix).append(":");
        if (this.maId == null) {
            return redisKey.append(key).toString();
        }
        return redisKey.append(this.maId).append(":").append(key).toString();
    }

    private String getValueFromRedis(String key) {
        try (Jedis jedis = this.getConfiguredJedis();){
            String string = jedis.hget(this.getRedisKey(key), HASH_VALUE_FIELD);
            return string;
        }
    }

    private void setValueToRedis(String key, long expiresTime, String value) {
        try (Jedis jedis = this.getConfiguredJedis();){
            HashMap<String, String> hash = new HashMap<String, String>();
            hash.put(HASH_VALUE_FIELD, value);
            hash.put(HASH_EXPIRE_FIELD, String.valueOf(expiresTime));
            jedis.hmset(this.getRedisKey(key), hash);
        }
    }

    private long getExpireFromRedis(String key) {
        try (Jedis jedis = this.getConfiguredJedis();){
            String expire = jedis.hget(this.getRedisKey(key), HASH_EXPIRE_FIELD);
            long l = expire == null ? 0L : Long.parseLong(expire);
            return l;
        }
    }

    private void setExpire(String key, long expiresTime) {
        try (Jedis jedis = this.getConfiguredJedis();){
            jedis.hset(this.getRedisKey(key), HASH_EXPIRE_FIELD, String.valueOf(expiresTime));
        }
    }

    public void setRedisKeyPrefix(String redisKeyPrefix) {
        this.redisKeyPrefix = redisKeyPrefix;
    }

    public void setJedisConfig(JedisConfig jedisConfig) {
        this.jedisConfig = jedisConfig;
    }

    public void setMaId(String maId) {
        this.maId = maId;
    }

    @Override
    public String getAccessToken() {
        return this.getValueFromRedis(ACCESS_TOKEN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Lock getAccessTokenLock() {
        if (this.accessTokenLock == null) {
            AbstractWxMaRedisConfig abstractWxMaRedisConfig = this;
            synchronized (abstractWxMaRedisConfig) {
                if (this.accessTokenLock == null) {
                    this.accessTokenLock = new DistributedLock(this.getRedisKey("accessTokenLock"));
                }
            }
        }
        return this.accessTokenLock;
    }

    @Override
    public boolean isAccessTokenExpired() {
        return this.isExpired(this.getExpireFromRedis(ACCESS_TOKEN));
    }

    @Override
    public synchronized void updateAccessToken(String accessToken, int expiresInSeconds) {
        this.setValueToRedis(ACCESS_TOKEN, this.expiresAheadInMillis(expiresInSeconds), accessToken);
    }

    @Override
    public String getJsapiTicket() {
        return this.getValueFromRedis(JSAPI_TICKET);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Lock getJsapiTicketLock() {
        if (this.jsapiTicketLock == null) {
            AbstractWxMaRedisConfig abstractWxMaRedisConfig = this;
            synchronized (abstractWxMaRedisConfig) {
                if (this.jsapiTicketLock == null) {
                    this.jsapiTicketLock = new DistributedLock(this.getRedisKey("jsapiTicketLock"));
                }
            }
        }
        return this.jsapiTicketLock;
    }

    @Override
    public boolean isJsapiTicketExpired() {
        return this.isExpired(this.getExpireFromRedis(JSAPI_TICKET));
    }

    @Override
    public void expireJsapiTicket() {
        this.setExpire(JSAPI_TICKET, 0L);
    }

    @Override
    public void updateJsapiTicket(String jsapiTicket, int expiresInSeconds) {
        this.setValueToRedis(JSAPI_TICKET, this.expiresAheadInMillis(expiresInSeconds), jsapiTicket);
    }

    @Override
    public String getCardApiTicket() {
        return this.getValueFromRedis(CARD_API_TICKET);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Lock getCardApiTicketLock() {
        if (this.cardApiTicketLock == null) {
            AbstractWxMaRedisConfig abstractWxMaRedisConfig = this;
            synchronized (abstractWxMaRedisConfig) {
                if (this.cardApiTicketLock == null) {
                    this.cardApiTicketLock = new DistributedLock(this.getRedisKey("cardApiTicketLock"));
                }
            }
        }
        return this.cardApiTicketLock;
    }

    @Override
    public boolean isCardApiTicketExpired() {
        return this.isExpired(this.getExpireFromRedis(CARD_API_TICKET));
    }

    @Override
    public void expireCardApiTicket() {
        this.setExpire(CARD_API_TICKET, 0L);
    }

    @Override
    public void updateCardApiTicket(String cardApiTicket, int expiresInSeconds) {
        this.setValueToRedis(CARD_API_TICKET, this.expiresAheadInMillis(expiresInSeconds), cardApiTicket);
    }

    @Override
    public void expireAccessToken() {
        this.setExpiresTime(0L);
    }

    @Override
    public long getExpiresTime() {
        return this.getExpireFromRedis(ACCESS_TOKEN);
    }

    @Override
    public void setExpiresTime(long expiresTime) {
        this.setExpire(ACCESS_TOKEN, expiresTime);
    }

    private class DistributedLock
    implements Lock {
        private JedisLock lock;

        private DistributedLock(String key) {
            this.lock = new JedisLock(AbstractWxMaRedisConfig.this.getRedisKey(key));
        }

        @Override
        public void lock() {
            try (Jedis jedis = AbstractWxMaRedisConfig.this.getConfiguredJedis();){
                if (!this.lock.acquire(jedis)) {
                    throw new RuntimeException("acquire timeouted");
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException("lock failed", e);
            }
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            try (Jedis jedis = AbstractWxMaRedisConfig.this.getConfiguredJedis();){
                if (!this.lock.acquire(jedis)) {
                    throw new RuntimeException("acquire timeouted");
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean tryLock() {
            try (Jedis jedis = AbstractWxMaRedisConfig.this.getConfiguredJedis();){
                boolean bl = this.lock.acquire(jedis);
                return bl;
            }
            catch (InterruptedException e) {
                throw new RuntimeException("lock failed", e);
            }
        }

        @Override
        public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
            try (Jedis jedis = AbstractWxMaRedisConfig.this.getConfiguredJedis();){
                boolean bl = this.lock.acquire(jedis);
                return bl;
            }
        }

        @Override
        public void unlock() {
            try (Jedis jedis = AbstractWxMaRedisConfig.this.getConfiguredJedis();){
                this.lock.release(jedis);
            }
        }

        @Override
        public Condition newCondition() {
            throw new RuntimeException("unsupported method");
        }
    }

    public static interface JedisConfig {
        public Jedis config(Jedis var1);
    }
}

