/*
 * Decompiled with CFR 0.152.
 */
package cn.binarywang.wx.miniapp.api.impl;

import cn.binarywang.wx.miniapp.api.WxMaLiveService;
import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.bean.WxMaLiveInfo;
import cn.binarywang.wx.miniapp.bean.WxMaLiveResult;
import cn.binarywang.wx.miniapp.util.json.WxMaGsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.chanjar.weixin.common.WxType;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxMaLiveServiceImpl
implements WxMaLiveService {
    private static final Logger log = LoggerFactory.getLogger(WxMaLiveServiceImpl.class);
    private static final JsonParser JSON_PARSER = new JsonParser();
    private final WxMaService wxMaService;

    @Override
    public Integer createRoom(WxMaLiveInfo.RoomInfo roomInfo) throws WxErrorException {
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/wxaapi/broadcast/room/create", WxMaGsonBuilder.create().toJson((Object)roomInfo));
        JsonObject jsonObject = JSON_PARSER.parse(responseContent).getAsJsonObject();
        if (jsonObject.get("errcode").getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        return jsonObject.get("roomId").getAsInt();
    }

    @Override
    public WxMaLiveResult getLiveInfo(Integer start, Integer limit) throws WxErrorException {
        JsonObject jsonObject = this.getLiveInfo(start, limit, null);
        return WxMaLiveResult.fromJson(jsonObject.toString());
    }

    @Override
    public List<WxMaLiveResult.RoomInfo> getLiveInfos() throws WxErrorException {
        ArrayList<WxMaLiveResult.RoomInfo> results = new ArrayList<WxMaLiveResult.RoomInfo>();
        int start = 0;
        Integer limit = 80;
        Integer total = 0;
        while (total == 0 || total > start) {
            WxMaLiveResult liveInfo = this.getLiveInfo(start, limit);
            if (liveInfo == null) {
                return null;
            }
            results.addAll(liveInfo.getRoomInfos());
            total = liveInfo.getTotal();
            start = results.size();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                log.error("InterruptedException", (Throwable)e);
            }
            if (results.size() <= total) continue;
        }
        return results;
    }

    @Override
    public WxMaLiveResult getLiveReplay(String action, Integer roomId, Integer start, Integer limit) throws WxErrorException {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("action", action);
        map.put("room_id", roomId);
        JsonObject jsonObject = this.getLiveInfo(start, limit, map);
        return WxMaLiveResult.fromJson(jsonObject.toString());
    }

    @Override
    public WxMaLiveResult getLiveReplay(Integer roomId, Integer start, Integer limit) throws WxErrorException {
        return this.getLiveReplay("get_replay", roomId, start, limit);
    }

    @Override
    public boolean addGoodsToRoom(Integer roomId, List<Integer> goodsIds) throws WxErrorException {
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put("roomId", roomId);
        map.put("ids", goodsIds);
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/wxaapi/broadcast/room/addgoods", WxMaGsonBuilder.create().toJson(map));
        JsonObject jsonObject = JSON_PARSER.parse(responseContent).getAsJsonObject();
        if (jsonObject.get("errcode").getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        return true;
    }

    private JsonObject getLiveInfo(Integer start, Integer limit, Map<String, Object> map) throws WxErrorException {
        if (map == null) {
            map = new HashMap<String, Object>(2);
        }
        map.put("start", start);
        map.put("limit", limit);
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/wxa/business/getliveinfo", WxMaGsonBuilder.create().toJson(map));
        JsonObject jsonObject = JSON_PARSER.parse(responseContent).getAsJsonObject();
        if (jsonObject.get("errcode").getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        return jsonObject;
    }

    public WxMaLiveServiceImpl(WxMaService wxMaService) {
        this.wxMaService = wxMaService;
    }
}

