/*
 * Decompiled with CFR 0.152.
 */
package cn.binarywang.wx.miniapp.executor;

import cn.binarywang.wx.miniapp.bean.AbstractWxMaQrcodeWrapper;
import cn.binarywang.wx.miniapp.executor.QrcodeRequestExecutor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.UUID;
import me.chanjar.weixin.common.enums.WxType;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.fs.FileUtils;
import me.chanjar.weixin.common.util.http.RequestHttp;
import me.chanjar.weixin.common.util.http.okhttp.OkHttpProxyInfo;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;

public class OkHttpQrcodeFileRequestExecutor
extends QrcodeRequestExecutor<OkHttpClient, OkHttpProxyInfo> {
    private final String filePath;

    public OkHttpQrcodeFileRequestExecutor(RequestHttp<OkHttpClient, OkHttpProxyInfo> requestHttp, String filePath) {
        super(requestHttp);
        this.filePath = filePath;
    }

    public File execute(String uri, AbstractWxMaQrcodeWrapper qrcodeWrapper, WxType wxType) throws WxErrorException, IOException {
        RequestBody body = RequestBody.Companion.create(qrcodeWrapper.toJson(), MediaType.parse((String)"application/json; charset=utf-8"));
        Request request = new Request.Builder().url(uri).post(body).build();
        Response response = ((OkHttpClient)this.requestHttp.getRequestHttpClient()).newCall(request).execute();
        String contentTypeHeader = response.header("Content-Type");
        if (null != contentTypeHeader && contentTypeHeader.startsWith("application/json")) {
            String responseContent = response.body().string();
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)wxType));
        }
        try (InputStream inputStream = response.body().byteStream();){
            if (StringUtils.isBlank((CharSequence)this.filePath)) {
                File file = FileUtils.createTmpFile((InputStream)inputStream, (String)UUID.randomUUID().toString(), (String)"jpg");
                return file;
            }
            File file = FileUtils.createTmpFile((InputStream)inputStream, (String)UUID.randomUUID().toString(), (String)"jpg", (File)Paths.get(this.filePath, new String[0]).toFile());
            return file;
        }
    }
}

