/*
 * Decompiled with CFR 0.152.
 */
package cn.binarywang.wx.miniapp.api.impl;

import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.api.WxMaVodService;
import cn.binarywang.wx.miniapp.bean.WxMaBaseResponse;
import cn.binarywang.wx.miniapp.bean.vod.WxMaVodApplyUploadRequest;
import cn.binarywang.wx.miniapp.bean.vod.WxMaVodApplyUploadResponse;
import cn.binarywang.wx.miniapp.bean.vod.WxMaVodAuditDramaRequest;
import cn.binarywang.wx.miniapp.bean.vod.WxMaVodAuditDramaResponse;
import cn.binarywang.wx.miniapp.bean.vod.WxMaVodCommitUploadRequest;
import cn.binarywang.wx.miniapp.bean.vod.WxMaVodCommitUploadResponse;
import cn.binarywang.wx.miniapp.bean.vod.WxMaVodDeleteMediaRequest;
import cn.binarywang.wx.miniapp.bean.vod.WxMaVodDramaInfo;
import cn.binarywang.wx.miniapp.bean.vod.WxMaVodGetCdnLogRequest;
import cn.binarywang.wx.miniapp.bean.vod.WxMaVodGetCdnLogResponse;
import cn.binarywang.wx.miniapp.bean.vod.WxMaVodGetCdnUsageRequest;
import cn.binarywang.wx.miniapp.bean.vod.WxMaVodGetCdnUsageResponse;
import cn.binarywang.wx.miniapp.bean.vod.WxMaVodGetDramaRequest;
import cn.binarywang.wx.miniapp.bean.vod.WxMaVodGetDramaResponse;
import cn.binarywang.wx.miniapp.bean.vod.WxMaVodGetMediaLinkRequest;
import cn.binarywang.wx.miniapp.bean.vod.WxMaVodGetMediaLinkResponse;
import cn.binarywang.wx.miniapp.bean.vod.WxMaVodGetMediaRequest;
import cn.binarywang.wx.miniapp.bean.vod.WxMaVodGetMediaResponse;
import cn.binarywang.wx.miniapp.bean.vod.WxMaVodGetTaskRequest;
import cn.binarywang.wx.miniapp.bean.vod.WxMaVodGetTaskResponse;
import cn.binarywang.wx.miniapp.bean.vod.WxMaVodListDramaRequest;
import cn.binarywang.wx.miniapp.bean.vod.WxMaVodListMediaRequest;
import cn.binarywang.wx.miniapp.bean.vod.WxMaVodMediaInfo;
import cn.binarywang.wx.miniapp.bean.vod.WxMaVodMediaPlaybackInfo;
import cn.binarywang.wx.miniapp.bean.vod.WxMaVodPullUploadRequest;
import cn.binarywang.wx.miniapp.bean.vod.WxMaVodPullUploadResponse;
import cn.binarywang.wx.miniapp.bean.vod.WxMaVodSingleFileUploadResult;
import cn.binarywang.wx.miniapp.bean.vod.WxMaVodUploadPartResult;
import cn.binarywang.wx.miniapp.executor.VodSingleUploadRequestExecutor;
import cn.binarywang.wx.miniapp.executor.VodUploadPartRequestExecutor;
import cn.binarywang.wx.miniapp.json.WxMaGsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.util.List;
import me.chanjar.weixin.common.enums.WxType;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.json.GsonParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxMaVodServiceImpl
implements WxMaVodService {
    private static final Logger log = LoggerFactory.getLogger(WxMaVodServiceImpl.class);
    private final WxMaService service;

    @Override
    public List<WxMaVodMediaInfo> listMedia(WxMaVodListMediaRequest mediaRequest) throws WxErrorException {
        String responseContent = this.service.post("https://api.weixin.qq.com/wxa/sec/vod/listmedia", mediaRequest.toJson());
        JsonObject jsonObject = GsonParser.parse((String)responseContent);
        boolean hasMediaInfoList = jsonObject.has("media_info_list");
        if (hasMediaInfoList) {
            return (List)WxMaGsonBuilder.create().fromJson((JsonElement)jsonObject.getAsJsonArray("media_info_list"), new TypeToken<List<WxMaVodMediaInfo>>(){}.getType());
        }
        return null;
    }

    @Override
    public List<WxMaVodDramaInfo> listDrama(WxMaVodListDramaRequest mediaRequest) throws WxErrorException {
        String responseContent = this.service.post("https://api.weixin.qq.com/wxa/sec/vod/listdramas", mediaRequest.toJson());
        JsonObject jsonObject = GsonParser.parse((String)responseContent);
        boolean hasMediaInfoList = jsonObject.has("drama_info_list");
        if (hasMediaInfoList) {
            return (List)WxMaGsonBuilder.create().fromJson((JsonElement)jsonObject.getAsJsonArray("drama_info_list"), new TypeToken<List<WxMaVodDramaInfo>>(){}.getType());
        }
        return null;
    }

    @Override
    public WxMaVodMediaPlaybackInfo getMediaLink(WxMaVodGetMediaLinkRequest request) throws WxErrorException {
        String responseContent = this.service.post("https://api.weixin.qq.com/wxa/sec/vod/getmedialink", request.toJson());
        WxMaVodGetMediaLinkResponse getDetailResponse = (WxMaVodGetMediaLinkResponse)WxMaGsonBuilder.create().fromJson(responseContent, WxMaVodGetMediaLinkResponse.class);
        if (getDetailResponse.getErrcode() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        return getDetailResponse.getMediaInfo();
    }

    @Override
    public WxMaVodMediaInfo getMedia(WxMaVodGetMediaRequest request) throws WxErrorException {
        String responseContent = this.service.post("https://api.weixin.qq.com/wxa/sec/vod/getmedia", request.toJson());
        WxMaVodGetMediaResponse getDetailResponse = (WxMaVodGetMediaResponse)WxMaGsonBuilder.create().fromJson(responseContent, WxMaVodGetMediaResponse.class);
        if (getDetailResponse.getErrcode() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        return getDetailResponse.getMediaInfo();
    }

    @Override
    public boolean deleteMedia(WxMaVodDeleteMediaRequest request) throws WxErrorException {
        String responseContent = this.service.post("https://api.weixin.qq.com/wxa/sec/vod/deletemedia", request.toJson());
        WxMaBaseResponse getDetailResponse = (WxMaBaseResponse)WxMaGsonBuilder.create().fromJson(responseContent, WxMaBaseResponse.class);
        if (getDetailResponse.getErrcode() != 0) {
            throw new WxErrorException(new WxError(getDetailResponse.getErrcode().intValue(), getDetailResponse.getErrmsg()));
        }
        return true;
    }

    @Override
    public WxMaVodDramaInfo getDrama(WxMaVodGetDramaRequest request) throws WxErrorException {
        String responseContent = this.service.post("https://api.weixin.qq.com/wxa/sec/vod/getdrama", request.toJson());
        WxMaVodGetDramaResponse getDetailResponse = (WxMaVodGetDramaResponse)WxMaGsonBuilder.create().fromJson(responseContent, WxMaVodGetDramaResponse.class);
        if (getDetailResponse.getErrcode() != 0) {
            throw new WxErrorException(new WxError(getDetailResponse.getErrcode().intValue(), getDetailResponse.getErrmsg()));
        }
        return getDetailResponse.getDramaInfo();
    }

    @Override
    public Integer auditDrama(WxMaVodAuditDramaRequest request) throws WxErrorException {
        String responseContent = this.service.post("https://api.weixin.qq.com/wxa/sec/vod/auditdrama", request.toJson());
        WxMaVodAuditDramaResponse getDetailResponse = (WxMaVodAuditDramaResponse)WxMaGsonBuilder.create().fromJson(responseContent, WxMaVodAuditDramaResponse.class);
        if (getDetailResponse.getErrcode() != 0) {
            throw new WxErrorException(new WxError(getDetailResponse.getErrcode().intValue(), getDetailResponse.getErrmsg()));
        }
        return getDetailResponse.getDramaId();
    }

    @Override
    public WxMaVodGetCdnUsageResponse getCdnUsageData(WxMaVodGetCdnUsageRequest request) throws WxErrorException {
        String responseContent = this.service.post("https://api.weixin.qq.com/wxa/sec/vod/getcdnusagedata", request.toJson());
        WxMaVodGetCdnUsageResponse getDetailResponse = (WxMaVodGetCdnUsageResponse)WxMaGsonBuilder.create().fromJson(responseContent, WxMaVodGetCdnUsageResponse.class);
        if (getDetailResponse.getErrcode() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        return getDetailResponse;
    }

    @Override
    public WxMaVodGetCdnLogResponse getCdnLogs(WxMaVodGetCdnLogRequest request) throws WxErrorException {
        String responseContent = this.service.post("https://api.weixin.qq.com/wxa/sec/vod/getcdnlogs", request.toJson());
        WxMaVodGetCdnLogResponse getDetailResponse = (WxMaVodGetCdnLogResponse)WxMaGsonBuilder.create().fromJson(responseContent, WxMaVodGetCdnLogResponse.class);
        if (getDetailResponse.getErrcode() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        return getDetailResponse;
    }

    @Override
    public WxMaVodGetTaskResponse getTask(WxMaVodGetTaskRequest request) throws WxErrorException {
        String responseContent = this.service.post("https://api.weixin.qq.com/wxa/sec/vod/gettask", request.toJson());
        WxMaVodGetTaskResponse getDetailResponse = (WxMaVodGetTaskResponse)WxMaGsonBuilder.create().fromJson(responseContent, WxMaVodGetTaskResponse.class);
        if (getDetailResponse.getErrcode() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        return getDetailResponse;
    }

    @Override
    public WxMaVodPullUploadResponse pullUpload(WxMaVodPullUploadRequest request) throws WxErrorException {
        String responseContent = this.service.post("https://api.weixin.qq.com/wxa/sec/vod/pullupload", request.toJson());
        WxMaVodPullUploadResponse getDetailResponse = (WxMaVodPullUploadResponse)WxMaGsonBuilder.create().fromJson(responseContent, WxMaVodPullUploadResponse.class);
        if (getDetailResponse.getErrcode() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        return getDetailResponse;
    }

    @Override
    public WxMaVodSingleFileUploadResult uploadSingleFile(File file, String mediaName, String mediaType) throws WxErrorException {
        WxMaVodSingleFileUploadResult result = this.service.execute(VodSingleUploadRequestExecutor.create(this.service.getRequestHttp(), mediaName, mediaType, null, null, null), "https://api.weixin.qq.com/wxa/sec/vod/singlefileupload", file);
        return result;
    }

    @Override
    public WxMaVodSingleFileUploadResult uploadSingleFile(File file, String mediaName, String mediaType, String coverType, File coverData, String sourceContext) throws WxErrorException {
        WxMaVodSingleFileUploadResult result = this.service.execute(VodSingleUploadRequestExecutor.create(this.service.getRequestHttp(), mediaName, mediaType, coverType, coverData, sourceContext), "https://api.weixin.qq.com/wxa/sec/vod/singlefileupload", file);
        return result;
    }

    @Override
    public WxMaVodApplyUploadResponse applyUpload(WxMaVodApplyUploadRequest request) throws WxErrorException {
        String responseContent = this.service.post("https://api.weixin.qq.com/wxa/sec/vod/applyupload", request.toJson());
        WxMaVodApplyUploadResponse getDetailResponse = (WxMaVodApplyUploadResponse)WxMaGsonBuilder.create().fromJson(responseContent, WxMaVodApplyUploadResponse.class);
        if (getDetailResponse.getErrcode() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        return getDetailResponse;
    }

    @Override
    public WxMaVodCommitUploadResponse commitUpload(WxMaVodCommitUploadRequest request) throws WxErrorException {
        String responseContent = this.service.post("https://api.weixin.qq.com/wxa/sec/vod/commitupload", request.toJson());
        WxMaVodCommitUploadResponse getDetailResponse = (WxMaVodCommitUploadResponse)WxMaGsonBuilder.create().fromJson(responseContent, WxMaVodCommitUploadResponse.class);
        if (getDetailResponse.getErrcode() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        return getDetailResponse;
    }

    @Override
    public WxMaVodUploadPartResult uploadPart(File file, String uploadId, Integer partNumber, Integer resourceType) throws WxErrorException {
        WxMaVodUploadPartResult result = this.service.execute(VodUploadPartRequestExecutor.create(this.service.getRequestHttp(), uploadId, partNumber, resourceType), "https://api.weixin.qq.com/wxa/sec/vod/uploadpart", file);
        return result;
    }

    public WxMaVodServiceImpl(WxMaService service) {
        this.service = service;
    }
}

