/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.mp.api.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.UUID;
import me.chanjar.weixin.common.bean.result.WxError;
import me.chanjar.weixin.common.bean.result.WxMediaUploadResult;
import me.chanjar.weixin.common.exception.WxErrorException;
import me.chanjar.weixin.common.util.fs.FileUtils;
import me.chanjar.weixin.common.util.http.MediaDownloadRequestExecutor;
import me.chanjar.weixin.common.util.http.MediaUploadRequestExecutor;
import me.chanjar.weixin.common.util.json.WxGsonBuilder;
import me.chanjar.weixin.mp.api.WxMpMaterialService;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.bean.WxMpMaterial;
import me.chanjar.weixin.mp.bean.WxMpMaterialArticleUpdate;
import me.chanjar.weixin.mp.bean.WxMpMaterialNews;
import me.chanjar.weixin.mp.bean.result.WxMediaImgUploadResult;
import me.chanjar.weixin.mp.bean.result.WxMpMaterialCountResult;
import me.chanjar.weixin.mp.bean.result.WxMpMaterialFileBatchGetResult;
import me.chanjar.weixin.mp.bean.result.WxMpMaterialNewsBatchGetResult;
import me.chanjar.weixin.mp.bean.result.WxMpMaterialUploadResult;
import me.chanjar.weixin.mp.bean.result.WxMpMaterialVideoInfoResult;
import me.chanjar.weixin.mp.util.http.MaterialDeleteRequestExecutor;
import me.chanjar.weixin.mp.util.http.MaterialNewsInfoRequestExecutor;
import me.chanjar.weixin.mp.util.http.MaterialUploadRequestExecutor;
import me.chanjar.weixin.mp.util.http.MaterialVideoInfoRequestExecutor;
import me.chanjar.weixin.mp.util.http.MaterialVoiceAndImageDownloadRequestExecutor;
import me.chanjar.weixin.mp.util.http.MediaImgUploadRequestExecutor;
import me.chanjar.weixin.mp.util.json.WxMpGsonBuilder;

public class WxMpMaterialServiceImpl
implements WxMpMaterialService {
    private static final String MEDIA_API_URL_PREFIX = "https://api.weixin.qq.com/cgi-bin/media";
    private static final String MATERIAL_API_URL_PREFIX = "https://api.weixin.qq.com/cgi-bin/material";
    private WxMpService wxMpService;

    public WxMpMaterialServiceImpl(WxMpService wxMpService) {
        this.wxMpService = wxMpService;
    }

    @Override
    public WxMediaUploadResult mediaUpload(String mediaType, String fileType, InputStream inputStream) throws WxErrorException, IOException {
        return this.mediaUpload(mediaType, FileUtils.createTmpFile((InputStream)inputStream, (String)UUID.randomUUID().toString(), (String)fileType));
    }

    @Override
    public WxMediaUploadResult mediaUpload(String mediaType, File file) throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/media/upload?type=" + mediaType;
        return (WxMediaUploadResult)this.wxMpService.execute(new MediaUploadRequestExecutor(), url, file);
    }

    @Override
    public File mediaDownload(String media_id) throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/media/get";
        return (File)this.wxMpService.execute(new MediaDownloadRequestExecutor(this.wxMpService.getWxMpConfigStorage().getTmpDirFile()), url, "media_id=" + media_id);
    }

    @Override
    public WxMediaImgUploadResult mediaImgUpload(File file) throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/media/uploadimg";
        return this.wxMpService.execute(new MediaImgUploadRequestExecutor(), url, file);
    }

    @Override
    public WxMpMaterialUploadResult materialFileUpload(String mediaType, WxMpMaterial material) throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/material/add_material?type=" + mediaType;
        return this.wxMpService.execute(new MaterialUploadRequestExecutor(), url, material);
    }

    @Override
    public WxMpMaterialUploadResult materialNewsUpload(WxMpMaterialNews news) throws WxErrorException {
        if (news == null || news.isEmpty()) {
            throw new IllegalArgumentException("news is empty!");
        }
        String url = "https://api.weixin.qq.com/cgi-bin/material/add_news";
        String responseContent = this.wxMpService.post(url, news.toJson());
        return WxMpMaterialUploadResult.fromJson(responseContent);
    }

    @Override
    public InputStream materialImageOrVoiceDownload(String media_id) throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/material/get_material";
        return this.wxMpService.execute(new MaterialVoiceAndImageDownloadRequestExecutor(this.wxMpService.getWxMpConfigStorage().getTmpDirFile()), url, media_id);
    }

    @Override
    public WxMpMaterialVideoInfoResult materialVideoInfo(String media_id) throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/material/get_material";
        return this.wxMpService.execute(new MaterialVideoInfoRequestExecutor(), url, media_id);
    }

    @Override
    public WxMpMaterialNews materialNewsInfo(String media_id) throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/material/get_material";
        return this.wxMpService.execute(new MaterialNewsInfoRequestExecutor(), url, media_id);
    }

    @Override
    public boolean materialNewsUpdate(WxMpMaterialArticleUpdate wxMpMaterialArticleUpdate) throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/material/update_news";
        String responseText = this.wxMpService.post(url, wxMpMaterialArticleUpdate.toJson());
        WxError wxError = WxError.fromJson((String)responseText);
        if (wxError.getErrorCode() == 0) {
            return true;
        }
        throw new WxErrorException(wxError);
    }

    @Override
    public boolean materialDelete(String media_id) throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/material/del_material";
        return this.wxMpService.execute(new MaterialDeleteRequestExecutor(), url, media_id);
    }

    @Override
    public WxMpMaterialCountResult materialCount() throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/material/get_materialcount";
        String responseText = this.wxMpService.get(url, null);
        WxError wxError = WxError.fromJson((String)responseText);
        if (wxError.getErrorCode() == 0) {
            return (WxMpMaterialCountResult)WxMpGsonBuilder.create().fromJson(responseText, WxMpMaterialCountResult.class);
        }
        throw new WxErrorException(wxError);
    }

    @Override
    public WxMpMaterialNewsBatchGetResult materialNewsBatchGet(int offset, int count) throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/material/batchget_material";
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("type", "news");
        params.put("offset", offset);
        params.put("count", count);
        String responseText = this.wxMpService.post(url, WxGsonBuilder.create().toJson(params));
        WxError wxError = WxError.fromJson((String)responseText);
        if (wxError.getErrorCode() == 0) {
            return (WxMpMaterialNewsBatchGetResult)WxMpGsonBuilder.create().fromJson(responseText, WxMpMaterialNewsBatchGetResult.class);
        }
        throw new WxErrorException(wxError);
    }

    @Override
    public WxMpMaterialFileBatchGetResult materialFileBatchGet(String type, int offset, int count) throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/material/batchget_material";
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("type", type);
        params.put("offset", offset);
        params.put("count", count);
        String responseText = this.wxMpService.post(url, WxGsonBuilder.create().toJson(params));
        WxError wxError = WxError.fromJson((String)responseText);
        if (wxError.getErrorCode() == 0) {
            return (WxMpMaterialFileBatchGetResult)WxMpGsonBuilder.create().fromJson(responseText, WxMpMaterialFileBatchGetResult.class);
        }
        throw new WxErrorException(wxError);
    }
}

