/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.mp.api.impl;

import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import me.chanjar.weixin.common.bean.result.WxError;
import me.chanjar.weixin.common.exception.WxErrorException;
import me.chanjar.weixin.common.util.crypto.WxCryptUtil;
import me.chanjar.weixin.common.util.http.Utf8ResponseHandler;
import me.chanjar.weixin.common.util.xml.XStreamInitializer;
import me.chanjar.weixin.mp.api.WxMpPayService;
import me.chanjar.weixin.mp.api.impl.WxMpServiceImpl;
import me.chanjar.weixin.mp.bean.result.WxMpPayCallback;
import me.chanjar.weixin.mp.bean.result.WxMpPayRefundResult;
import me.chanjar.weixin.mp.bean.result.WxMpPayResult;
import me.chanjar.weixin.mp.bean.result.WxMpPrepayIdResult;
import me.chanjar.weixin.mp.bean.result.WxRedpackResult;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxMpPayServiceImpl
implements WxMpPayService {
    private final Logger log = LoggerFactory.getLogger(WxMpPayServiceImpl.class);
    private HttpHost httpProxy;
    private WxMpServiceImpl wxMpService;
    private final String[] REQUIRED_ORDER_PARAMETERS = new String[]{"appid", "mch_id", "body", "out_trade_no", "total_fee", "spbill_create_ip", "notify_url", "trade_type"};

    public WxMpPayServiceImpl(WxMpServiceImpl wxMpService) {
        this.wxMpService = wxMpService;
        this.httpProxy = wxMpService.getHttpProxy();
    }

    @Override
    public WxMpPrepayIdResult getPrepayId(String openId, String outTradeNo, double amt, String body, String tradeType, String ip, String callbackUrl) {
        HashMap<String, String> packageParams = new HashMap<String, String>();
        packageParams.put("appid", this.wxMpService.getWxMpConfigStorage().getAppId());
        packageParams.put("mch_id", this.wxMpService.getWxMpConfigStorage().getPartnerId());
        packageParams.put("body", body);
        packageParams.put("out_trade_no", outTradeNo);
        packageParams.put("total_fee", (int)(amt * 100.0) + "");
        packageParams.put("spbill_create_ip", ip);
        packageParams.put("notify_url", callbackUrl);
        packageParams.put("trade_type", tradeType);
        packageParams.put("openid", openId);
        return this.getPrepayId(packageParams);
    }

    /*
     * Exception decompiling
     */
    @Override
    public WxMpPrepayIdResult getPrepayId(Map<String, String> parameters) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void checkParameters(Map<String, String> parameters) {
        for (String para : this.REQUIRED_ORDER_PARAMETERS) {
            if (parameters.containsKey(para)) continue;
            throw new IllegalArgumentException("Reqiured argument '" + para + "' is missing.");
        }
        if ("JSAPI".equals(parameters.get("trade_type")) && !parameters.containsKey("openid")) {
            throw new IllegalArgumentException("Reqiured argument 'openid' is missing when trade_type is 'JSAPI'.");
        }
        if ("NATIVE".equals(parameters.get("trade_type")) && !parameters.containsKey("product_id")) {
            throw new IllegalArgumentException("Reqiured argument 'product_id' is missing when trade_type is 'NATIVE'.");
        }
    }

    @Override
    public Map<String, String> getJsapiPayInfo(String openId, String outTradeNo, double amt, String body, String ip, String callbackUrl) throws WxErrorException {
        HashMap<String, String> packageParams = new HashMap<String, String>();
        packageParams.put("appid", this.wxMpService.getWxMpConfigStorage().getAppId());
        packageParams.put("mch_id", this.wxMpService.getWxMpConfigStorage().getPartnerId());
        packageParams.put("body", body);
        packageParams.put("out_trade_no", outTradeNo);
        packageParams.put("total_fee", (int)(amt * 100.0) + "");
        packageParams.put("spbill_create_ip", ip);
        packageParams.put("notify_url", callbackUrl);
        packageParams.put("trade_type", "JSAPI");
        packageParams.put("openid", openId);
        return this.getPayInfo(packageParams);
    }

    @Override
    public Map<String, String> getNativePayInfo(String productId, String outTradeNo, double amt, String body, String ip, String callbackUrl) throws WxErrorException {
        HashMap<String, String> packageParams = new HashMap<String, String>();
        packageParams.put("appid", this.wxMpService.getWxMpConfigStorage().getAppId());
        packageParams.put("mch_id", this.wxMpService.getWxMpConfigStorage().getPartnerId());
        packageParams.put("body", body);
        packageParams.put("out_trade_no", outTradeNo);
        packageParams.put("total_fee", (int)(amt * 100.0) + "");
        packageParams.put("spbill_create_ip", ip);
        packageParams.put("notify_url", callbackUrl);
        packageParams.put("trade_type", "NATIVE");
        packageParams.put("product_id", productId);
        return this.getPayInfo(packageParams);
    }

    @Override
    public Map<String, String> getPayInfo(Map<String, String> parameters) throws WxErrorException {
        WxMpPrepayIdResult wxMpPrepayIdResult = this.getPrepayId(parameters);
        if (!"SUCCESS".equalsIgnoreCase(wxMpPrepayIdResult.getReturn_code()) || !"SUCCESS".equalsIgnoreCase(wxMpPrepayIdResult.getResult_code())) {
            WxError error = new WxError();
            error.setErrorCode(-1);
            error.setErrorMsg("return_code:" + wxMpPrepayIdResult.getReturn_code() + ";return_msg:" + wxMpPrepayIdResult.getReturn_msg() + ";result_code:" + wxMpPrepayIdResult.getResult_code() + ";err_code" + wxMpPrepayIdResult.getErr_code() + ";err_code_des" + wxMpPrepayIdResult.getErr_code_des());
            throw new WxErrorException(error);
        }
        String prepayId = wxMpPrepayIdResult.getPrepay_id();
        if (prepayId == null || prepayId.equals("")) {
            throw new RuntimeException(String.format("Failed to get prepay id due to error code '%s'(%s).", wxMpPrepayIdResult.getErr_code(), wxMpPrepayIdResult.getErr_code_des()));
        }
        HashMap<String, String> payInfo = new HashMap<String, String>();
        payInfo.put("appId", this.wxMpService.getWxMpConfigStorage().getAppId());
        payInfo.put("timeStamp", String.valueOf(System.currentTimeMillis() / 1000L));
        payInfo.put("nonceStr", System.currentTimeMillis() + "");
        payInfo.put("package", "prepay_id=" + prepayId);
        payInfo.put("signType", "MD5");
        if ("NATIVE".equals(parameters.get("trade_type"))) {
            payInfo.put("codeUrl", wxMpPrepayIdResult.getCode_url());
        }
        String finalSign = WxCryptUtil.createSign(payInfo, (String)this.wxMpService.getWxMpConfigStorage().getPartnerKey());
        payInfo.put("paySign", finalSign);
        return payInfo;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public WxMpPayResult getJSSDKPayResult(String transactionId, String outTradeNo) {
        String nonce_str = System.currentTimeMillis() + "";
        TreeMap<String, String> packageParams = new TreeMap<String, String>();
        packageParams.put("appid", this.wxMpService.getWxMpConfigStorage().getAppId());
        packageParams.put("mch_id", this.wxMpService.getWxMpConfigStorage().getPartnerId());
        if (transactionId != null && !"".equals(transactionId.trim())) {
            packageParams.put("transaction_id", transactionId);
        } else {
            if (outTradeNo == null) throw new IllegalArgumentException("Either 'transactionId' or 'outTradeNo' must be given.");
            if ("".equals(outTradeNo.trim())) throw new IllegalArgumentException("Either 'transactionId' or 'outTradeNo' must be given.");
            packageParams.put("out_trade_no", outTradeNo);
        }
        packageParams.put("nonce_str", nonce_str);
        packageParams.put("sign", WxCryptUtil.createSign(packageParams, (String)this.wxMpService.getWxMpConfigStorage().getPartnerKey()));
        StringBuilder request = new StringBuilder("<xml>");
        for (Map.Entry para : packageParams.entrySet()) {
            request.append(String.format("<%s>%s</%s>", para.getKey(), para.getValue(), para.getKey()));
        }
        request.append("</xml>");
        HttpPost httpPost = new HttpPost("https://api.mch.weixin.qq.com/pay/orderquery");
        if (this.httpProxy != null) {
            RequestConfig config = RequestConfig.custom().setProxy(this.httpProxy).build();
            httpPost.setConfig(config);
        }
        StringEntity entity = new StringEntity(request.toString(), Consts.UTF_8);
        httpPost.setEntity((HttpEntity)entity);
        try (CloseableHttpResponse response = this.wxMpService.getHttpclient().execute((HttpUriRequest)httpPost);){
            String responseContent = (String)Utf8ResponseHandler.INSTANCE.handleResponse((HttpResponse)response);
            XStream xstream = XStreamInitializer.getInstance();
            xstream.alias("xml", WxMpPayResult.class);
            WxMpPayResult wxMpPayResult = (WxMpPayResult)xstream.fromXML(responseContent);
            return wxMpPayResult;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to query order due to IO exception.", e);
        }
    }

    @Override
    public WxMpPayCallback getJSSDKCallbackData(String xmlData) {
        try {
            XStream xstream = XStreamInitializer.getInstance();
            xstream.alias("xml", WxMpPayCallback.class);
            return (WxMpPayCallback)xstream.fromXML(xmlData);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new WxMpPayCallback();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public WxMpPayRefundResult refundPay(Map<String, String> parameters) throws WxErrorException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public boolean checkJSSDKCallbackDataSignature(Map<String, String> kvm, String signature) {
        return signature.equals(WxCryptUtil.createSign(kvm, (String)this.wxMpService.getWxMpConfigStorage().getPartnerKey()));
    }

    /*
     * Exception decompiling
     */
    @Override
    public WxRedpackResult sendRedpack(Map<String, String> parameters) throws WxErrorException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

