/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.mp.util.http;

import com.google.gson.JsonSyntaxException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import me.chanjar.weixin.common.bean.result.WxError;
import me.chanjar.weixin.common.exception.WxErrorException;
import me.chanjar.weixin.common.util.http.InputStreamResponseHandler;
import me.chanjar.weixin.common.util.http.RequestExecutor;
import me.chanjar.weixin.common.util.json.WxGsonBuilder;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;

public class MaterialVoiceAndImageDownloadRequestExecutor
implements RequestExecutor<InputStream, String> {
    private File tmpDirFile;

    public MaterialVoiceAndImageDownloadRequestExecutor() {
    }

    public MaterialVoiceAndImageDownloadRequestExecutor(File tmpDirFile) {
        this.tmpDirFile = tmpDirFile;
    }

    /*
     * Loose catch block
     */
    public InputStream execute(CloseableHttpClient httpclient, HttpHost httpProxy, String uri, String materialId) throws WxErrorException, IOException {
        HttpPost httpPost = new HttpPost(uri);
        if (httpProxy != null) {
            RequestConfig config = RequestConfig.custom().setProxy(httpProxy).build();
            httpPost.setConfig(config);
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("media_id", materialId);
        httpPost.setEntity((HttpEntity)new StringEntity(WxGsonBuilder.create().toJson(params)));
        try {
            try (CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpPost);){
                InputStream inputStream = (InputStream)InputStreamResponseHandler.INSTANCE.handleResponse((HttpResponse)response);
                byte[] responseContent = IOUtils.toByteArray((InputStream)inputStream);
                String responseContentString = new String(responseContent, "UTF-8");
                if (responseContentString.length() < 100) {
                    try {
                        WxError wxError = (WxError)WxGsonBuilder.create().fromJson(responseContentString, WxError.class);
                        if (wxError.getErrorCode() != 0) {
                            throw new WxErrorException(wxError);
                        }
                    }
                    catch (JsonSyntaxException ex) {
                        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(responseContent);
                        if (response != null) {
                            if (var8_8 != null) {
                                try {
                                    response.close();
                                }
                                catch (Throwable x2) {
                                    var8_8.addSuppressed(x2);
                                }
                            } else {
                                response.close();
                            }
                        }
                        httpPost.releaseConnection();
                        return byteArrayInputStream;
                    }
                }
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(responseContent);
                return byteArrayInputStream;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            httpPost.releaseConnection();
        }
    }
}

