/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.open.api.impl;

import java.util.concurrent.TimeUnit;
import me.chanjar.weixin.open.api.impl.AbstractWxOpenInRedisConfigStorage;
import org.redisson.api.RedissonClient;

public class WxOpenInRedissonConfigStorage
extends AbstractWxOpenInRedisConfigStorage {
    private RedissonClient redissonClient;

    public WxOpenInRedissonConfigStorage(RedissonClient redissonClient, String keyPrefix) {
        this.keyPrefix = keyPrefix;
        this.redissonClient = redissonClient;
    }

    public WxOpenInRedissonConfigStorage(RedissonClient redissonClient) {
        this.redissonClient = redissonClient;
    }

    @Override
    public String getComponentVerifyTicket() {
        Object value = this.redissonClient.getBucket(this.componentVerifyTicketKey).get();
        return value == null ? null : value.toString();
    }

    @Override
    public void setComponentVerifyTicket(String componentVerifyTicket) {
        this.redissonClient.getBucket(this.componentVerifyTicketKey).set((Object)componentVerifyTicket);
    }

    @Override
    public String getComponentAccessToken() {
        Object value = this.redissonClient.getBucket(this.componentAccessTokenKey).get();
        return value == null ? null : value.toString();
    }

    @Override
    public boolean isComponentAccessTokenExpired() {
        return this.redissonClient.getBucket(this.componentAccessTokenKey).remainTimeToLive() < 2L;
    }

    @Override
    public void expireComponentAccessToken() {
        this.redissonClient.getBucket(this.componentAccessTokenKey).expire(0L, TimeUnit.SECONDS);
    }

    @Override
    public void updateComponentAccessToken(String componentAccessToken, int expiresInSeconds) {
        this.redissonClient.getBucket(this.componentAccessTokenKey).set((Object)componentAccessToken, (long)(expiresInSeconds - 200), TimeUnit.SECONDS);
    }

    @Override
    public String getAuthorizerRefreshToken(String appId) {
        Object value = this.redissonClient.getBucket(this.getKey(this.authorizerRefreshTokenKey, appId)).get();
        return value == null ? null : value.toString();
    }

    @Override
    public void setAuthorizerRefreshToken(String appId, String authorizerRefreshToken) {
        this.redissonClient.getBucket(this.getKey(this.authorizerRefreshTokenKey, appId)).set((Object)authorizerRefreshToken);
    }

    @Override
    public String getAuthorizerAccessToken(String appId) {
        Object value = this.redissonClient.getBucket(this.getKey(this.authorizerAccessTokenKey, appId)).get();
        return value == null ? null : value.toString();
    }

    @Override
    public boolean isAuthorizerAccessTokenExpired(String appId) {
        return this.redissonClient.getBucket(this.getKey(this.authorizerAccessTokenKey, appId)).remainTimeToLive() < 2L;
    }

    @Override
    public void expireAuthorizerAccessToken(String appId) {
        this.redissonClient.getBucket(this.getKey(this.authorizerAccessTokenKey, appId)).expire(0L, TimeUnit.SECONDS);
    }

    @Override
    public void updateAuthorizerAccessToken(String appId, String authorizerAccessToken, int expiresInSeconds) {
        this.redissonClient.getBucket(this.getKey(this.authorizerAccessTokenKey, appId)).set((Object)authorizerAccessToken, (long)(expiresInSeconds - 200), TimeUnit.SECONDS);
    }

    @Override
    public String getJsapiTicket(String appId) {
        Object value = this.redissonClient.getBucket(this.getKey(this.jsapiTicketKey, appId)).get();
        return value == null ? null : value.toString();
    }

    @Override
    public boolean isJsapiTicketExpired(String appId) {
        return this.redissonClient.getBucket(this.getKey(this.jsapiTicketKey, appId)).remainTimeToLive() < 2L;
    }

    @Override
    public void expireJsapiTicket(String appId) {
        this.redissonClient.getBucket(this.getKey(this.jsapiTicketKey, appId)).expire(0L, TimeUnit.SECONDS);
    }

    @Override
    public void updateJsapiTicket(String appId, String jsapiTicket, int expiresInSeconds) {
        this.redissonClient.getBucket(this.getKey(this.jsapiTicketKey, appId)).set((Object)jsapiTicket, (long)(expiresInSeconds - 200), TimeUnit.SECONDS);
    }

    @Override
    public String getCardApiTicket(String appId) {
        Object value = this.redissonClient.getBucket(this.getKey(this.cardApiTicket, appId)).get();
        return value == null ? null : value.toString();
    }

    @Override
    public boolean isCardApiTicketExpired(String appId) {
        return this.redissonClient.getBucket(this.getKey(this.cardApiTicket, appId)).remainTimeToLive() < 2L;
    }

    @Override
    public void expireCardApiTicket(String appId) {
        this.redissonClient.getBucket(this.getKey(this.cardApiTicket, appId)).expire(0L, TimeUnit.SECONDS);
    }

    @Override
    public void updateCardApiTicket(String appId, String cardApiTicket, int expiresInSeconds) {
        this.redissonClient.getBucket(this.getKey(this.cardApiTicket, appId)).set((Object)cardApiTicket, (long)(expiresInSeconds - 200), TimeUnit.SECONDS);
    }
}

