/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.open.bean.message;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import me.chanjar.weixin.common.error.WxRuntimeException;
import me.chanjar.weixin.common.util.xml.XStreamCDataConverter;
import me.chanjar.weixin.mp.bean.message.WxMpXmlMessage;
import me.chanjar.weixin.mp.bean.message.WxMpXmlOutMessage;
import me.chanjar.weixin.open.api.WxOpenConfigStorage;
import me.chanjar.weixin.open.util.WxOpenCryptUtil;
import me.chanjar.weixin.open.util.xml.XStreamTransformer;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XStreamAlias(value="xml")
public class WxOpenXmlMessage
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(WxOpenXmlMessage.class);
    private static final long serialVersionUID = -5641769554709507771L;
    @XStreamAlias(value="AppId")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String appId;
    @XStreamAlias(value="CreateTime")
    private Long createTime;
    @XStreamAlias(value="InfoType")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String infoType;
    @XStreamAlias(value="ComponentVerifyTicket")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String componentVerifyTicket;
    @XStreamAlias(value="AuthorizerAppid")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String authorizerAppid;
    @XStreamAlias(value="AuthorizationCode")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String authorizationCode;
    @XStreamAlias(value="AuthorizationCodeExpiredTime")
    private Long authorizationCodeExpiredTime;
    @XStreamAlias(value="PreAuthCode")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String preAuthCode;
    @XStreamAlias(value="appid")
    private String registAppId;
    @XStreamAlias(value="status")
    private int status;
    @XStreamAlias(value="auth_code")
    private String authCode;
    @XStreamAlias(value="msg")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String msg;
    @XStreamAlias(value="info")
    private Info info = new Info();

    public static String wxMpOutXmlMessageToEncryptedXml(WxMpXmlOutMessage message, WxOpenConfigStorage wxOpenConfigStorage) {
        String plainXml = message.toXml();
        WxOpenCryptUtil pc = new WxOpenCryptUtil(wxOpenConfigStorage);
        return pc.encrypt(plainXml);
    }

    public static WxOpenXmlMessage fromXml(String xml) {
        xml = xml.replace("</PicList><PicList>", "");
        return XStreamTransformer.fromXml(WxOpenXmlMessage.class, xml);
    }

    public static WxOpenXmlMessage fromXml(InputStream is) {
        return XStreamTransformer.fromXml(WxOpenXmlMessage.class, is);
    }

    public static WxOpenXmlMessage fromEncryptedXml(String encryptedXml, WxOpenConfigStorage wxOpenConfigStorage, String timestamp, String nonce, String msgSignature) {
        WxOpenCryptUtil cryptUtil = new WxOpenCryptUtil(wxOpenConfigStorage);
        String plainText = cryptUtil.decryptXml(msgSignature, timestamp, nonce, encryptedXml);
        log.debug("\u89e3\u5bc6\u540e\u7684\u539f\u59cbxml\u6d88\u606f\u5185\u5bb9\uff1a{}", (Object)plainText);
        return WxOpenXmlMessage.fromXml(plainText);
    }

    public static WxMpXmlMessage fromEncryptedMpXml(String encryptedXml, WxOpenConfigStorage wxOpenConfigStorage, String timestamp, String nonce, String msgSignature) {
        WxOpenCryptUtil cryptUtil = new WxOpenCryptUtil(wxOpenConfigStorage);
        String plainText = cryptUtil.decryptXml(msgSignature, timestamp, nonce, encryptedXml);
        return WxMpXmlMessage.fromXml((String)plainText);
    }

    public static WxOpenXmlMessage fromEncryptedXml(InputStream is, WxOpenConfigStorage wxOpenConfigStorage, String timestamp, String nonce, String msgSignature) {
        try {
            return WxOpenXmlMessage.fromEncryptedXml(IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8), wxOpenConfigStorage, timestamp, nonce, msgSignature);
        }
        catch (IOException e) {
            throw new WxRuntimeException((Throwable)e);
        }
    }

    public String getAppId() {
        return this.appId;
    }

    public Long getCreateTime() {
        return this.createTime;
    }

    public String getInfoType() {
        return this.infoType;
    }

    public String getComponentVerifyTicket() {
        return this.componentVerifyTicket;
    }

    public String getAuthorizerAppid() {
        return this.authorizerAppid;
    }

    public String getAuthorizationCode() {
        return this.authorizationCode;
    }

    public Long getAuthorizationCodeExpiredTime() {
        return this.authorizationCodeExpiredTime;
    }

    public String getPreAuthCode() {
        return this.preAuthCode;
    }

    public String getRegistAppId() {
        return this.registAppId;
    }

    public int getStatus() {
        return this.status;
    }

    public String getAuthCode() {
        return this.authCode;
    }

    public String getMsg() {
        return this.msg;
    }

    public Info getInfo() {
        return this.info;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
    }

    public void setInfoType(String infoType) {
        this.infoType = infoType;
    }

    public void setComponentVerifyTicket(String componentVerifyTicket) {
        this.componentVerifyTicket = componentVerifyTicket;
    }

    public void setAuthorizerAppid(String authorizerAppid) {
        this.authorizerAppid = authorizerAppid;
    }

    public void setAuthorizationCode(String authorizationCode) {
        this.authorizationCode = authorizationCode;
    }

    public void setAuthorizationCodeExpiredTime(Long authorizationCodeExpiredTime) {
        this.authorizationCodeExpiredTime = authorizationCodeExpiredTime;
    }

    public void setPreAuthCode(String preAuthCode) {
        this.preAuthCode = preAuthCode;
    }

    public void setRegistAppId(String registAppId) {
        this.registAppId = registAppId;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setAuthCode(String authCode) {
        this.authCode = authCode;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public void setInfo(Info info) {
        this.info = info;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WxOpenXmlMessage)) {
            return false;
        }
        WxOpenXmlMessage other = (WxOpenXmlMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$appId = this.getAppId();
        String other$appId = other.getAppId();
        if (this$appId == null ? other$appId != null : !this$appId.equals(other$appId)) {
            return false;
        }
        Long this$createTime = this.getCreateTime();
        Long other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        String this$infoType = this.getInfoType();
        String other$infoType = other.getInfoType();
        if (this$infoType == null ? other$infoType != null : !this$infoType.equals(other$infoType)) {
            return false;
        }
        String this$componentVerifyTicket = this.getComponentVerifyTicket();
        String other$componentVerifyTicket = other.getComponentVerifyTicket();
        if (this$componentVerifyTicket == null ? other$componentVerifyTicket != null : !this$componentVerifyTicket.equals(other$componentVerifyTicket)) {
            return false;
        }
        String this$authorizerAppid = this.getAuthorizerAppid();
        String other$authorizerAppid = other.getAuthorizerAppid();
        if (this$authorizerAppid == null ? other$authorizerAppid != null : !this$authorizerAppid.equals(other$authorizerAppid)) {
            return false;
        }
        String this$authorizationCode = this.getAuthorizationCode();
        String other$authorizationCode = other.getAuthorizationCode();
        if (this$authorizationCode == null ? other$authorizationCode != null : !this$authorizationCode.equals(other$authorizationCode)) {
            return false;
        }
        Long this$authorizationCodeExpiredTime = this.getAuthorizationCodeExpiredTime();
        Long other$authorizationCodeExpiredTime = other.getAuthorizationCodeExpiredTime();
        if (this$authorizationCodeExpiredTime == null ? other$authorizationCodeExpiredTime != null : !((Object)this$authorizationCodeExpiredTime).equals(other$authorizationCodeExpiredTime)) {
            return false;
        }
        String this$preAuthCode = this.getPreAuthCode();
        String other$preAuthCode = other.getPreAuthCode();
        if (this$preAuthCode == null ? other$preAuthCode != null : !this$preAuthCode.equals(other$preAuthCode)) {
            return false;
        }
        String this$registAppId = this.getRegistAppId();
        String other$registAppId = other.getRegistAppId();
        if (this$registAppId == null ? other$registAppId != null : !this$registAppId.equals(other$registAppId)) {
            return false;
        }
        if (this.getStatus() != other.getStatus()) {
            return false;
        }
        String this$authCode = this.getAuthCode();
        String other$authCode = other.getAuthCode();
        if (this$authCode == null ? other$authCode != null : !this$authCode.equals(other$authCode)) {
            return false;
        }
        String this$msg = this.getMsg();
        String other$msg = other.getMsg();
        if (this$msg == null ? other$msg != null : !this$msg.equals(other$msg)) {
            return false;
        }
        Info this$info = this.getInfo();
        Info other$info = other.getInfo();
        return !(this$info == null ? other$info != null : !((Object)this$info).equals(other$info));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WxOpenXmlMessage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $appId = this.getAppId();
        result = result * 59 + ($appId == null ? 43 : $appId.hashCode());
        Long $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        String $infoType = this.getInfoType();
        result = result * 59 + ($infoType == null ? 43 : $infoType.hashCode());
        String $componentVerifyTicket = this.getComponentVerifyTicket();
        result = result * 59 + ($componentVerifyTicket == null ? 43 : $componentVerifyTicket.hashCode());
        String $authorizerAppid = this.getAuthorizerAppid();
        result = result * 59 + ($authorizerAppid == null ? 43 : $authorizerAppid.hashCode());
        String $authorizationCode = this.getAuthorizationCode();
        result = result * 59 + ($authorizationCode == null ? 43 : $authorizationCode.hashCode());
        Long $authorizationCodeExpiredTime = this.getAuthorizationCodeExpiredTime();
        result = result * 59 + ($authorizationCodeExpiredTime == null ? 43 : ((Object)$authorizationCodeExpiredTime).hashCode());
        String $preAuthCode = this.getPreAuthCode();
        result = result * 59 + ($preAuthCode == null ? 43 : $preAuthCode.hashCode());
        String $registAppId = this.getRegistAppId();
        result = result * 59 + ($registAppId == null ? 43 : $registAppId.hashCode());
        result = result * 59 + this.getStatus();
        String $authCode = this.getAuthCode();
        result = result * 59 + ($authCode == null ? 43 : $authCode.hashCode());
        String $msg = this.getMsg();
        result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
        Info $info = this.getInfo();
        result = result * 59 + ($info == null ? 43 : ((Object)$info).hashCode());
        return result;
    }

    public String toString() {
        return "WxOpenXmlMessage(appId=" + this.getAppId() + ", createTime=" + this.getCreateTime() + ", infoType=" + this.getInfoType() + ", componentVerifyTicket=" + this.getComponentVerifyTicket() + ", authorizerAppid=" + this.getAuthorizerAppid() + ", authorizationCode=" + this.getAuthorizationCode() + ", authorizationCodeExpiredTime=" + this.getAuthorizationCodeExpiredTime() + ", preAuthCode=" + this.getPreAuthCode() + ", registAppId=" + this.getRegistAppId() + ", status=" + this.getStatus() + ", authCode=" + this.getAuthCode() + ", msg=" + this.getMsg() + ", info=" + this.getInfo() + ")";
    }

    @XStreamAlias(value="info")
    public static class Info
    implements Serializable {
        private static final long serialVersionUID = 7706235740094081194L;
        @XStreamAlias(value="name")
        @XStreamConverter(value=XStreamCDataConverter.class)
        private String name;
        @XStreamAlias(value="code")
        @XStreamConverter(value=XStreamCDataConverter.class)
        private String code;
        @XStreamAlias(value="code_type")
        private int codeType;
        @XStreamAlias(value="legal_persona_wechat")
        @XStreamConverter(value=XStreamCDataConverter.class)
        private String legalPersonaWechat;
        @XStreamAlias(value="legal_persona_name")
        @XStreamConverter(value=XStreamCDataConverter.class)
        private String legalPersonaName;
        @XStreamAlias(value="component_phone")
        @XStreamConverter(value=XStreamCDataConverter.class)
        private String componentPhone;
        @XStreamAlias(value="wxuser")
        @XStreamConverter(value=XStreamCDataConverter.class)
        private String wxuser;
        @XStreamAlias(value="idname")
        @XStreamConverter(value=XStreamCDataConverter.class)
        private String idname;
        @XStreamAlias(value="unique_id")
        @XStreamConverter(value=XStreamCDataConverter.class)
        private String uniqueId;

        public String getName() {
            return this.name;
        }

        public String getCode() {
            return this.code;
        }

        public int getCodeType() {
            return this.codeType;
        }

        public String getLegalPersonaWechat() {
            return this.legalPersonaWechat;
        }

        public String getLegalPersonaName() {
            return this.legalPersonaName;
        }

        public String getComponentPhone() {
            return this.componentPhone;
        }

        public String getWxuser() {
            return this.wxuser;
        }

        public String getIdname() {
            return this.idname;
        }

        public String getUniqueId() {
            return this.uniqueId;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public void setCodeType(int codeType) {
            this.codeType = codeType;
        }

        public void setLegalPersonaWechat(String legalPersonaWechat) {
            this.legalPersonaWechat = legalPersonaWechat;
        }

        public void setLegalPersonaName(String legalPersonaName) {
            this.legalPersonaName = legalPersonaName;
        }

        public void setComponentPhone(String componentPhone) {
            this.componentPhone = componentPhone;
        }

        public void setWxuser(String wxuser) {
            this.wxuser = wxuser;
        }

        public void setIdname(String idname) {
            this.idname = idname;
        }

        public void setUniqueId(String uniqueId) {
            this.uniqueId = uniqueId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Info)) {
                return false;
            }
            Info other = (Info)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$code = this.getCode();
            String other$code = other.getCode();
            if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
                return false;
            }
            if (this.getCodeType() != other.getCodeType()) {
                return false;
            }
            String this$legalPersonaWechat = this.getLegalPersonaWechat();
            String other$legalPersonaWechat = other.getLegalPersonaWechat();
            if (this$legalPersonaWechat == null ? other$legalPersonaWechat != null : !this$legalPersonaWechat.equals(other$legalPersonaWechat)) {
                return false;
            }
            String this$legalPersonaName = this.getLegalPersonaName();
            String other$legalPersonaName = other.getLegalPersonaName();
            if (this$legalPersonaName == null ? other$legalPersonaName != null : !this$legalPersonaName.equals(other$legalPersonaName)) {
                return false;
            }
            String this$componentPhone = this.getComponentPhone();
            String other$componentPhone = other.getComponentPhone();
            if (this$componentPhone == null ? other$componentPhone != null : !this$componentPhone.equals(other$componentPhone)) {
                return false;
            }
            String this$wxuser = this.getWxuser();
            String other$wxuser = other.getWxuser();
            if (this$wxuser == null ? other$wxuser != null : !this$wxuser.equals(other$wxuser)) {
                return false;
            }
            String this$idname = this.getIdname();
            String other$idname = other.getIdname();
            if (this$idname == null ? other$idname != null : !this$idname.equals(other$idname)) {
                return false;
            }
            String this$uniqueId = this.getUniqueId();
            String other$uniqueId = other.getUniqueId();
            return !(this$uniqueId == null ? other$uniqueId != null : !this$uniqueId.equals(other$uniqueId));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Info;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $code = this.getCode();
            result = result * 59 + ($code == null ? 43 : $code.hashCode());
            result = result * 59 + this.getCodeType();
            String $legalPersonaWechat = this.getLegalPersonaWechat();
            result = result * 59 + ($legalPersonaWechat == null ? 43 : $legalPersonaWechat.hashCode());
            String $legalPersonaName = this.getLegalPersonaName();
            result = result * 59 + ($legalPersonaName == null ? 43 : $legalPersonaName.hashCode());
            String $componentPhone = this.getComponentPhone();
            result = result * 59 + ($componentPhone == null ? 43 : $componentPhone.hashCode());
            String $wxuser = this.getWxuser();
            result = result * 59 + ($wxuser == null ? 43 : $wxuser.hashCode());
            String $idname = this.getIdname();
            result = result * 59 + ($idname == null ? 43 : $idname.hashCode());
            String $uniqueId = this.getUniqueId();
            result = result * 59 + ($uniqueId == null ? 43 : $uniqueId.hashCode());
            return result;
        }

        public String toString() {
            return "WxOpenXmlMessage.Info(name=" + this.getName() + ", code=" + this.getCode() + ", codeType=" + this.getCodeType() + ", legalPersonaWechat=" + this.getLegalPersonaWechat() + ", legalPersonaName=" + this.getLegalPersonaName() + ", componentPhone=" + this.getComponentPhone() + ", wxuser=" + this.getWxuser() + ", idname=" + this.getIdname() + ", uniqueId=" + this.getUniqueId() + ")";
        }
    }
}

