/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.qidian.api.impl;

import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.error.WxRuntimeException;
import me.chanjar.weixin.common.util.http.HttpType;
import me.chanjar.weixin.common.util.http.okhttp.OkHttpProxyInfo;
import me.chanjar.weixin.qidian.api.impl.BaseWxQidianServiceImpl;
import me.chanjar.weixin.qidian.config.WxQidianConfigStorage;
import me.chanjar.weixin.qidian.enums.WxQidianApiUrl;
import okhttp3.Authenticator;
import okhttp3.Credentials;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;

public class WxQidianServiceOkHttpImpl
extends BaseWxQidianServiceImpl<OkHttpClient, OkHttpProxyInfo> {
    private OkHttpClient httpClient;
    private OkHttpProxyInfo httpProxy;

    public OkHttpClient getRequestHttpClient() {
        return this.httpClient;
    }

    public OkHttpProxyInfo getRequestHttpProxy() {
        return this.httpProxy;
    }

    public HttpType getRequestType() {
        return HttpType.OK_HTTP;
    }

    @Override
    public String getAccessToken(boolean forceRefresh) throws WxErrorException {
        WxQidianConfigStorage config = this.getWxMpConfigStorage();
        if (!config.isAccessTokenExpired() && !forceRefresh) {
            return config.getAccessToken();
        }
        Lock lock = config.getAccessTokenLock();
        boolean locked = false;
        try {
            do {
                locked = lock.tryLock(100L, TimeUnit.MILLISECONDS);
                if (forceRefresh || config.isAccessTokenExpired()) continue;
                String string = config.getAccessToken();
                return string;
            } while (!locked);
            String url = String.format(WxQidianApiUrl.Other.GET_ACCESS_TOKEN_URL.getUrl(config), config.getAppId(), config.getSecret());
            Request request = new Request.Builder().url(url).get().build();
            Response response = this.getRequestHttpClient().newCall(request).execute();
            String string = this.extractAccessToken(Objects.requireNonNull(response.body()).string());
            return string;
        }
        catch (IOException e) {
            throw new WxRuntimeException((Throwable)e);
        }
        catch (InterruptedException e) {
            throw new WxRuntimeException((Throwable)e);
        }
        finally {
            if (locked) {
                lock.unlock();
            }
        }
    }

    @Override
    public void initHttp() {
        WxQidianConfigStorage wxMpConfigStorage = this.getWxMpConfigStorage();
        if (wxMpConfigStorage.getHttpProxyHost() != null && wxMpConfigStorage.getHttpProxyPort() > 0) {
            this.httpProxy = OkHttpProxyInfo.httpProxy((String)wxMpConfigStorage.getHttpProxyHost(), (int)wxMpConfigStorage.getHttpProxyPort(), (String)wxMpConfigStorage.getHttpProxyUsername(), (String)wxMpConfigStorage.getHttpProxyPassword());
        }
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder();
        if (this.httpProxy != null) {
            clientBuilder.proxy(this.getRequestHttpProxy().getProxy());
            clientBuilder.authenticator(new Authenticator(){

                public Request authenticate(Route route, Response response) throws IOException {
                    String credential = Credentials.basic((String)WxQidianServiceOkHttpImpl.this.httpProxy.getProxyUsername(), (String)WxQidianServiceOkHttpImpl.this.httpProxy.getProxyPassword());
                    return response.request().newBuilder().header("Authorization", credential).build();
                }
            });
        }
        this.httpClient = clientBuilder.build();
    }
}

