/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.qidian.bean;

public class WxQidianHostConfig {
    public static final String API_DEFAULT_HOST_URL = "https://api.weixin.qq.com";
    public static final String OPEN_DEFAULT_HOST_URL = "https://open.weixin.qq.com";
    public static final String QIDIAN_DEFAULT_HOST_URL = "https://api.qidian.qq.com";
    private String apiHost;
    private String openHost;
    private String qidianHost;

    public static String buildUrl(WxQidianHostConfig hostConfig, String prefix, String path) {
        if (hostConfig == null) {
            return prefix + path;
        }
        if (hostConfig.getApiHost() != null && prefix.equals(API_DEFAULT_HOST_URL)) {
            return hostConfig.getApiHost() + path;
        }
        if (hostConfig.getQidianHost() != null && prefix.equals(QIDIAN_DEFAULT_HOST_URL)) {
            return hostConfig.getQidianHost() + path;
        }
        if (hostConfig.getOpenHost() != null && prefix.equals(OPEN_DEFAULT_HOST_URL)) {
            return hostConfig.getOpenHost() + path;
        }
        return prefix + path;
    }

    public static WxQidianHostConfigBuilder builder() {
        return new WxQidianHostConfigBuilder();
    }

    public String getApiHost() {
        return this.apiHost;
    }

    public String getOpenHost() {
        return this.openHost;
    }

    public String getQidianHost() {
        return this.qidianHost;
    }

    public void setApiHost(String apiHost) {
        this.apiHost = apiHost;
    }

    public void setOpenHost(String openHost) {
        this.openHost = openHost;
    }

    public void setQidianHost(String qidianHost) {
        this.qidianHost = qidianHost;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WxQidianHostConfig)) {
            return false;
        }
        WxQidianHostConfig other = (WxQidianHostConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$apiHost = this.getApiHost();
        String other$apiHost = other.getApiHost();
        if (this$apiHost == null ? other$apiHost != null : !this$apiHost.equals(other$apiHost)) {
            return false;
        }
        String this$openHost = this.getOpenHost();
        String other$openHost = other.getOpenHost();
        if (this$openHost == null ? other$openHost != null : !this$openHost.equals(other$openHost)) {
            return false;
        }
        String this$qidianHost = this.getQidianHost();
        String other$qidianHost = other.getQidianHost();
        return !(this$qidianHost == null ? other$qidianHost != null : !this$qidianHost.equals(other$qidianHost));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WxQidianHostConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $apiHost = this.getApiHost();
        result = result * 59 + ($apiHost == null ? 43 : $apiHost.hashCode());
        String $openHost = this.getOpenHost();
        result = result * 59 + ($openHost == null ? 43 : $openHost.hashCode());
        String $qidianHost = this.getQidianHost();
        result = result * 59 + ($qidianHost == null ? 43 : $qidianHost.hashCode());
        return result;
    }

    public String toString() {
        return "WxQidianHostConfig(apiHost=" + this.getApiHost() + ", openHost=" + this.getOpenHost() + ", qidianHost=" + this.getQidianHost() + ")";
    }

    public WxQidianHostConfig() {
    }

    public WxQidianHostConfig(String apiHost, String openHost, String qidianHost) {
        this.apiHost = apiHost;
        this.openHost = openHost;
        this.qidianHost = qidianHost;
    }

    public static class WxQidianHostConfigBuilder {
        private String apiHost;
        private String openHost;
        private String qidianHost;

        WxQidianHostConfigBuilder() {
        }

        public WxQidianHostConfigBuilder apiHost(String apiHost) {
            this.apiHost = apiHost;
            return this;
        }

        public WxQidianHostConfigBuilder openHost(String openHost) {
            this.openHost = openHost;
            return this;
        }

        public WxQidianHostConfigBuilder qidianHost(String qidianHost) {
            this.qidianHost = qidianHost;
            return this;
        }

        public WxQidianHostConfig build() {
            return new WxQidianHostConfig(this.apiHost, this.openHost, this.qidianHost);
        }

        public String toString() {
            return "WxQidianHostConfig.WxQidianHostConfigBuilder(apiHost=" + this.apiHost + ", openHost=" + this.openHost + ", qidianHost=" + this.qidianHost + ")";
        }
    }
}

