/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.qidian.api.impl;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import me.chanjar.weixin.common.api.WxConsts;
import me.chanjar.weixin.common.bean.ToJson;
import me.chanjar.weixin.common.bean.WxAccessToken;
import me.chanjar.weixin.common.bean.WxJsapiSignature;
import me.chanjar.weixin.common.bean.WxNetCheckResult;
import me.chanjar.weixin.common.enums.TicketType;
import me.chanjar.weixin.common.enums.WxType;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.error.WxRuntimeException;
import me.chanjar.weixin.common.util.DataUtils;
import me.chanjar.weixin.common.util.RandomUtils;
import me.chanjar.weixin.common.util.crypto.SHA1;
import me.chanjar.weixin.common.util.http.RequestExecutor;
import me.chanjar.weixin.common.util.http.RequestHttp;
import me.chanjar.weixin.common.util.http.SimpleGetRequestExecutor;
import me.chanjar.weixin.common.util.http.SimplePostRequestExecutor;
import me.chanjar.weixin.common.util.http.URIUtil;
import me.chanjar.weixin.common.util.json.GsonParser;
import me.chanjar.weixin.common.util.json.WxGsonBuilder;
import me.chanjar.weixin.qidian.api.WxQidianCallDataService;
import me.chanjar.weixin.qidian.api.WxQidianDialService;
import me.chanjar.weixin.qidian.api.WxQidianService;
import me.chanjar.weixin.qidian.api.impl.WxQidianCallDataServiceImpl;
import me.chanjar.weixin.qidian.api.impl.WxQidianDialServiceImpl;
import me.chanjar.weixin.qidian.config.WxQidianConfigStorage;
import me.chanjar.weixin.qidian.enums.WxQidianApiUrl;
import me.chanjar.weixin.qidian.util.WxQidianConfigStorageHolder;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseWxQidianServiceImpl<H, P>
implements WxQidianService,
RequestHttp<H, P> {
    private static final Logger log = LoggerFactory.getLogger(BaseWxQidianServiceImpl.class);
    private WxQidianDialService dialService = new WxQidianDialServiceImpl(this);
    private WxQidianCallDataService callDataService = new WxQidianCallDataServiceImpl(this);
    private Map<String, WxQidianConfigStorage> configStorageMap;
    private int retrySleepMillis = 1000;
    private int maxRetryTimes = 5;

    @Override
    public boolean checkSignature(String timestamp, String nonce, String signature) {
        try {
            return SHA1.gen((String[])new String[]{this.getWxMpConfigStorage().getToken(), timestamp, nonce}).equals(signature);
        }
        catch (Exception e) {
            log.error("Checking signature failed, and the reason is :" + e.getMessage());
            return false;
        }
    }

    @Override
    public String getTicket(TicketType type) throws WxErrorException {
        return this.getTicket(type, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getTicket(TicketType type, boolean forceRefresh) throws WxErrorException {
        if (forceRefresh) {
            this.getWxMpConfigStorage().expireTicket(type);
        }
        if (this.getWxMpConfigStorage().isTicketExpired(type)) {
            Lock lock = this.getWxMpConfigStorage().getTicketLock(type);
            lock.lock();
            try {
                if (this.getWxMpConfigStorage().isTicketExpired(type)) {
                    String responseContent = (String)this.execute(SimpleGetRequestExecutor.create((RequestHttp)this), WxQidianApiUrl.Other.GET_TICKET_URL.getUrl(this.getWxMpConfigStorage()) + type.getCode(), null);
                    JsonObject tmpJsonObject = GsonParser.parse((String)responseContent);
                    String jsapiTicket = tmpJsonObject.get("ticket").getAsString();
                    int expiresInSeconds = tmpJsonObject.get("expires_in").getAsInt();
                    this.getWxMpConfigStorage().updateTicket(type, jsapiTicket, expiresInSeconds);
                }
            }
            finally {
                lock.unlock();
            }
        }
        return this.getWxMpConfigStorage().getTicket(type);
    }

    @Override
    public String getJsapiTicket() throws WxErrorException {
        return this.getJsapiTicket(false);
    }

    @Override
    public String getJsapiTicket(boolean forceRefresh) throws WxErrorException {
        return this.getTicket(TicketType.JSAPI, forceRefresh);
    }

    @Override
    public WxJsapiSignature createJsapiSignature(String url) throws WxErrorException {
        long timestamp = System.currentTimeMillis() / 1000L;
        String randomStr = RandomUtils.getRandomStr();
        String jsapiTicket = this.getJsapiTicket(false);
        String signature = SHA1.genWithAmple((String[])new String[]{"jsapi_ticket=" + jsapiTicket, "noncestr=" + randomStr, "timestamp=" + timestamp, "url=" + url});
        WxJsapiSignature jsapiSignature = new WxJsapiSignature();
        jsapiSignature.setAppId(this.getWxMpConfigStorage().getAppId());
        jsapiSignature.setTimestamp(timestamp);
        jsapiSignature.setNonceStr(randomStr);
        jsapiSignature.setUrl(url);
        jsapiSignature.setSignature(signature);
        return jsapiSignature;
    }

    @Override
    public String getAccessToken() throws WxErrorException {
        return this.getAccessToken(false);
    }

    @Override
    public String shortUrl(String longUrl) throws WxErrorException {
        if (longUrl.contains("&access_token=")) {
            throw new WxErrorException("\u8981\u8f6c\u6362\u7684\u7f51\u5740\u4e2d\u5b58\u5728\u975e\u6cd5\u5b57\u7b26\uff5b&access_token=\uff5d\uff0c\u4f1a\u5bfc\u81f4\u5fae\u4fe1\u63a5\u53e3\u62a5\u9519\uff0c\u5c5e\u4e8e\u5fae\u4fe1bug\uff0c\u8bf7\u8c03\u6574\u5730\u5740\uff0c\u5426\u5219\u4e0d\u5efa\u8bae\u4f7f\u7528\u6b64\u65b9\u6cd5\uff01");
        }
        JsonObject o = new JsonObject();
        o.addProperty("action", "long2short");
        o.addProperty("long_url", longUrl);
        String responseContent = this.post((WxQidianApiUrl)WxQidianApiUrl.Other.SHORTURL_API_URL, o.toString());
        return GsonParser.parse((String)responseContent).get("short_url").getAsString();
    }

    @Override
    public String buildQrConnectUrl(String redirectUri, String scope, String state) {
        return String.format(WxQidianApiUrl.Other.QRCONNECT_URL.getUrl(this.getWxMpConfigStorage()), this.getWxMpConfigStorage().getAppId(), URIUtil.encodeURIComponent((String)redirectUri), scope, StringUtils.trimToEmpty((String)state));
    }

    @Override
    public String[] getCallbackIP() throws WxErrorException {
        String responseContent = this.get(WxQidianApiUrl.Other.GET_CALLBACK_IP_URL, null);
        JsonObject tmpJsonObject = GsonParser.parse((String)responseContent);
        JsonArray ipList = tmpJsonObject.get("ip_list").getAsJsonArray();
        String[] ipArray = new String[ipList.size()];
        for (int i = 0; i < ipList.size(); ++i) {
            ipArray[i] = ipList.get(i).getAsString();
        }
        return ipArray;
    }

    @Override
    public WxNetCheckResult netCheck(String action, String operator) throws WxErrorException {
        JsonObject o = new JsonObject();
        o.addProperty("action", action);
        o.addProperty("check_operator", operator);
        String responseContent = this.post((WxQidianApiUrl)WxQidianApiUrl.Other.NETCHECK_URL, o.toString());
        return WxNetCheckResult.fromJson((String)responseContent);
    }

    @Override
    public void clearQuota(String appid) throws WxErrorException {
        JsonObject o = new JsonObject();
        o.addProperty("appid", appid);
        this.post((WxQidianApiUrl)WxQidianApiUrl.Other.CLEAR_QUOTA_URL, o.toString());
    }

    public String get(String url, String queryParam) throws WxErrorException {
        return (String)this.execute(SimpleGetRequestExecutor.create((RequestHttp)this), url, queryParam);
    }

    @Override
    public String get(WxQidianApiUrl url, String queryParam) throws WxErrorException {
        return this.get(url.getUrl(this.getWxMpConfigStorage()), queryParam);
    }

    public String post(String url, String postData) throws WxErrorException {
        return (String)this.execute(SimplePostRequestExecutor.create((RequestHttp)this), url, postData);
    }

    @Override
    public String post(WxQidianApiUrl url, String postData) throws WxErrorException {
        return this.post(url.getUrl(this.getWxMpConfigStorage()), postData);
    }

    @Override
    public String post(WxQidianApiUrl url, JsonObject jsonObject) throws WxErrorException {
        return this.post(url.getUrl(this.getWxMpConfigStorage()), jsonObject.toString());
    }

    public String post(String url, ToJson obj) throws WxErrorException {
        return this.post(url, obj.toJson());
    }

    public String post(String url, JsonObject jsonObject) throws WxErrorException {
        return this.post(url, jsonObject.toString());
    }

    public String post(String url, Object obj) throws WxErrorException {
        return (String)this.execute(SimplePostRequestExecutor.create((RequestHttp)this), url, WxGsonBuilder.create().toJson(obj));
    }

    @Override
    public <T, E> T execute(RequestExecutor<T, E> executor, WxQidianApiUrl url, E data) throws WxErrorException {
        return this.execute(executor, url.getUrl(this.getWxMpConfigStorage()), data);
    }

    @Override
    public <T, E> T execute(RequestExecutor<T, E> executor, String uri, E data) throws WxErrorException {
        int retryTimes = 0;
        while (true) {
            try {
                return this.executeInternal(executor, uri, data);
            }
            catch (WxErrorException e) {
                if (retryTimes + 1 > this.maxRetryTimes) {
                    log.warn("\u91cd\u8bd5\u8fbe\u5230\u6700\u5927\u6b21\u6570\u3010{}\u3011", (Object)this.maxRetryTimes);
                    throw new WxRuntimeException("\u5fae\u4fe1\u670d\u52a1\u7aef\u5f02\u5e38\uff0c\u8d85\u51fa\u91cd\u8bd5\u6b21\u6570");
                }
                WxError error = e.getError();
                if (error.getErrorCode() == -1) {
                    int sleepMillis = this.retrySleepMillis * (1 << retryTimes);
                    try {
                        log.warn("\u5fae\u4fe1\u7cfb\u7edf\u7e41\u5fd9\uff0c{} ms \u540e\u91cd\u8bd5(\u7b2c{}\u6b21)", (Object)sleepMillis, (Object)(retryTimes + 1));
                        Thread.sleep(sleepMillis);
                    }
                    catch (InterruptedException e1) {
                        throw new WxRuntimeException((Throwable)e1);
                    }
                } else {
                    throw e;
                }
                if (retryTimes++ < this.maxRetryTimes) continue;
                log.warn("\u91cd\u8bd5\u8fbe\u5230\u6700\u5927\u6b21\u6570\u3010{}\u3011", (Object)this.maxRetryTimes);
                throw new WxRuntimeException("\u5fae\u4fe1\u670d\u52a1\u7aef\u5f02\u5e38\uff0c\u8d85\u51fa\u91cd\u8bd5\u6b21\u6570");
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T, E> T executeInternal(RequestExecutor<T, E> executor, String uri, E data) throws WxErrorException {
        Object dataForLog = DataUtils.handleDataWithSecret(data);
        if (uri.contains("access_token=")) {
            throw new IllegalArgumentException("uri\u53c2\u6570\u4e2d\u4e0d\u5141\u8bb8\u6709access_token: " + uri);
        }
        String accessToken = this.getAccessToken(false);
        String uriWithAccessToken = uri + (uri.contains("?") ? "&" : "?") + "access_token=" + accessToken;
        try {
            Object result = executor.execute(uriWithAccessToken, data, WxType.MP);
            log.debug("\n\u3010\u8bf7\u6c42\u5730\u5740\u3011: {}\n\u3010\u8bf7\u6c42\u53c2\u6570\u3011\uff1a{}\n\u3010\u54cd\u5e94\u6570\u636e\u3011\uff1a{}", new Object[]{uriWithAccessToken, dataForLog, result});
            return (T)result;
        }
        catch (WxErrorException e) {
            WxError error = e.getError();
            if (WxConsts.ACCESS_TOKEN_ERROR_CODES.contains(error.getErrorCode())) {
                Lock lock = this.getWxMpConfigStorage().getAccessTokenLock();
                lock.lock();
                try {
                    if (StringUtils.equals((CharSequence)this.getWxMpConfigStorage().getAccessToken(), (CharSequence)accessToken)) {
                        this.getWxMpConfigStorage().expireAccessToken();
                    }
                }
                catch (Exception ex) {
                    this.getWxMpConfigStorage().expireAccessToken();
                }
                finally {
                    lock.unlock();
                }
                if (this.getWxMpConfigStorage().autoRefreshToken()) {
                    log.warn("\u5373\u5c06\u91cd\u65b0\u83b7\u53d6\u65b0\u7684access_token\uff0c\u9519\u8bef\u4ee3\u7801\uff1a{}\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)error.getErrorCode(), (Object)error.getErrorMsg());
                    return this.execute(executor, uri, data);
                }
            }
            if (error.getErrorCode() != 0) {
                log.error("\n\u3010\u8bf7\u6c42\u5730\u5740\u3011: {}\n\u3010\u8bf7\u6c42\u53c2\u6570\u3011\uff1a{}\n\u3010\u9519\u8bef\u4fe1\u606f\u3011\uff1a{}", new Object[]{uriWithAccessToken, dataForLog, error});
                throw new WxErrorException(error, (Throwable)e);
            }
            return null;
        }
        catch (IOException e) {
            log.error("\n\u3010\u8bf7\u6c42\u5730\u5740\u3011: {}\n\u3010\u8bf7\u6c42\u53c2\u6570\u3011\uff1a{}\n\u3010\u5f02\u5e38\u4fe1\u606f\u3011\uff1a{}", new Object[]{uriWithAccessToken, dataForLog, e.getMessage()});
            throw new WxErrorException((Throwable)e);
        }
    }

    @Override
    public WxQidianConfigStorage getWxMpConfigStorage() {
        if (this.configStorageMap.size() == 1) {
            return this.configStorageMap.values().iterator().next();
        }
        return this.configStorageMap.get(WxQidianConfigStorageHolder.get());
    }

    protected String extractAccessToken(String resultContent) throws WxErrorException {
        WxQidianConfigStorage config = this.getWxMpConfigStorage();
        WxError error = WxError.fromJson((String)resultContent, (WxType)WxType.MP);
        if (error.getErrorCode() != 0) {
            throw new WxErrorException(error);
        }
        WxAccessToken accessToken = WxAccessToken.fromJson((String)resultContent);
        config.updateAccessToken(accessToken.getAccessToken(), accessToken.getExpiresIn());
        return config.getAccessToken();
    }

    @Override
    public void setWxMpConfigStorage(WxQidianConfigStorage wxConfigProvider) {
        String defaultMpId = wxConfigProvider.getAppId();
        this.setMultiConfigStorages((Map<String, WxQidianConfigStorage>)ImmutableMap.of((Object)defaultMpId, (Object)wxConfigProvider), defaultMpId);
    }

    @Override
    public void setMultiConfigStorages(Map<String, WxQidianConfigStorage> configStorages) {
        this.setMultiConfigStorages(configStorages, configStorages.keySet().iterator().next());
    }

    @Override
    public void setMultiConfigStorages(Map<String, WxQidianConfigStorage> configStorages, String defaultMpId) {
        this.configStorageMap = Maps.newHashMap(configStorages);
        WxQidianConfigStorageHolder.set(defaultMpId);
        this.initHttp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConfigStorage(String mpId, WxQidianConfigStorage configStorages) {
        BaseWxQidianServiceImpl baseWxQidianServiceImpl = this;
        synchronized (baseWxQidianServiceImpl) {
            if (this.configStorageMap == null) {
                this.setWxMpConfigStorage(configStorages);
            } else {
                this.configStorageMap.put(mpId, configStorages);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConfigStorage(String mpId) {
        BaseWxQidianServiceImpl baseWxQidianServiceImpl = this;
        synchronized (baseWxQidianServiceImpl) {
            if (this.configStorageMap.size() == 1) {
                this.configStorageMap.remove(mpId);
                log.warn("\u5df2\u5220\u9664\u6700\u540e\u4e00\u4e2a\u516c\u4f17\u53f7\u914d\u7f6e\uff1a{}\uff0c\u987b\u7acb\u5373\u4f7f\u7528setWxMpConfigStorage\u6216setMultiConfigStorages\u6dfb\u52a0\u914d\u7f6e", (Object)mpId);
                return;
            }
            if (WxQidianConfigStorageHolder.get().equals(mpId)) {
                this.configStorageMap.remove(mpId);
                String defaultMpId = this.configStorageMap.keySet().iterator().next();
                WxQidianConfigStorageHolder.set(defaultMpId);
                log.warn("\u5df2\u5220\u9664\u9ed8\u8ba4\u516c\u4f17\u53f7\u914d\u7f6e\uff0c\u516c\u4f17\u53f7\u3010{}\u3011\u88ab\u8bbe\u4e3a\u9ed8\u8ba4\u914d\u7f6e", (Object)defaultMpId);
                return;
            }
            this.configStorageMap.remove(mpId);
        }
    }

    @Override
    public WxQidianService switchoverTo(String mpId) {
        if (this.configStorageMap.containsKey(mpId)) {
            WxQidianConfigStorageHolder.set(mpId);
            return this;
        }
        throw new WxRuntimeException(String.format("\u65e0\u6cd5\u627e\u5230\u5bf9\u5e94\u3010%s\u3011\u7684\u516c\u4f17\u53f7\u914d\u7f6e\u4fe1\u606f\uff0c\u8bf7\u6838\u5b9e\uff01", mpId));
    }

    @Override
    public boolean switchover(String mpId) {
        if (this.configStorageMap.containsKey(mpId)) {
            WxQidianConfigStorageHolder.set(mpId);
            return true;
        }
        log.error("\u65e0\u6cd5\u627e\u5230\u5bf9\u5e94\u3010{}\u3011\u7684\u516c\u4f17\u53f7\u914d\u7f6e\u4fe1\u606f\uff0c\u8bf7\u6838\u5b9e\uff01", (Object)mpId);
        return false;
    }

    @Override
    public void setRetrySleepMillis(int retrySleepMillis) {
        this.retrySleepMillis = retrySleepMillis;
    }

    @Override
    public void setMaxRetryTimes(int maxRetryTimes) {
        this.maxRetryTimes = maxRetryTimes;
    }

    @Override
    public RequestHttp getRequestHttp() {
        return this;
    }

    @Override
    public WxQidianDialService getDialService() {
        return this.dialService;
    }

    @Override
    public WxQidianCallDataService getCallDataService() {
        return this.callDataService;
    }
}

