/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.qidian.enums;

import me.chanjar.weixin.qidian.bean.WxQidianHostConfig;
import me.chanjar.weixin.qidian.config.WxQidianConfigStorage;

public interface WxQidianApiUrl {
    default public String getUrl(WxQidianConfigStorage config) {
        WxQidianHostConfig hostConfig = null;
        if (config != null) {
            hostConfig = config.getHostConfig();
        }
        return WxQidianHostConfig.buildUrl(hostConfig, this.getPrefix(), this.getPath());
    }

    public String getPath();

    public String getPrefix();

    public static enum CallData implements WxQidianApiUrl
    {
        GET_SWITCH_BOARD_LIST("https://api.qidian.qq.com", "/cgi-bin/call/callData/getswitchboardlist");

        private final String prefix;
        private final String path;

        private CallData(String prefix, String path) {
            this.prefix = prefix;
            this.path = path;
        }

        @Override
        public String getPrefix() {
            return this.prefix;
        }

        @Override
        public String getPath() {
            return this.path;
        }
    }

    public static enum Dial implements WxQidianApiUrl
    {
        IVR_DIAL("https://api.qidian.qq.com", "/cgi-bin/call/dial/ivrdial"),
        GET_IVR_LIST("https://api.qidian.qq.com", "/cgi-bin/call/dial/getivrlist");

        private final String prefix;
        private final String path;

        private Dial(String prefix, String path) {
            this.prefix = prefix;
            this.path = path;
        }

        @Override
        public String getPrefix() {
            return this.prefix;
        }

        @Override
        public String getPath() {
            return this.path;
        }
    }

    public static enum Other implements WxQidianApiUrl
    {
        GET_ACCESS_TOKEN_URL("https://api.qidian.qq.com", "/cgi-bin/token?grant_type=client_credential&appid=%s&secret=%s"),
        GET_TICKET_URL("https://api.weixin.qq.com", "/cgi-bin/ticket/getticket?type="),
        SHORTURL_API_URL("https://api.weixin.qq.com", "/cgi-bin/shorturl"),
        SEMANTIC_SEMPROXY_SEARCH_URL("https://api.weixin.qq.com", "/semantic/semproxy/search"),
        GET_CALLBACK_IP_URL("https://api.weixin.qq.com", "/cgi-bin/getcallbackip"),
        NETCHECK_URL("https://api.weixin.qq.com", "/cgi-bin/callback/check"),
        QRCONNECT_URL("https://open.weixin.qq.com", "/connect/qrconnect?appid=%s&redirect_uri=%s&response_type=code&scope=%s&state=%s#wechat_redirect"),
        GET_CURRENT_AUTOREPLY_INFO_URL("https://api.weixin.qq.com", "/cgi-bin/get_current_autoreply_info"),
        CLEAR_QUOTA_URL("https://api.weixin.qq.com", "/cgi-bin/clear_quota");

        private final String prefix;
        private final String path;

        private Other(String prefix, String path) {
            this.prefix = prefix;
            this.path = path;
        }

        @Override
        public String getPrefix() {
            return this.prefix;
        }

        @Override
        public String getPath() {
            return this.path;
        }
    }

    public static enum OAuth2 implements WxQidianApiUrl
    {
        OAUTH2_ACCESS_TOKEN_URL("https://api.weixin.qq.com", "/sns/oauth2/access_token?appid=%s&secret=%s&code=%s&grant_type=authorization_code"),
        OAUTH2_REFRESH_TOKEN_URL("https://api.weixin.qq.com", "/sns/oauth2/refresh_token?appid=%s&grant_type=refresh_token&refresh_token=%s"),
        OAUTH2_USERINFO_URL("https://api.weixin.qq.com", "/sns/userinfo?access_token=%s&openid=%s&lang=%s"),
        OAUTH2_VALIDATE_TOKEN_URL("https://api.weixin.qq.com", "/sns/auth?access_token=%s&openid=%s"),
        CONNECT_OAUTH2_AUTHORIZE_URL("https://open.weixin.qq.com", "/connect/oauth2/authorize?appid=%s&redirect_uri=%s&response_type=code&scope=%s&state=%s&connect_redirect=1#wechat_redirect");

        private final String prefix;
        private final String path;

        private OAuth2(String prefix, String path) {
            this.prefix = prefix;
            this.path = path;
        }

        @Override
        public String getPrefix() {
            return this.prefix;
        }

        @Override
        public String getPath() {
            return this.path;
        }
    }
}

