/*
 * Decompiled with CFR 0.152.
 */
package com.binarywang.solon.wxjava.miniapp.config;

import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.api.impl.WxMaServiceHttpClientImpl;
import cn.binarywang.wx.miniapp.api.impl.WxMaServiceImpl;
import cn.binarywang.wx.miniapp.api.impl.WxMaServiceJoddHttpImpl;
import cn.binarywang.wx.miniapp.api.impl.WxMaServiceOkHttpImpl;
import cn.binarywang.wx.miniapp.config.WxMaConfig;
import com.binarywang.solon.wxjava.miniapp.enums.HttpClientType;
import com.binarywang.solon.wxjava.miniapp.properties.WxMaProperties;
import org.noear.solon.annotation.Bean;
import org.noear.solon.annotation.Condition;
import org.noear.solon.annotation.Configuration;

@Configuration
public class WxMaServiceAutoConfiguration {
    private final WxMaProperties wxMaProperties;

    @Bean
    @Condition(onMissingBean=WxMaService.class, onBean=WxMaConfig.class)
    public WxMaService wxMaService(WxMaConfig wxMaConfig) {
        WxMaServiceOkHttpImpl wxMaService;
        HttpClientType httpClientType = this.wxMaProperties.getConfigStorage().getHttpClientType();
        switch (httpClientType) {
            case OkHttp: {
                wxMaService = new WxMaServiceOkHttpImpl();
                break;
            }
            case JoddHttp: {
                wxMaService = new WxMaServiceJoddHttpImpl();
                break;
            }
            case HttpClient: {
                wxMaService = new WxMaServiceHttpClientImpl();
                break;
            }
            default: {
                wxMaService = new WxMaServiceImpl();
            }
        }
        wxMaService.setWxMaConfig(wxMaConfig);
        return wxMaService;
    }

    public WxMaServiceAutoConfiguration(WxMaProperties wxMaProperties) {
        this.wxMaProperties = wxMaProperties;
    }
}

