/*
 * Decompiled with CFR 0.152.
 */
package com.binarywang.solon.wxjava.qidian.config;

import com.binarywang.solon.wxjava.qidian.enums.HttpClientType;
import com.binarywang.solon.wxjava.qidian.properties.WxQidianProperties;
import me.chanjar.weixin.qidian.api.WxQidianService;
import me.chanjar.weixin.qidian.api.impl.WxQidianServiceHttpClientImpl;
import me.chanjar.weixin.qidian.api.impl.WxQidianServiceImpl;
import me.chanjar.weixin.qidian.api.impl.WxQidianServiceJoddHttpImpl;
import me.chanjar.weixin.qidian.api.impl.WxQidianServiceOkHttpImpl;
import me.chanjar.weixin.qidian.config.WxQidianConfigStorage;
import org.noear.solon.annotation.Bean;
import org.noear.solon.annotation.Condition;
import org.noear.solon.annotation.Configuration;

@Configuration
public class WxQidianServiceAutoConfiguration {
    @Bean
    @Condition(onMissingBean=WxQidianService.class)
    public WxQidianService wxQidianService(WxQidianConfigStorage configStorage, WxQidianProperties wxQidianProperties) {
        WxQidianService wxQidianService;
        HttpClientType httpClientType = wxQidianProperties.getConfigStorage().getHttpClientType();
        switch (httpClientType) {
            case OkHttp: {
                wxQidianService = this.newWxQidianServiceOkHttpImpl();
                break;
            }
            case JoddHttp: {
                wxQidianService = this.newWxQidianServiceJoddHttpImpl();
                break;
            }
            case HttpClient: {
                wxQidianService = this.newWxQidianServiceHttpClientImpl();
                break;
            }
            default: {
                wxQidianService = this.newWxQidianServiceImpl();
            }
        }
        wxQidianService.setWxMpConfigStorage(configStorage);
        return wxQidianService;
    }

    private WxQidianService newWxQidianServiceImpl() {
        return new WxQidianServiceImpl();
    }

    private WxQidianService newWxQidianServiceHttpClientImpl() {
        return new WxQidianServiceHttpClientImpl();
    }

    private WxQidianService newWxQidianServiceOkHttpImpl() {
        return new WxQidianServiceOkHttpImpl();
    }

    private WxQidianService newWxQidianServiceJoddHttpImpl() {
        return new WxQidianServiceJoddHttpImpl();
    }
}

