/*
 * Decompiled with CFR 0.152.
 */
package com.binarywang.spring.starter.wxjava.qidian.config;

import com.binarywang.spring.starter.wxjava.qidian.enums.StorageType;
import com.binarywang.spring.starter.wxjava.qidian.properties.RedisProperties;
import com.binarywang.spring.starter.wxjava.qidian.properties.WxQidianProperties;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import me.chanjar.weixin.common.redis.JedisWxRedisOps;
import me.chanjar.weixin.common.redis.RedisTemplateWxRedisOps;
import me.chanjar.weixin.common.redis.WxRedisOps;
import me.chanjar.weixin.qidian.bean.WxQidianHostConfig;
import me.chanjar.weixin.qidian.config.WxQidianConfigStorage;
import me.chanjar.weixin.qidian.config.impl.WxQidianDefaultConfigImpl;
import me.chanjar.weixin.qidian.config.impl.WxQidianRedisConfigImpl;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.StringRedisTemplate;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolAbstract;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisSentinelPool;
import redis.clients.jedis.util.Pool;

@Configuration
public class WxQidianStorageAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(WxQidianStorageAutoConfiguration.class);
    private final ApplicationContext applicationContext;
    private final WxQidianProperties wxQidianProperties;
    @Value(value="${wx.mp.config-storage.redis.host:")
    private String redisHost;
    @Value(value="${wx.mp.configStorage.redis.host:")
    private String redisHost2;

    @Bean
    @ConditionalOnMissingBean(value={WxQidianConfigStorage.class})
    public WxQidianConfigStorage wxQidianConfigStorage() {
        WxQidianConfigStorage config;
        StorageType type = this.wxQidianProperties.getConfigStorage().getType();
        switch (type) {
            case Jedis: {
                config = this.jedisConfigStorage();
                break;
            }
            case RedisTemplate: {
                config = this.redisTemplateConfigStorage();
                break;
            }
            default: {
                config = this.defaultConfigStorage();
            }
        }
        if (null != this.wxQidianProperties.getHosts() && StringUtils.isNotEmpty((CharSequence)this.wxQidianProperties.getHosts().getApiHost())) {
            WxQidianHostConfig hostConfig = new WxQidianHostConfig();
            hostConfig.setApiHost(this.wxQidianProperties.getHosts().getApiHost());
            hostConfig.setQidianHost(this.wxQidianProperties.getHosts().getQidianHost());
            hostConfig.setOpenHost(this.wxQidianProperties.getHosts().getOpenHost());
            config.setHostConfig(hostConfig);
        }
        return config;
    }

    private WxQidianConfigStorage defaultConfigStorage() {
        WxQidianDefaultConfigImpl config = new WxQidianDefaultConfigImpl();
        this.setWxMpInfo(config);
        return config;
    }

    private WxQidianConfigStorage jedisConfigStorage() {
        JedisPoolAbstract jedisPool = StringUtils.isNotEmpty((CharSequence)this.redisHost) || StringUtils.isNotEmpty((CharSequence)this.redisHost2) ? this.getJedisPool() : (JedisPoolAbstract)this.applicationContext.getBean(JedisPool.class);
        JedisWxRedisOps redisOps = new JedisWxRedisOps((Pool)jedisPool);
        WxQidianRedisConfigImpl wxQidianRedisConfig = new WxQidianRedisConfigImpl((WxRedisOps)redisOps, this.wxQidianProperties.getConfigStorage().getKeyPrefix());
        this.setWxMpInfo((WxQidianDefaultConfigImpl)wxQidianRedisConfig);
        return wxQidianRedisConfig;
    }

    private WxQidianConfigStorage redisTemplateConfigStorage() {
        StringRedisTemplate redisTemplate = null;
        try {
            redisTemplate = (StringRedisTemplate)this.applicationContext.getBean(StringRedisTemplate.class);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        try {
            if (null == redisTemplate) {
                redisTemplate = (StringRedisTemplate)this.applicationContext.getBean("stringRedisTemplate");
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        if (null == redisTemplate) {
            redisTemplate = (StringRedisTemplate)this.applicationContext.getBean("redisTemplate");
        }
        RedisTemplateWxRedisOps redisOps = new RedisTemplateWxRedisOps(redisTemplate);
        WxQidianRedisConfigImpl wxMpRedisConfig = new WxQidianRedisConfigImpl((WxRedisOps)redisOps, this.wxQidianProperties.getConfigStorage().getKeyPrefix());
        this.setWxMpInfo((WxQidianDefaultConfigImpl)wxMpRedisConfig);
        return wxMpRedisConfig;
    }

    private void setWxMpInfo(WxQidianDefaultConfigImpl config) {
        WxQidianProperties properties = this.wxQidianProperties;
        WxQidianProperties.ConfigStorage configStorageProperties = properties.getConfigStorage();
        config.setAppId(properties.getAppId());
        config.setSecret(properties.getSecret());
        config.setToken(properties.getToken());
        config.setAesKey(properties.getAesKey());
        config.setHttpProxyHost(configStorageProperties.getHttpProxyHost());
        config.setHttpProxyUsername(configStorageProperties.getHttpProxyUsername());
        config.setHttpProxyPassword(configStorageProperties.getHttpProxyPassword());
        if (configStorageProperties.getHttpProxyPort() != null) {
            config.setHttpProxyPort(configStorageProperties.getHttpProxyPort().intValue());
        }
    }

    private JedisPoolAbstract getJedisPool() {
        WxQidianProperties.ConfigStorage storage = this.wxQidianProperties.getConfigStorage();
        RedisProperties redis = storage.getRedis();
        JedisPoolConfig config = new JedisPoolConfig();
        if (redis.getMaxActive() != null) {
            config.setMaxTotal(redis.getMaxActive().intValue());
        }
        if (redis.getMaxIdle() != null) {
            config.setMaxIdle(redis.getMaxIdle().intValue());
        }
        if (redis.getMaxWaitMillis() != null) {
            config.setMaxWaitMillis((long)redis.getMaxWaitMillis().intValue());
        }
        if (redis.getMinIdle() != null) {
            config.setMinIdle(redis.getMinIdle().intValue());
        }
        config.setTestOnBorrow(true);
        config.setTestWhileIdle(true);
        if (StringUtils.isNotEmpty((CharSequence)redis.getSentinelIps())) {
            HashSet sentinels = Sets.newHashSet((Object[])redis.getSentinelIps().split(","));
            return new JedisSentinelPool(redis.getSentinelName(), (Set)sentinels);
        }
        return new JedisPool((GenericObjectPoolConfig)config, redis.getHost(), redis.getPort(), redis.getTimeout(), redis.getPassword(), redis.getDatabase());
    }

    public WxQidianStorageAutoConfiguration(ApplicationContext applicationContext, WxQidianProperties wxQidianProperties) {
        this.applicationContext = applicationContext;
        this.wxQidianProperties = wxQidianProperties;
    }
}

