/*
 * Decompiled with CFR 0.152.
 */
package com.bld.proxy.api.find.config;

import com.bld.proxy.api.find.annotations.ApiFindController;
import com.bld.proxy.api.find.config.annotation.EnableProxyApiController;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class ApiFindRegistrar
implements ImportBeanDefinitionRegistrar,
EnvironmentAware,
ResourceLoaderAware {
    private static final String PROXY_CONFIG = "proxyConfig";
    private static final String NEW_PROXY_INSTANCE = "newProxyInstance";
    private Environment env;
    private ResourceLoader resourceLoader;

    public void registerBeanDefinitions(AnnotationMetadata metadata, BeanDefinitionRegistry registry) {
        ClassPathScanningCandidateComponentProvider scanner = this.getScanner();
        LinkedHashSet candidateComponents = new LinkedHashSet();
        scanner.setResourceLoader(this.resourceLoader);
        scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(ApiFindController.class));
        Set<String> baseProjects = this.getBasePackages(metadata);
        for (String baseProject : baseProjects) {
            candidateComponents.addAll(scanner.findCandidateComponents(baseProject));
            try {
                for (BeanDefinition candidate : candidateComponents) {
                    String beanClassName = candidate.getBeanClassName();
                    Class<?> classApiController = Class.forName(beanClassName);
                    BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(classApiController);
                    builder.setFactoryMethodOnBean(NEW_PROXY_INSTANCE, PROXY_CONFIG);
                    builder.addConstructorArgValue(classApiController);
                    AbstractBeanDefinition beanDefinition = builder.getBeanDefinition();
                    registry.registerBeanDefinition(classApiController.getName(), (BeanDefinition)beanDefinition);
                }
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    protected ClassPathScanningCandidateComponentProvider getScanner() {
        return new ClassPathScanningCandidateComponentProvider(false, this.env){

            protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
                boolean isCandidate = false;
                if (beanDefinition.getMetadata().isIndependent() && !beanDefinition.getMetadata().isAnnotation()) {
                    isCandidate = true;
                }
                return isCandidate;
            }
        };
    }

    public void setEnvironment(Environment environment) {
        this.env = environment;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    protected Set<String> getBasePackages(AnnotationMetadata importingClassMetadata) {
        Map attributes = importingClassMetadata.getAnnotationAttributes(EnableProxyApiController.class.getCanonicalName());
        HashSet<String> basePackages = new HashSet<String>();
        for (String pkg : (String[])attributes.get("value")) {
            if (!StringUtils.hasText((String)pkg)) continue;
            basePackages.add(pkg);
        }
        for (String pkg : (String[])attributes.get("basePackages")) {
            if (!StringUtils.hasText((String)pkg)) continue;
            basePackages.add(pkg);
        }
        for (Class clazz : (Class[])attributes.get("basePackageClasses")) {
            basePackages.add(ClassUtils.getPackageName((Class)clazz));
        }
        if (basePackages.isEmpty()) {
            basePackages.add(ClassUtils.getPackageName((String)importingClassMetadata.getClassName()));
        }
        return basePackages;
    }
}

