/*
 * Decompiled with CFR 0.152.
 */
package com.bld.proxy.api.find.intecerptor;

import bld.commons.reflection.annotations.ConditionsZones;
import bld.commons.reflection.annotations.DateFilter;
import bld.commons.reflection.annotations.FilterNullValue;
import bld.commons.reflection.annotations.IgnoreMapping;
import bld.commons.reflection.annotations.LikeString;
import bld.commons.reflection.annotations.ListFilter;
import bld.commons.reflection.model.BaseParameter;
import bld.commons.reflection.model.BaseQueryParameter;
import bld.commons.reflection.model.NativeQueryParameter;
import bld.commons.reflection.model.QueryParameter;
import bld.commons.reflection.type.OrderType;
import bld.commons.reflection.utils.ReflectionCommons;
import bld.commons.service.JpaServiceImpl;
import com.bld.commons.utils.data.CollectionResponse;
import com.bld.commons.utils.data.ObjectResponse;
import com.bld.proxy.api.find.annotations.ApiBeforeRequest;
import com.bld.proxy.api.find.annotations.ApiFind;
import com.bld.proxy.api.find.annotations.ApiMapper;
import com.bld.proxy.api.find.config.ApiQuery;
import com.bld.proxy.api.find.config.DefaultOrderBy;
import com.bld.proxy.api.find.data.ApiMethod;
import com.bld.proxy.api.find.data.ParameterDetails;
import com.bld.proxy.api.find.exception.ApiFindException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.hibernate.query.BindableType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.data.repository.query.Param;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

public class FindInterceptor {
    private static final String PAGE_NUMBER = "pageNumber";
    private static final String PAGE_SIZE = "pageSize";
    private static final String ORDER_TYPE = "orderType";
    private static final String SORT_KEY = "sortKey";
    private static final Logger logger = LoggerFactory.getLogger(FindInterceptor.class);
    private static final List<String> PAGINATION_KEYS = Arrays.asList("sortKey", "orderType", "pageSize", "pageNumber");
    private static final List<Class<? extends Annotation>> REQUEST_ANNOTATIONS = Arrays.asList(RequestParam.class, RequestAttribute.class, PathVariable.class);
    private final ApplicationContext context;
    private final Map<String, Object> mapBean;
    private final ObjectMapper objMapper;

    public FindInterceptor(ApplicationContext context, Map<String, Object> mapBean, ObjectMapper objMapper) {
        this.context = context;
        this.mapBean = mapBean;
        this.objMapper = objMapper;
    }

    public <E, ID> Object find(Object obj, ApiMethod apiMethod) throws Throwable {
        Object response = null;
        try {
            apiMethod.setApiQuery(apiMethod.getMethod().getAnnotation(ApiQuery.class));
            ApiFind apiFind = apiMethod.getMethod().getAnnotation(ApiFind.class);
            if (apiFind == null) {
                apiFind = apiMethod.getMethod().getDeclaringClass().getAnnotation(ApiFind.class);
            }
            Class<?> entityClass = apiFind.entity();
            Class<?> idClass = apiFind.id();
            Class<?> outputClass = apiMethod.getMethod().getReturnType();
            this.getParameters(apiMethod.getMethod().getParameters(), apiMethod.getArgs(), apiMethod, RequestBody.class, AuthenticationPrincipal.class);
            Assert.isTrue((apiMethod.getApiQuery() == null || !StringUtils.isBlank((CharSequence)apiMethod.getApiQuery().value()) || apiMethod.getApiQuery().jpql() ? 1 : 0) != 0, (String)"For native query the field \"value\" can not be blank into ApiQuery");
            if (apiMethod.getApiQuery() == null || apiMethod.getApiQuery().jpql()) {
                response = this.jpqlQuery(entityClass, idClass, outputClass, apiMethod);
            } else {
                Class<?> modelClass = this.modelClass(apiMethod.getMethod());
                if (modelClass == null) {
                    modelClass = outputClass;
                }
                response = this.nativeQuery(entityClass, idClass, outputClass, modelClass, apiMethod);
            }
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw e;
        }
        return response;
    }

    private <E, ID, O> Object jpqlQuery(Class<E> entityClass, Class<ID> idClass, Class<O> outputClass, ApiMethod apiMethod) throws Exception {
        ObjectResponse response = null;
        apiMethod.setApiMapper(apiMethod.getMethod().getAnnotation(ApiMapper.class));
        if (apiMethod.getApiMapper() == null) {
            apiMethod.setApiMapper(apiMethod.getMethod().getDeclaringClass().getAnnotation(ApiMapper.class));
        }
        QueryParameter queryParameter = new QueryParameter();
        this.addBodyParameter((BaseQueryParameter<?, ?>)queryParameter, apiMethod);
        this.queryParameter(queryParameter, apiMethod);
        this.addUserDetails(queryParameter, apiMethod);
        this.firstStep((BaseQueryParameter<?, ?>)queryParameter, apiMethod);
        JpaServiceImpl<E, ID> jpaService = this.jpaService(entityClass, idClass);
        Class<?> modelClass = this.modelClass(apiMethod.getMethod());
        if (Number.class.isAssignableFrom(outputClass)) {
            response = this.countByFilter(queryParameter, jpaService, apiMethod);
        } else if (modelClass != null) {
            if (CollectionResponse.class.isAssignableFrom(outputClass)) {
                response = this.collectionResponse(queryParameter, jpaService, entityClass, modelClass, apiMethod);
            } else if (Collection.class.isAssignableFrom(outputClass)) {
                response = this.collection(queryParameter, jpaService, entityClass, outputClass, modelClass, apiMethod);
            } else if (ObjectResponse.class.isAssignableFrom(outputClass)) {
                response = Number.class.isAssignableFrom(modelClass) ? new ObjectResponse((Object)this.countByFilter(queryParameter, jpaService, apiMethod)) : new ObjectResponse(this.singleResultByFilter(queryParameter, jpaService, entityClass, modelClass, apiMethod));
            }
        } else {
            response = this.singleResultByFilter(queryParameter, jpaService, entityClass, outputClass, apiMethod);
        }
        return response;
    }

    private <ID, E> JpaServiceImpl<E, ID> jpaService(Class<E> entityClass, Class<ID> idClass) {
        return (JpaServiceImpl)this.mapBean.get(entityClass.getName() + " " + idClass.getName());
    }

    private void addBodyParameter(BaseQueryParameter<?, ?> queryParameter, ApiMethod apiMethod) {
        if (apiMethod.getMap().containsKey(RequestBody.class)) {
            Assert.isTrue((boolean)(apiMethod.getMap().get(RequestBody.class).getValue() instanceof BaseParameter), (String)"The body must be \"BaseParameter\" type");
            queryParameter.setBaseParameter((BaseParameter)apiMethod.getMap().get(RequestBody.class).getValue());
        }
    }

    private <E, ID, O, M> Object nativeQuery(Class<E> entityClass, Class<ID> idClass, Class<O> outputClass, Class<M> modelClass, ApiMethod apiMethod) throws Exception {
        ObjectResponse response = null;
        NativeQueryParameter queryParameter = new NativeQueryParameter(modelClass);
        this.addBodyParameter((BaseQueryParameter<?, ?>)queryParameter, apiMethod);
        this.queryParameter(queryParameter, apiMethod);
        this.addUserDetails(queryParameter, apiMethod);
        this.firstStep((BaseQueryParameter<?, ?>)queryParameter, apiMethod);
        JpaServiceImpl<E, ID> jpaService = this.jpaService(entityClass, idClass);
        if (Number.class.isAssignableFrom(outputClass)) {
            response = this.countByFilter(queryParameter, jpaService, apiMethod);
        } else if (modelClass != null) {
            if (CollectionResponse.class.isAssignableFrom(outputClass)) {
                response = this.collectionResponse(queryParameter, jpaService, apiMethod);
            } else if (Collection.class.isAssignableFrom(outputClass)) {
                response = this.collection(queryParameter, jpaService, outputClass, apiMethod);
            } else if (ObjectResponse.class.isAssignableFrom(outputClass)) {
                response = Number.class.isAssignableFrom(modelClass) ? new ObjectResponse((Object)this.countByFilter(queryParameter, jpaService, apiMethod)) : new ObjectResponse(this.singreResultByFilter(queryParameter, jpaService, apiMethod));
            }
        } else {
            response = this.singreResultByFilter(queryParameter, jpaService, apiMethod);
        }
        return response;
    }

    private void getParameters(Parameter[] parameters, Object[] args, ApiMethod apiMethod, Class<? extends Annotation> ... annotations) {
        if (ArrayUtils.isNotEmpty((Object[])parameters)) {
            for (int i = 0; i < parameters.length; ++i) {
                for (Class<? extends Annotation> annotation : annotations) {
                    if (!parameters[i].isAnnotationPresent(annotation) || !this.ignoreMapping(parameters[i])) continue;
                    apiMethod.getMap().put(annotation, new ParameterDetails(parameters[i], args[i], i));
                }
            }
        }
    }

    private Class<?> modelClass(Method method) throws ClassNotFoundException {
        String genericReturnType = method.getGenericReturnType().getTypeName();
        if (!genericReturnType.contains("<") || !genericReturnType.contains(">")) {
            return null;
        }
        String genericType = genericReturnType.substring(genericReturnType.indexOf("<") + 1, genericReturnType.lastIndexOf(">"));
        if (genericType.contains("<")) {
            genericType = genericType.substring(0, genericType.indexOf("<"));
        }
        return Class.forName(genericType);
    }

    private boolean ignoreMapping(Parameter parameter) {
        return !parameter.isAnnotationPresent(IgnoreMapping.class) || parameter.isAnnotationPresent(IgnoreMapping.class) && !parameter.getAnnotation(IgnoreMapping.class).value();
    }

    private void addUserDetails(NativeQueryParameter<?, ?> queryParameter, ApiMethod apiMethod) {
        ParameterDetails userDetails = apiMethod.getMap().get(AuthenticationPrincipal.class);
        if (userDetails != null) {
            UserDetails user = (UserDetails)userDetails.getValue();
            String key = "username";
            String username = user.getUsername();
            if (userDetails.getParameter().isAnnotationPresent(Param.class)) {
                key = userDetails.getParameter().getAnnotation(Param.class).value();
            }
            if (userDetails.getParameter().isAnnotationPresent(LikeString.class)) {
                username = (String)ReflectionCommons.value((Object)username, null, (LikeString)userDetails.getParameter().getAnnotation(LikeString.class));
            }
            ConditionsZones conditionsZones = userDetails.getParameter().getAnnotation(ConditionsZones.class);
            queryParameter.addParameter(key, (Object)username, conditionsZones);
        }
    }

    private void addUserDetails(QueryParameter<?, ?> queryParameter, ApiMethod apiMethod) {
        ParameterDetails userDetails = apiMethod.getMap().get(AuthenticationPrincipal.class);
        if (userDetails != null) {
            UserDetails user = (UserDetails)userDetails.getValue();
            String key = "username";
            String username = user.getUsername();
            if (userDetails.getParameter().isAnnotationPresent(Param.class)) {
                key = userDetails.getParameter().getAnnotation(Param.class).value();
            }
            if (userDetails.getParameter().isAnnotationPresent(LikeString.class)) {
                username = (String)ReflectionCommons.value((Object)username, null, (LikeString)userDetails.getParameter().getAnnotation(LikeString.class));
            }
            queryParameter.addParameter(key, (Object)username);
        }
    }

    private void firstStep(BaseQueryParameter<?, ?> queryParameter, ApiMethod apiMethod) throws Exception {
        if (apiMethod.getMethod().isAnnotationPresent(ApiBeforeRequest.class)) {
            ApiBeforeRequest beforeRequest = apiMethod.getMethod().getAnnotation(ApiBeforeRequest.class);
            Object bean = this.context.getBean(beforeRequest.bean());
            Class[] paramaterClasses = new Class[apiMethod.getArgs().length + 1];
            Object[] parameters = new Object[apiMethod.getArgs().length + 1];
            int i = 0;
            for (Object arg : apiMethod.getArgs()) {
                paramaterClasses[i] = arg.getClass();
                parameters[i] = arg;
                ++i;
            }
            parameters[i] = queryParameter;
            paramaterClasses[i] = queryParameter.getClass();
            Method m = beforeRequest.bean().getMethod(beforeRequest.method(), paramaterClasses);
            m.invoke(bean, parameters);
        }
    }

    private boolean isRequestAnnotationPresent(Parameter parameter) {
        for (Class<? extends Annotation> annotation : REQUEST_ANNOTATIONS) {
            if (!parameter.isAnnotationPresent(annotation)) continue;
            return true;
        }
        return false;
    }

    private void queryParameter(NativeQueryParameter<?, ?> queryParameter, ApiMethod apiMethod) {
        if (ArrayUtils.isNotEmpty((Object[])apiMethod.getArgs())) {
            HashMap<String, Object> mapPagination = new HashMap<String, Object>();
            for (int i = 0; i < apiMethod.getArgs().length; ++i) {
                Parameter parameter = apiMethod.getMethod().getParameters()[i];
                if (this.isRequestAnnotationPresent(parameter) && this.ignoreMapping(parameter)) {
                    String name = parameter.getName();
                    Object value = apiMethod.getArgs()[i];
                    if (!PAGINATION_KEYS.contains(name)) {
                        try {
                            ConditionsZones conditionsZones = parameter.getAnnotation(ConditionsZones.class);
                            if (value instanceof Collection && CollectionUtils.isEmpty((Collection)((Collection)value))) {
                                value = null;
                            }
                            if (value != null && value instanceof String && StringUtils.isBlank((CharSequence)((String)value))) {
                                value = null;
                            }
                            if (value != null) {
                                LikeString likeString;
                                DateFilter dateFilter = parameter.getAnnotation(DateFilter.class);
                                if ((value = ReflectionCommons.value((Object)value, (DateFilter)dateFilter, (LikeString)(likeString = parameter.getAnnotation(LikeString.class)))) instanceof Boolean && ((Boolean)value).booleanValue() && parameter.isAnnotationPresent(ListFilter.class)) {
                                    queryParameter.addNullable(name, conditionsZones);
                                } else if (value.getClass().isArray()) {
                                    Object[] array = (Object[])value;
                                    queryParameter.addParameter(name, Arrays.asList(array), conditionsZones);
                                } else {
                                    queryParameter.addParameter(name, value, conditionsZones);
                                }
                            } else if (parameter.isAnnotationPresent(FilterNullValue.class) && parameter.getAnnotation(FilterNullValue.class).value()) {
                                queryParameter.addParameter(name, (Object)ReflectionCommons.initTypedParameterValue((BindableType)((BindableType)ReflectionCommons.mapType.get(parameter.getType())), (Object)value), conditionsZones);
                            } else if (conditionsZones != null) {
                                queryParameter.addEmptyZones(conditionsZones);
                            }
                        }
                        catch (Exception e) {
                            logger.warn("Error converting data to map");
                        }
                    } else {
                        mapPagination.put(name, value);
                    }
                }
                queryParameter.addOrderBy((String)mapPagination.get(SORT_KEY), (OrderType)mapPagination.get(ORDER_TYPE));
                queryParameter.setPageable((Integer)mapPagination.get(PAGE_NUMBER), (Integer)mapPagination.get(PAGE_SIZE));
            }
        }
    }

    private void queryParameter(QueryParameter<?, ?> queryParameter, ApiMethod apiMethod) throws Exception {
        if (ArrayUtils.isNotEmpty((Object[])apiMethod.getArgs())) {
            HashMap<String, Object> mapPagination = new HashMap<String, Object>();
            for (int i = 0; i < apiMethod.getArgs().length; ++i) {
                Parameter parameter = apiMethod.getMethod().getParameters()[i];
                if (this.isRequestAnnotationPresent(parameter) && this.ignoreMapping(parameter)) {
                    String name = parameter.getName();
                    Object value = apiMethod.getArgs()[i];
                    if (!PAGINATION_KEYS.contains(name)) {
                        if (value instanceof Collection && CollectionUtils.isEmpty((Collection)((Collection)value))) {
                            value = null;
                        }
                        if (value != null && value instanceof String && StringUtils.isBlank((CharSequence)((String)value))) {
                            value = null;
                        }
                        if (value != null) {
                            LikeString likeString;
                            DateFilter dateFilter = parameter.getAnnotation(DateFilter.class);
                            if ((value = ReflectionCommons.value((Object)value, (DateFilter)dateFilter, (LikeString)(likeString = parameter.getAnnotation(LikeString.class)))) instanceof Boolean && ((Boolean)value).booleanValue() && parameter.isAnnotationPresent(ListFilter.class)) {
                                queryParameter.addNullable(name);
                            } else if (value.getClass().isArray()) {
                                Object[] array = (Object[])value;
                                queryParameter.addParameter(name, Arrays.asList(array));
                            } else {
                                queryParameter.addParameter(name, value);
                            }
                        } else if (parameter.isAnnotationPresent(FilterNullValue.class) && parameter.getAnnotation(FilterNullValue.class).value()) {
                            queryParameter.addParameter(name, (Object)ReflectionCommons.initTypedParameterValue((BindableType)((BindableType)ReflectionCommons.mapType.get(parameter.getType())), (Object)value));
                        }
                    } else {
                        mapPagination.put(name, value);
                    }
                }
                queryParameter.addOrderBy((String)mapPagination.get(SORT_KEY), (OrderType)mapPagination.get(ORDER_TYPE));
                queryParameter.setPageable((Integer)mapPagination.get(PAGE_NUMBER), (Integer)mapPagination.get(PAGE_SIZE));
            }
        }
    }

    private <ID, E, M> CollectionResponse<M> collectionResponse(QueryParameter<E, ID> queryParameter, JpaServiceImpl<E, ID> jpaService, Class<E> entityClass, Class<M> modelClass, ApiMethod apiMethod) throws Exception {
        CollectionResponse response = new CollectionResponse();
        Long totalCount = 0L;
        if (apiMethod.getApiQuery() == null || StringUtils.isBlank((CharSequence)apiMethod.getApiQuery().value())) {
            totalCount = this.countByFilter(queryParameter, jpaService, apiMethod);
        }
        response.setTotalCount(totalCount);
        if (totalCount > 0L || apiMethod.getApiQuery() != null && StringUtils.isNotBlank((CharSequence)apiMethod.getApiQuery().value())) {
            this.defaultOrderBy((BaseQueryParameter<?, ?>)queryParameter, apiMethod);
            List<M> list = this.findByFilter(queryParameter, jpaService, entityClass, modelClass, apiMethod);
            response.setData(list);
            if (queryParameter.getPageable() != null) {
                response.setPageNumber(Integer.valueOf(queryParameter.getPageable().getPageNumber()));
                response.setPageSize(Integer.valueOf(queryParameter.getPageable().getPageSize()));
            }
        }
        return response;
    }

    private <ID, E, K> CollectionResponse<K> collectionResponse(NativeQueryParameter<K, ID> queryParameter, JpaServiceImpl<E, ID> jpaService, ApiMethod apiMethod) throws Exception {
        CollectionResponse response = new CollectionResponse();
        this.defaultOrderBy((BaseQueryParameter<?, ?>)queryParameter, apiMethod);
        List list = jpaService.findByFilter(queryParameter, apiMethod.getApiQuery().value());
        response.setData((Object)list);
        if (queryParameter.getPageable() != null) {
            response.setPageNumber(Integer.valueOf(queryParameter.getPageable().getPageNumber()));
            response.setPageSize(Integer.valueOf(queryParameter.getPageable().getPageSize()));
        }
        return response;
    }

    private <K, L extends Collection<?>, E, ID> L collection(NativeQueryParameter<K, ID> queryParameter, JpaServiceImpl<E, ID> jpaService, Class<L> collectionClass, ApiMethod apiMethod) throws Exception {
        this.defaultOrderBy((BaseQueryParameter<?, ?>)queryParameter, apiMethod);
        List list = jpaService.findByFilter(queryParameter, apiMethod.getApiQuery().value());
        Collection l = null;
        l = List.class.equals(collectionClass) ? new ArrayList(list) : (Set.class.equals(collectionClass) ? new HashSet(list) : (Collection)collectionClass.getDeclaredConstructor(Collection.class).newInstance(list));
        return (L)l;
    }

    private <E, K, ID> K singreResultByFilter(NativeQueryParameter<K, ID> queryParameter, JpaServiceImpl<E, ID> jpaService, ApiMethod apiMethod) throws Exception {
        return (K)jpaService.singleResultByFilter(queryParameter, apiMethod.getApiQuery().value());
    }

    private void defaultOrderBy(BaseQueryParameter<?, ?> queryParameter, ApiMethod apiMethod) {
        if (CollectionUtils.isEmpty((Collection)queryParameter.getListOrderBy()) && apiMethod.getApiQuery() != null) {
            for (DefaultOrderBy orderBy : apiMethod.getApiQuery().orderBy()) {
                queryParameter.addOrderBy(orderBy.value(), orderBy.orderType());
            }
        }
    }

    private <E, ID> Long countByFilter(QueryParameter<E, ID> queryParameter, JpaServiceImpl<E, ID> jpaService, ApiMethod apiMethod) {
        Long totalCount = 0L;
        totalCount = apiMethod.getApiQuery() == null || StringUtils.isBlank((CharSequence)apiMethod.getApiQuery().value()) ? jpaService.countByFilter(queryParameter) : jpaService.countByFilter(queryParameter, apiMethod.getApiQuery().value());
        return totalCount;
    }

    private <K, E, ID> Long countByFilter(NativeQueryParameter<K, ID> queryParameter, JpaServiceImpl<E, ID> jpaService, ApiMethod apiMethod) {
        Long totalCount = 0L;
        totalCount = jpaService.countByFilter(queryParameter, apiMethod.getApiQuery().value());
        return totalCount;
    }

    private <M, L extends Collection<?>, E, ID> L collection(QueryParameter<E, ID> queryParameter, JpaServiceImpl<E, ID> jpaService, Class<E> entityClass, Class<L> collectionClass, Class<M> modelClass, ApiMethod apiMethod) throws Exception {
        this.defaultOrderBy((BaseQueryParameter<?, ?>)queryParameter, apiMethod);
        List<M> list = this.findByFilter(queryParameter, jpaService, entityClass, modelClass, apiMethod);
        Collection<Object> l = null;
        l = List.class.equals(collectionClass) ? new ArrayList<M>(list) : (Set.class.equals(collectionClass) ? new HashSet<M>(list) : (Collection)collectionClass.getDeclaredConstructor(Collection.class).newInstance(list));
        return (L)l;
    }

    private <M, E, ID> List<M> findByFilter(QueryParameter<E, ID> queryParameter, JpaServiceImpl<E, ID> jpaService, Class<E> entityClass, Class<M> modelClass, ApiMethod apiMethod) throws Exception {
        List entities = null;
        entities = apiMethod.getApiQuery() == null || StringUtils.isBlank((CharSequence)apiMethod.getApiQuery().value()) ? jpaService.findByFilter(queryParameter) : jpaService.findByFilter(queryParameter, apiMethod.getApiQuery().value());
        ArrayList<Object> models = new ArrayList<Object>();
        if (apiMethod.getApiMapper() == null) {
            throw new ApiFindException("The class to convert the entity to output is not declared");
        }
        try {
            Object mapper = this.mapBean.get(apiMethod.getApiMapper().value().getName());
            Method mapperMethod = this.methodMapper(entityClass, modelClass, mapper.getClass(), apiMethod.getApiMapper().method());
            Object[] types = this.outputGenericType(mapperMethod);
            for (Object entity : entities) {
                String json = this.objMapper.writeValueAsString(mapperMethod.invoke(mapper, entity));
                if (ArrayUtils.isNotEmpty((Object[])types)) {
                    JavaType type = this.objMapper.getTypeFactory().constructParametricType(modelClass, (Class[])types);
                    models.add(this.objMapper.readValue(json, type));
                    continue;
                }
                models.add(this.objMapper.readValue(json, modelClass));
            }
        }
        catch (Throwable e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new ApiFindException("Method mapper is not found", e);
        }
        return models;
    }

    private Class<?>[] outputGenericType(Method method) throws Exception {
        ParameterizedType type;
        Object[] typeArguments;
        Type returnType = method.getGenericReturnType();
        Class[] types = null;
        int i = 0;
        if (returnType instanceof ParameterizedType && ArrayUtils.isNotEmpty((Object[])(typeArguments = (type = (ParameterizedType)returnType).getActualTypeArguments()))) {
            types = new Class[typeArguments.length];
            for (Object typeArgument : typeArguments) {
                types[i++] = Class.forName(typeArgument.getTypeName());
            }
        }
        return types;
    }

    private <E, M, ID> M singleResultByFilter(QueryParameter<E, ID> queryParameter, JpaServiceImpl<E, ID> jpaService, Class<E> entityClass, Class<M> modelClass, ApiMethod apiMethod) throws Exception {
        Object entity = null;
        entity = apiMethod.getApiQuery() == null || StringUtils.isBlank((CharSequence)apiMethod.getApiQuery().value()) ? jpaService.singleResultByFilter(queryParameter) : jpaService.singleResultByFilter(queryParameter, apiMethod.getApiQuery().value());
        Object model = null;
        if (entity != null) {
            if (apiMethod.getApiMapper() == null) {
                throw new ApiFindException("The class to convert the entity to output is not declared");
            }
            try {
                Object mapper = this.mapBean.get(apiMethod.getApiMapper().value().getName());
                Method mapperMethod = this.methodMapper(entityClass, modelClass, mapper.getClass(), apiMethod.getApiMapper().method());
                Object[] types = this.outputGenericType(mapperMethod);
                String json = this.objMapper.writeValueAsString(mapperMethod.invoke(mapper, entity));
                if (ArrayUtils.isNotEmpty((Object[])types)) {
                    JavaType type = this.objMapper.getTypeFactory().constructParametricType(modelClass, (Class[])types);
                    model = this.objMapper.readValue(json, type);
                } else {
                    model = this.objMapper.readValue(json, modelClass);
                }
            }
            catch (NoSuchMethodException e) {
                logger.error("Method mapper is not found");
                throw new ApiFindException("Method mapper is not found", e);
            }
        }
        return (M)model;
    }

    private <P, O> Method methodMapper(Class<P> parameterClass, Class<O> outputClass, Class<?> mapperClass, String methodName) throws Exception {
        Method method = null;
        try {
            method = StringUtils.isBlank((CharSequence)methodName) ? this.findMethod(mapperClass, parameterClass, outputClass) : mapperClass.getMethod(methodName, parameterClass);
        }
        catch (NoSuchMethodException e) {
            logger.error("Method mapper is not found");
            throw new ApiFindException("Method mapper is not found", e);
        }
        return method;
    }

    private <M, P, O> Method findMethod(Class<M> mapperClass, Class<P> parameterClass, Class<O> outputClass) throws Exception {
        Method methodFound = null;
        Method methodAssignInputFound = null;
        int countMethodFound = 0;
        int countAssignMethodFound = 0;
        Set methods = ReflectionCommons.methods(mapperClass);
        for (Method method : methods) {
            if (method.getParameterCount() != 1 || !method.getReturnType().getName().equals(outputClass.getName())) continue;
            if (method.getParameterTypes()[0].getName().equals(parameterClass.getName())) {
                methodFound = method;
                ++countMethodFound;
                continue;
            }
            if (!Class.forName(method.getParameterTypes()[0].getName()).isAssignableFrom(Class.forName(parameterClass.getName()))) continue;
            methodAssignInputFound = method;
            ++countAssignMethodFound;
        }
        if (countMethodFound == 1) {
            return methodFound;
        }
        if (countAssignMethodFound == 1) {
            return methodAssignInputFound;
        }
        if (countMethodFound > 1 || countAssignMethodFound > 1) {
            throw new ApiFindException("More compatible methods were found in the mapping class, use @ApiMethodMapper or @ApiMapper to select the method name");
        }
        throw new ApiFindException("Method mapper is not found");
    }
}

