/*
 * Decompiled with CFR 0.152.
 */
package com.bld.proxy.api.find.intecerptor;

import bld.commons.reflection.annotations.ConditionsZones;
import bld.commons.reflection.annotations.DateFilter;
import bld.commons.reflection.annotations.FilterNullValue;
import bld.commons.reflection.annotations.IgnoreMapping;
import bld.commons.reflection.annotations.LikeString;
import bld.commons.reflection.annotations.ListFilter;
import bld.commons.reflection.model.BaseParameter;
import bld.commons.reflection.model.BaseQueryParameter;
import bld.commons.reflection.model.NativeQueryParameter;
import bld.commons.reflection.model.QueryParameter;
import bld.commons.reflection.type.OrderType;
import bld.commons.reflection.utils.ReflectionCommons;
import bld.commons.service.JpaService;
import com.bld.commons.utils.data.CollectionResponse;
import com.bld.commons.utils.data.ObjectResponse;
import com.bld.proxy.api.find.annotations.ApiBeforeRequest;
import com.bld.proxy.api.find.annotations.ApiFind;
import com.bld.proxy.api.find.annotations.ApiMapper;
import com.bld.proxy.api.find.config.ApiQuery;
import com.bld.proxy.api.find.config.DefaultOrderBy;
import com.bld.proxy.api.find.data.ParameterDetails;
import com.bld.proxy.api.find.exception.ApiFindException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.hibernate.query.BindableType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Scope;
import org.springframework.core.ResolvableType;
import org.springframework.data.repository.query.Param;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@Component
@Scope(value="prototype")
class FindInterceptor {
    private static final String PAGE_NUMBER = "pageNumber";
    private static final String PAGE_SIZE = "pageSize";
    private static final String ORDER_TYPE = "orderType";
    private static final String SORT_KEY = "sortKey";
    private static final Logger logger = LoggerFactory.getLogger(FindInterceptor.class);
    private static final List<String> PAGINATION_KEYS = Arrays.asList("sortKey", "orderType", "pageSize", "pageNumber");
    private static final List<Class<? extends Annotation>> REQUEST_ANNOTATIONS = Arrays.asList(RequestParam.class, RequestAttribute.class, PathVariable.class);
    private Method method;
    private Object[] args;
    private Map<Class<? extends Annotation>, ParameterDetails> map;
    @Autowired
    private ApplicationContext applicationContext;
    private ApiQuery apiQuery;
    private ApiMapper apiMapper;

    FindInterceptor() {
    }

    public <E, ID> Object find(Object obj, Method method, Object[] args) throws Throwable {
        Object response = null;
        try {
            this.apiQuery = method.getAnnotation(ApiQuery.class);
            ApiFind apiFind = method.getAnnotation(ApiFind.class);
            if (apiFind == null) {
                apiFind = method.getDeclaringClass().getAnnotation(ApiFind.class);
            }
            this.method = method;
            this.args = args;
            Class<?> entityClass = apiFind.entity();
            Class<?> idClass = apiFind.id();
            Class<?> outputClass = method.getReturnType();
            this.getParameters(this.method.getParameters(), args, RequestBody.class, AuthenticationPrincipal.class);
            Assert.isTrue((this.apiQuery == null || !StringUtils.isBlank((CharSequence)this.apiQuery.value()) || this.apiQuery.jpql() ? 1 : 0) != 0, (String)"For native query the field \"value\" can not be blank into ApiQuery");
            if (this.apiQuery == null || this.apiQuery.jpql()) {
                response = this.jpqlQuery(entityClass, idClass, outputClass);
            } else {
                Class<?> modelClass = this.modelClass(method);
                if (modelClass == null) {
                    modelClass = outputClass;
                }
                response = this.nativeQuery(entityClass, idClass, outputClass, modelClass);
            }
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw e;
        }
        return response;
    }

    private <E, ID, O> Object jpqlQuery(Class<E> entityClass, Class<ID> idClass, Class<O> outputClass) throws Exception {
        ObjectResponse response = null;
        this.apiMapper = this.method.getAnnotation(ApiMapper.class);
        if (this.apiMapper == null) {
            this.apiMapper = this.method.getDeclaringClass().getAnnotation(ApiMapper.class);
        }
        QueryParameter queryParameter = new QueryParameter();
        this.addBodyParameter((BaseQueryParameter<?, ?>)queryParameter);
        this.queryParameter(queryParameter);
        this.addUserDetails(queryParameter);
        this.firstStep((BaseQueryParameter<?, ?>)queryParameter);
        JpaService<E, ID> jpaService = this.jpaService(entityClass, idClass);
        Class<?> modelClass = this.modelClass(this.method);
        if (Number.class.isAssignableFrom(outputClass)) {
            response = this.countByFilter(queryParameter, jpaService);
        } else if (modelClass != null) {
            if (CollectionResponse.class.isAssignableFrom(outputClass)) {
                response = this.collectionResponse(queryParameter, jpaService, entityClass, modelClass);
            } else if (Collection.class.isAssignableFrom(outputClass)) {
                response = this.collection(queryParameter, jpaService, entityClass, outputClass, modelClass);
            } else if (ObjectResponse.class.isAssignableFrom(outputClass)) {
                response = Number.class.isAssignableFrom(modelClass) ? new ObjectResponse((Object)this.countByFilter(queryParameter, jpaService)) : new ObjectResponse(this.singleResultByFilter(queryParameter, jpaService, entityClass, modelClass));
            }
        } else {
            response = this.singleResultByFilter(queryParameter, jpaService, entityClass, outputClass);
        }
        return response;
    }

    private <ID, E> JpaService<E, ID> jpaService(Class<E> entityClass, Class<ID> idClass) {
        ResolvableType resolvableType = ResolvableType.forClassWithGenerics(JpaService.class, (Class[])new Class[]{entityClass, idClass});
        JpaService jpaService = (JpaService)this.applicationContext.getBeanProvider(resolvableType).getObject();
        return jpaService;
    }

    private void addBodyParameter(BaseQueryParameter<?, ?> queryParameter) {
        if (this.map.containsKey(RequestBody.class)) {
            Assert.isTrue((boolean)(this.map.get(RequestBody.class).getValue() instanceof BaseParameter), (String)"The body must be \"BaseParameter\" type");
            queryParameter.setBaseParameter((BaseParameter)this.map.get(RequestBody.class).getValue());
        }
    }

    private <E, ID, O, M> Object nativeQuery(Class<E> entityClass, Class<ID> idClass, Class<O> outputClass, Class<M> modelClass) throws Exception {
        ObjectResponse response = null;
        NativeQueryParameter queryParameter = new NativeQueryParameter(modelClass);
        this.addBodyParameter((BaseQueryParameter<?, ?>)queryParameter);
        this.queryParameter(queryParameter);
        this.addUserDetails(queryParameter);
        this.firstStep((BaseQueryParameter<?, ?>)queryParameter);
        JpaService<E, ID> jpaService = this.jpaService(entityClass, idClass);
        if (Number.class.isAssignableFrom(outputClass)) {
            response = this.countByFilter(queryParameter, jpaService);
        } else if (modelClass != null) {
            if (CollectionResponse.class.isAssignableFrom(outputClass)) {
                response = this.collectionResponse(queryParameter, jpaService);
            } else if (Collection.class.isAssignableFrom(outputClass)) {
                response = this.collection(queryParameter, jpaService, outputClass);
            } else if (ObjectResponse.class.isAssignableFrom(outputClass)) {
                response = Number.class.isAssignableFrom(modelClass) ? new ObjectResponse((Object)this.countByFilter(queryParameter, jpaService)) : new ObjectResponse(this.singreResultByFilter(queryParameter, jpaService));
            }
        } else {
            response = this.singreResultByFilter(queryParameter, jpaService);
        }
        return response;
    }

    private void getParameters(Parameter[] parameters, Object[] args, Class<? extends Annotation> ... annotations) {
        this.map = new HashMap<Class<? extends Annotation>, ParameterDetails>();
        if (ArrayUtils.isNotEmpty((Object[])parameters)) {
            for (int i = 0; i < parameters.length; ++i) {
                for (Class<? extends Annotation> annotation : annotations) {
                    if (!parameters[i].isAnnotationPresent(annotation) || !this.ignoreMapping(parameters[i])) continue;
                    this.map.put(annotation, new ParameterDetails(parameters[i], args[i], i));
                }
            }
        }
    }

    private Class<?> modelClass(Method method) throws ClassNotFoundException {
        String genericReturnType = method.getGenericReturnType().getTypeName();
        if (!genericReturnType.contains("<") || !genericReturnType.contains(">")) {
            return null;
        }
        String genericType = genericReturnType.substring(genericReturnType.indexOf("<") + 1, genericReturnType.lastIndexOf(">"));
        if (genericType.contains("<")) {
            genericType = genericType.substring(0, genericType.indexOf("<"));
        }
        return Class.forName(genericType);
    }

    private boolean ignoreMapping(Parameter parameter) {
        return !parameter.isAnnotationPresent(IgnoreMapping.class) || parameter.isAnnotationPresent(IgnoreMapping.class) && !parameter.getAnnotation(IgnoreMapping.class).value();
    }

    private void addUserDetails(NativeQueryParameter<?, ?> queryParameter) {
        ParameterDetails userDetails = this.map.get(AuthenticationPrincipal.class);
        if (userDetails != null) {
            UserDetails user = (UserDetails)userDetails.getValue();
            String key = "username";
            String username = user.getUsername();
            if (userDetails.getParameter().isAnnotationPresent(Param.class)) {
                key = userDetails.getParameter().getAnnotation(Param.class).value();
            }
            if (userDetails.getParameter().isAnnotationPresent(LikeString.class)) {
                username = (String)ReflectionCommons.value((Object)username, null, (LikeString)userDetails.getParameter().getAnnotation(LikeString.class));
            }
            ConditionsZones conditionsZones = userDetails.getParameter().getAnnotation(ConditionsZones.class);
            queryParameter.addParameter(key, (Object)username, conditionsZones);
        }
    }

    private void addUserDetails(QueryParameter<?, ?> queryParameter) {
        ParameterDetails userDetails = this.map.get(AuthenticationPrincipal.class);
        if (userDetails != null) {
            UserDetails user = (UserDetails)userDetails.getValue();
            String key = "username";
            String username = user.getUsername();
            if (userDetails.getParameter().isAnnotationPresent(Param.class)) {
                key = userDetails.getParameter().getAnnotation(Param.class).value();
            }
            if (userDetails.getParameter().isAnnotationPresent(LikeString.class)) {
                username = (String)ReflectionCommons.value((Object)username, null, (LikeString)userDetails.getParameter().getAnnotation(LikeString.class));
            }
            queryParameter.addParameter(key, (Object)username);
        }
    }

    private void firstStep(BaseQueryParameter<?, ?> queryParameter) throws Exception {
        if (this.method.isAnnotationPresent(ApiBeforeRequest.class)) {
            ApiBeforeRequest beforeRequest = this.method.getAnnotation(ApiBeforeRequest.class);
            Object bean = this.applicationContext.getBean(beforeRequest.bean());
            Class[] paramaterClasses = new Class[this.args.length + 1];
            Object[] parameters = new Object[this.args.length + 1];
            int i = 0;
            for (Object arg : this.args) {
                paramaterClasses[i] = arg.getClass();
                parameters[i] = arg;
                ++i;
            }
            parameters[i] = queryParameter;
            paramaterClasses[i] = queryParameter.getClass();
            Method m = beforeRequest.bean().getMethod(beforeRequest.method(), paramaterClasses);
            m.invoke(bean, parameters);
        }
    }

    private boolean isRequestAnnotationPresent(Parameter parameter) {
        for (Class<? extends Annotation> annotation : REQUEST_ANNOTATIONS) {
            if (!parameter.isAnnotationPresent(annotation)) continue;
            return true;
        }
        return false;
    }

    private void queryParameter(NativeQueryParameter<?, ?> queryParameter) {
        if (ArrayUtils.isNotEmpty((Object[])this.args)) {
            HashMap<String, Object> mapPagination = new HashMap<String, Object>();
            for (int i = 0; i < this.args.length; ++i) {
                Parameter parameter = this.method.getParameters()[i];
                if (this.isRequestAnnotationPresent(parameter) && this.ignoreMapping(parameter)) {
                    String name = parameter.getName();
                    Object value = this.args[i];
                    if (!PAGINATION_KEYS.contains(name)) {
                        try {
                            ConditionsZones conditionsZones = parameter.getAnnotation(ConditionsZones.class);
                            if (value instanceof Collection && CollectionUtils.isEmpty((Collection)((Collection)value))) {
                                value = null;
                            }
                            if (value != null && value instanceof String && StringUtils.isBlank((CharSequence)((String)value))) {
                                value = null;
                            }
                            if (value != null) {
                                LikeString likeString;
                                DateFilter dateFilter = parameter.getAnnotation(DateFilter.class);
                                if ((value = ReflectionCommons.value((Object)value, (DateFilter)dateFilter, (LikeString)(likeString = parameter.getAnnotation(LikeString.class)))) instanceof Boolean && ((Boolean)value).booleanValue() && parameter.isAnnotationPresent(ListFilter.class)) {
                                    queryParameter.addNullable(name, conditionsZones);
                                } else if (value.getClass().isArray()) {
                                    Object[] array = (Object[])value;
                                    queryParameter.addParameter(name, Arrays.asList(array), conditionsZones);
                                } else {
                                    queryParameter.addParameter(name, value, conditionsZones);
                                }
                            } else if (parameter.isAnnotationPresent(FilterNullValue.class) && parameter.getAnnotation(FilterNullValue.class).value()) {
                                queryParameter.addParameter(name, (Object)ReflectionCommons.initTypedParameterValue((BindableType)((BindableType)ReflectionCommons.mapType.get(parameter.getType())), (Object)value), conditionsZones);
                            } else if (conditionsZones != null) {
                                queryParameter.addEmptyZones(conditionsZones);
                            }
                        }
                        catch (Exception e) {
                            logger.warn("Error converting data to map");
                        }
                    } else {
                        mapPagination.put(name, value);
                    }
                }
                queryParameter.addOrderBy((String)mapPagination.get(SORT_KEY), (OrderType)mapPagination.get(ORDER_TYPE));
                queryParameter.setPageable((Integer)mapPagination.get(PAGE_NUMBER), (Integer)mapPagination.get(PAGE_SIZE));
            }
        }
    }

    private void queryParameter(QueryParameter<?, ?> queryParameter) throws Exception {
        if (ArrayUtils.isNotEmpty((Object[])this.args)) {
            HashMap<String, Object> mapPagination = new HashMap<String, Object>();
            for (int i = 0; i < this.args.length; ++i) {
                Parameter parameter = this.method.getParameters()[i];
                if (this.isRequestAnnotationPresent(parameter) && this.ignoreMapping(parameter)) {
                    String name = parameter.getName();
                    Object value = this.args[i];
                    if (!PAGINATION_KEYS.contains(name)) {
                        if (value instanceof Collection && CollectionUtils.isEmpty((Collection)((Collection)value))) {
                            value = null;
                        }
                        if (value != null && value instanceof String && StringUtils.isBlank((CharSequence)((String)value))) {
                            value = null;
                        }
                        if (value != null) {
                            LikeString likeString;
                            DateFilter dateFilter = parameter.getAnnotation(DateFilter.class);
                            if ((value = ReflectionCommons.value((Object)value, (DateFilter)dateFilter, (LikeString)(likeString = parameter.getAnnotation(LikeString.class)))) instanceof Boolean && ((Boolean)value).booleanValue() && parameter.isAnnotationPresent(ListFilter.class)) {
                                queryParameter.addNullable(name);
                            } else if (value.getClass().isArray()) {
                                Object[] array = (Object[])value;
                                queryParameter.addParameter(name, Arrays.asList(array));
                            } else {
                                queryParameter.addParameter(name, value);
                            }
                        } else if (parameter.isAnnotationPresent(FilterNullValue.class) && parameter.getAnnotation(FilterNullValue.class).value()) {
                            queryParameter.addParameter(name, (Object)ReflectionCommons.initTypedParameterValue((BindableType)((BindableType)ReflectionCommons.mapType.get(parameter.getType())), (Object)value));
                        }
                    } else {
                        mapPagination.put(name, value);
                    }
                }
                queryParameter.addOrderBy((String)mapPagination.get(SORT_KEY), (OrderType)mapPagination.get(ORDER_TYPE));
                queryParameter.setPageable((Integer)mapPagination.get(PAGE_NUMBER), (Integer)mapPagination.get(PAGE_SIZE));
            }
        }
    }

    private <ID, E, M> CollectionResponse<M> collectionResponse(QueryParameter<E, ID> queryParameter, JpaService<E, ID> jpaService, Class<E> entityClass, Class<M> modelClass) throws Exception {
        CollectionResponse response = new CollectionResponse();
        Long totalCount = 0L;
        if (this.apiQuery == null || StringUtils.isBlank((CharSequence)this.apiQuery.value())) {
            totalCount = this.countByFilter(queryParameter, jpaService);
        }
        response.setTotalCount(totalCount);
        if (totalCount > 0L || this.apiQuery != null && StringUtils.isNotBlank((CharSequence)this.apiQuery.value())) {
            this.defaultOrderBy((BaseQueryParameter<?, ?>)queryParameter);
            List<M> list = this.findByFilter(queryParameter, jpaService, entityClass, modelClass);
            response.setData(list);
            if (queryParameter.getPageable() != null) {
                response.setPageNumber(Integer.valueOf(queryParameter.getPageable().getPageNumber()));
                response.setPageSize(Integer.valueOf(queryParameter.getPageable().getPageSize()));
            }
        }
        return response;
    }

    private <ID, E, K> CollectionResponse<K> collectionResponse(NativeQueryParameter<K, ID> queryParameter, JpaService<E, ID> jpaService) throws Exception {
        CollectionResponse response = new CollectionResponse();
        this.defaultOrderBy((BaseQueryParameter<?, ?>)queryParameter);
        List list = jpaService.findByFilter(queryParameter, this.apiQuery.value());
        response.setData((Object)list);
        if (queryParameter.getPageable() != null) {
            response.setPageNumber(Integer.valueOf(queryParameter.getPageable().getPageNumber()));
            response.setPageSize(Integer.valueOf(queryParameter.getPageable().getPageSize()));
        }
        return response;
    }

    private <K, L extends Collection<?>, E, ID> L collection(NativeQueryParameter<K, ID> queryParameter, JpaService<E, ID> jpaService, Class<L> collectionClass) throws Exception {
        this.defaultOrderBy((BaseQueryParameter<?, ?>)queryParameter);
        List list = jpaService.findByFilter(queryParameter, this.apiQuery.value());
        Collection l = null;
        l = List.class.equals(collectionClass) ? new ArrayList(list) : (Set.class.equals(collectionClass) ? new HashSet(list) : (Collection)collectionClass.getDeclaredConstructor(Collection.class).newInstance(list));
        return (L)l;
    }

    private <E, K, ID> K singreResultByFilter(NativeQueryParameter<K, ID> queryParameter, JpaService<E, ID> jpaService) throws Exception {
        return (K)jpaService.singleResultByFilter(queryParameter, this.apiQuery.value());
    }

    private void defaultOrderBy(BaseQueryParameter<?, ?> queryParameter) {
        if (CollectionUtils.isEmpty((Collection)queryParameter.getListOrderBy()) && this.apiQuery != null) {
            for (DefaultOrderBy orderBy : this.apiQuery.orderBy()) {
                queryParameter.addOrderBy(orderBy.value(), orderBy.orderType());
            }
        }
    }

    private <E, ID> Long countByFilter(QueryParameter<E, ID> queryParameter, JpaService<E, ID> jpaService) {
        Long totalCount = 0L;
        totalCount = this.apiQuery == null || StringUtils.isBlank((CharSequence)this.apiQuery.value()) ? jpaService.countByFilter(queryParameter) : jpaService.countByFilter(queryParameter, this.apiQuery.value());
        return totalCount;
    }

    private <K, E, ID> Long countByFilter(NativeQueryParameter<K, ID> queryParameter, JpaService<E, ID> jpaService) {
        Long totalCount = 0L;
        totalCount = jpaService.countByFilter(queryParameter, this.apiQuery.value());
        return totalCount;
    }

    private <M, L extends Collection<?>, E, ID> L collection(QueryParameter<E, ID> queryParameter, JpaService<E, ID> jpaService, Class<E> entityClass, Class<L> collectionClass, Class<M> modelClass) throws Exception {
        this.defaultOrderBy((BaseQueryParameter<?, ?>)queryParameter);
        List<M> list = this.findByFilter(queryParameter, jpaService, entityClass, modelClass);
        Collection<Object> l = null;
        l = List.class.equals(collectionClass) ? new ArrayList<M>(list) : (Set.class.equals(collectionClass) ? new HashSet<M>(list) : (Collection)collectionClass.getDeclaredConstructor(Collection.class).newInstance(list));
        return (L)l;
    }

    private <M, E, ID> List<M> findByFilter(QueryParameter<E, ID> queryParameter, JpaService<E, ID> jpaService, Class<E> entityClass, Class<M> modelClass) throws Exception {
        List entities = null;
        entities = this.apiQuery == null || StringUtils.isBlank((CharSequence)this.apiQuery.value()) ? jpaService.findByFilter(queryParameter) : jpaService.findByFilter(queryParameter, this.apiQuery.value());
        ArrayList<Object> models = new ArrayList<Object>();
        if (this.apiMapper == null) {
            throw new ApiFindException("The class to convert the entity to output is not declared");
        }
        try {
            Object mapper = this.applicationContext.getBean(this.apiMapper.value());
            Method mapperMethod = this.methodMapper(entityClass, modelClass);
            for (Object entity : entities) {
                models.add(mapperMethod.invoke(mapper, entity));
            }
        }
        catch (NoSuchMethodException e) {
            logger.error("Method mapper is not found");
            throw new ApiFindException("Method mapper is not found", e);
        }
        return models;
    }

    private <E, M, ID> M singleResultByFilter(QueryParameter<E, ID> queryParameter, JpaService<E, ID> jpaService, Class<E> entityClass, Class<M> modelClass) throws Exception {
        Object entity = null;
        entity = this.apiQuery == null || StringUtils.isBlank((CharSequence)this.apiQuery.value()) ? jpaService.singleResultByFilter(queryParameter) : jpaService.singleResultByFilter(queryParameter, this.apiQuery.value());
        Object model = null;
        if (entity != null) {
            if (this.apiMapper == null) {
                throw new ApiFindException("The class to convert the entity to output is not declared");
            }
            try {
                Object mapper = this.applicationContext.getBean(this.apiMapper.value());
                Method mapperMethod = this.methodMapper(entityClass, modelClass);
                model = mapperMethod.invoke(mapper, entity);
            }
            catch (NoSuchMethodException e) {
                logger.error("Method mapper is not found");
                throw new ApiFindException("Method mapper is not found", e);
            }
        }
        return (M)model;
    }

    private <P, O> Method methodMapper(Class<P> parameterClass, Class<O> outputClass) throws Exception {
        Class<?> bean = null;
        String methodName = null;
        bean = this.apiMapper.value();
        methodName = this.apiMapper.method();
        Method method = null;
        try {
            method = StringUtils.isBlank((CharSequence)methodName) ? this.findMethod(bean, parameterClass, outputClass) : bean.getMethod(methodName, parameterClass);
        }
        catch (NoSuchMethodException e) {
            logger.error("Method mapper is not found");
            throw new ApiFindException("Method mapper is not found", e);
        }
        return method;
    }

    private <M, P, O> Method findMethod(Class<M> mapperClass, Class<P> parameterClass, Class<O> outputClass) {
        Method methodFound = null;
        Method methodAssignInputFound = null;
        int countMethodFound = 0;
        int countAssignMethodFound = 0;
        Set methods = ReflectionCommons.methods(mapperClass);
        for (Method method : methods) {
            if (method.getParameterCount() != 1 || !method.getReturnType().equals(outputClass)) continue;
            if (method.getParameterTypes()[0].equals(parameterClass)) {
                methodFound = method;
                ++countMethodFound;
                continue;
            }
            if (!method.getParameterTypes()[0].isAssignableFrom(parameterClass)) continue;
            methodAssignInputFound = method;
            ++countAssignMethodFound;
        }
        if (countMethodFound == 1) {
            return methodFound;
        }
        if (countAssignMethodFound == 1) {
            return methodAssignInputFound;
        }
        if (countMethodFound > 1 || countAssignMethodFound > 1) {
            throw new ApiFindException("More compatible methods were found in the mapping class, use @ApiMethodMapper or @ApiMapper to select the method name");
        }
        throw new ApiFindException("Method mapper is not found");
    }
}

