/*
 * Decompiled with CFR 0.152.
 */
package com.intercognition.mailcheck;

import com.intercognition.mailcheck.EmailAddress;
import org.junit.Assert;
import org.junit.Test;

public class EmailAddressTest {
    @Test
    public void correctlySplitsNormalDomainIntoComponents() {
        EmailAddress emailAddress = new EmailAddress("test@example.com");
        this.assertSplitCorrect(emailAddress, "test", "example.com", "com");
    }

    @Test
    public void correctlySplitsDomainWithTwoTldPartsIntoComponents() {
        EmailAddress emailAddress = new EmailAddress("test@example.co.uk");
        this.assertSplitCorrect(emailAddress, "test", "example.co.uk", "co.uk");
    }

    @Test
    public void correctlySplitsDomainWithSubdomainIntoComponents() {
        EmailAddress emailAddress = new EmailAddress("test@mail.randomsmallcompany.co.uk");
        this.assertSplitCorrect(emailAddress, "test", "mail.randomsmallcompany.co.uk", "randomsmallcompany.co.uk");
    }

    @Test
    public void splitDealsWithQuotes() {
        EmailAddress emailAddress = new EmailAddress("\"foo@bar\"@example.com");
        this.assertSplitCorrect(emailAddress, "\"foo@bar\"", "example.com", "com");
    }

    @Test
    public void splitDealsWithNumbers() {
        EmailAddress emailAddress = new EmailAddress("containsnumbers1234567890@example.com");
        this.assertSplitCorrect(emailAddress, "containsnumbers1234567890", "example.com", "com");
    }

    @Test
    public void splitDealsWithSymbolPlusSign() {
        EmailAddress emailAddress = new EmailAddress("contains+symbol@example.com");
        this.assertSplitCorrect(emailAddress, "contains+symbol", "example.com", "com");
    }

    @Test
    public void splitDealsWithSymbolMinusSign() {
        EmailAddress emailAddress = new EmailAddress("contains-symbol@example.com");
        this.assertSplitCorrect(emailAddress, "contains-symbol", "example.com", "com");
    }

    @Test
    public void splitDealsWithPeriodSymbolInAddressAndDomain() {
        EmailAddress emailAddress = new EmailAddress("contains.symbol@domain.contains.symbol");
        this.assertSplitCorrect(emailAddress, "contains.symbol", "domain.contains.symbol", "contains.symbol");
    }

    @Test
    public void splitDealsWithSpacesAndInvertedCommas() {
        EmailAddress emailAddress = new EmailAddress("\"contains.and\\ symbols\"@example.com");
        this.assertSplitCorrect(emailAddress, "\"contains.and\\ symbols\"", "example.com", "com");
    }

    @Test
    public void splitDealsWithPeriodAtSymbolAndInvertedCommas() {
        EmailAddress emailAddress = new EmailAddress("\"contains.and.@.symbols.com\"@example.com");
        this.assertSplitCorrect(emailAddress, "\"contains.and.@.symbols.com\"", "example.com", "com");
    }

    @Test
    public void splitDealsWithAllTheSymbols() {
        EmailAddress emailAddress = new EmailAddress("\"()<>[]:;@,\\\\\\\"!#$%&\\'*+-/=?^_`{}|\\ \\ \\ \\ \\ ~\\ \\ \\ \\ \\ \\ \\ ?\\ \\ \\ \\ \\ \\ \\ \\ \\ \\ \\ \\ ^_`{}|~.a\"@allthesymbols.com");
        this.assertSplitCorrect(emailAddress, "\"()<>[]:;@,\\\\\\\"!#$%&\\'*+-/=?^_`{}|\\ \\ \\ \\ \\ ~\\ \\ \\ \\ \\ \\ \\ ?\\ \\ \\ \\ \\ \\ \\ \\ \\ \\ \\ \\ ^_`{}|~.a\"", "allthesymbols.com", "com");
    }

    @Test
    public void splitDealsWithJustTld() {
        EmailAddress emailAddress = new EmailAddress("postbox@com");
        this.assertSplitCorrect(emailAddress, "postbox", "com", "com");
    }

    @Test
    public void withoutUserEmailAddressIsInvalid() {
        Assert.assertFalse((boolean)new EmailAddress("example.com").isValid());
    }

    @Test
    public void withoutUserEmailAddressWithSubdomainIsInvalid() {
        Assert.assertFalse((boolean)new EmailAddress("abc.example.com").isValid());
    }

    @Test
    public void withoutUserEmailAddressBeginningWithAtSymbolIsInvalid() {
        Assert.assertFalse((boolean)new EmailAddress("@example.com").isValid());
    }

    @Test
    public void withoutDomainUserThenAtSymbolIsInvalid() {
        Assert.assertFalse((boolean)new EmailAddress("test@").isValid());
    }

    private void assertSplitCorrect(EmailAddress split, String address, String domain, String tld) {
        Assert.assertEquals((Object)address, (Object)split.getAddress());
        Assert.assertEquals((Object)domain, (Object)split.getDomain());
        Assert.assertEquals((Object)tld, (Object)split.getTLD());
    }
}

