/*
 * Decompiled with CFR 0.152.
 */
package com.intercognition.mailcheck;

import com.intercognition.mailcheck.EmailAddress;
import com.intercognition.mailcheck.MailCheck;
import com.intercognition.mailcheck.config.Configuration;
import com.intercognition.mailcheck.config.SimpleConfiguration;
import com.intercognition.mailcheck.stringdistance.DistanceAlgorithm;
import com.intercognition.mailcheck.stringdistance.Sift3;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MailCheckTest {
    private SimpleConfiguration configuration;
    private MailCheck mailCheck;

    @Before
    public void setUp() {
        this.configuration = new SimpleConfiguration(3, Arrays.asList("yahoo.com", "yahoo.com.tw", "google.com", "hotmail.com", "gmail.com", "emaildomain.com", "comcast.net", "facebook.com", "msn.com", "gmx.com"), Arrays.asList("co.uk", "com", "org", "info"), (DistanceAlgorithm)new Sift3(5));
        this.mailCheck = new MailCheck((Configuration)this.configuration);
    }

    @Test
    public void testSimpleSuggestion() {
        EmailAddress result = this.mailCheck.suggest("test@hotmail.co");
        Assert.assertEquals((Object)"test@hotmail.com", (Object)result.toString());
    }

    @Test
    public void testNoSuggestionGivenWhenDomainSeemsCorrect() {
        EmailAddress result = this.mailCheck.suggest("contact@kicksend.com");
        Assert.assertEquals(null, (Object)result);
    }

    @Test
    public void testSuggestions() {
        this.assertCorrection("test@emaildomain.co", "emaildomain.com");
        this.assertCorrection("test@gmail.con", "gmail.com");
        this.assertCorrection("test@gnail.con", "gmail.com");
        this.assertCorrection("test@GNAIL.con", "gmail.com");
        this.assertCorrection("test@#gmail.com", "gmail.com");
        this.assertCorrection("test@comcast.com", "comcast.net");
        this.assertCorrection("test@homail.con", "hotmail.com");
        this.assertCorrection("test@hotmail.co", "hotmail.com");
        this.assertCorrection("test@fabecook.com", "facebook.com");
        this.assertCorrection("test@yajoo.com", "yahoo.com");
        this.assertCorrection("test@randomsmallcompany.cmo", "randomsmallcompany.com");
    }

    @Test
    public void validOrCompletelyIncompleteDomainsHaveNoSuggestion() {
        Assert.assertNull((Object)this.mailCheck.suggest("test@yahoo.com.tw"));
        Assert.assertNull((Object)this.mailCheck.suggest(""));
        Assert.assertNull((Object)this.mailCheck.suggest("test@"));
        Assert.assertNull((Object)this.mailCheck.suggest("test"));
    }

    @Test
    public void noSuggestionForEmailAddressWithSubdomainAndMisspelledTld() {
        Assert.assertNull((Object)this.mailCheck.suggest("test@mail.randomsmallcompany.cmo"));
    }

    @Test
    public void findClosestStringWithNullCandidateGivesNull() {
        Assert.assertNull((Object)this.mailCheck.findClosestString(null, Arrays.asList("possible"), (DistanceAlgorithm)new Sift3(5), 3));
    }

    @Test
    public void findClosestStringWithEmptyCandidateGivesNull() {
        Assert.assertNull((Object)this.mailCheck.findClosestString("", Arrays.asList("possible"), (DistanceAlgorithm)new Sift3(5), 3));
    }

    @Test
    public void findClosestStringWithNullPossibleMatchesGivesNull() {
        Assert.assertNull((Object)this.mailCheck.findClosestString("candidate", null, (DistanceAlgorithm)new Sift3(5), 3));
    }

    @Test
    public void findClosestStringWithEmptyPossibleMatchesGivesNull() {
        Assert.assertNull((Object)this.mailCheck.findClosestString("candidate", (Collection)Collections.EMPTY_LIST, (DistanceAlgorithm)new Sift3(5), 3));
    }

    private void assertCorrection(String misspelled, String domain) {
        Assert.assertEquals((Object)domain, (Object)this.mailCheck.suggest(misspelled).getDomain());
    }
}

