/*
 * Decompiled with CFR 0.152.
 */
package com.intercognition.mailcheck.config;

import com.intercognition.mailcheck.config.Configuration;
import com.intercognition.mailcheck.config.DefaultConfiguration;
import com.intercognition.mailcheck.stringdistance.Sift3;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DefaultConfigurationTest {
    private Configuration configuration;

    @Before
    public void setUp() {
        this.configuration = new DefaultConfiguration();
    }

    @Test
    public void thresholdAccessor() {
        Assert.assertEquals((long)3L, (long)this.configuration.getThreshold());
    }

    @Test
    public void domainAccessor() {
        Assert.assertEquals(Arrays.asList("aol.com", "att.net", "comcast.net", "facebook.com", "gmail.com", "gmx.com", "google.com", "googlemail.com", "hotmail.co.uk", "hotmail.com", "mac.com", "mail.com", "me.com", "live.com", "msn.com", "sbcglobal.net", "verizon.net", "yahoo.co.uk", "yahoo.com"), (Object)this.configuration.getDomains());
    }

    @Test
    public void topLevelDomains() {
        Assert.assertEquals(Arrays.asList("co.uk", "com", "edu", "gov", "info", "mil", "net", "org"), (Object)this.configuration.getTopLevelDomains());
    }

    @Test
    public void distanceAlgorithm() {
        Assert.assertTrue((boolean)(this.configuration.getDistanceAlgorithm() instanceof Sift3));
    }
}

