/*
 * Decompiled with CFR 0.152.
 */
package com.intercognition.mailcheck.stringdistance;

import com.intercognition.mailcheck.stringdistance.DistanceAlgorithm;
import com.intercognition.mailcheck.stringdistance.Sift3;
import org.junit.Assert;
import org.junit.Test;

public class Sift3Test {
    DistanceAlgorithm sift3 = new Sift3(5);

    @Test
    public void distanceBetweenNullFirstStringAndSecondStringIsLengthOfSecondString() {
        Assert.assertEquals((double)6.0, (double)this.sift3.getDistance(null, "abcdef"), (double)0.0);
    }

    @Test
    public void distanceBetweenEmptyFirstStringAndSecondStringIsLengthOfSecondString() {
        Assert.assertEquals((double)6.0, (double)this.sift3.getDistance("", "abcdef"), (double)0.0);
    }

    @Test
    public void distanceBetweenFirstStringAndNullSecondStringIsLengthOfFirstString() {
        Assert.assertEquals((double)5.0, (double)this.sift3.getDistance("abcde", null), (double)0.0);
    }

    @Test
    public void distanceBetweenFirstStringAndEmptySecondStringIsLengthOfFirstString() {
        Assert.assertEquals((double)5.0, (double)this.sift3.getDistance("abcde", ""), (double)0.0);
    }

    @Test
    public void distanceBetweenIdenticalStringsIsZero() {
        Assert.assertEquals((double)0.0, (double)this.sift3.getDistance("abcdef", "abcdef"), (double)0.0);
    }

    @Test
    public void oneCharacterDifferenceBetweenStringsGivesDistanceOfOne() {
        Assert.assertEquals((double)1.0, (double)this.sift3.getDistance("abcdef", "abcdeZ"), (double)0.0);
    }

    @Test
    public void twoCharacterDifferenceBetweenStringsIs2() {
        Assert.assertEquals((double)2.0, (double)this.sift3.getDistance("abcdef", "ZbcdeZ"), (double)0.0);
    }

    @Test
    public void differenceFurtherThanMaximumOffsetBetweenStringsIsCountedAsDistance() {
        Assert.assertEquals((double)0.0, (double)this.sift3.getDistance("abcdef", "abcdefg"), (double)0.5);
    }

    @Test
    public void differenceCloserThanMaximumOffsetBetweenStringsGivesDistanceOfOne() {
        Assert.assertEquals((double)1.0, (double)this.sift3.getDistance("abc", "abZ"), (double)0.0);
    }

    @Test
    public void additionalCharacterWithinOffsetRangeIsCountedAsDistance() {
        Assert.assertEquals((double)0.0, (double)this.sift3.getDistance("abc", "abcd"), (double)0.5);
    }
}

