/*
 * Decompiled with CFR 0.152.
 */
package com.innovatrics.mrz;

import com.innovatrics.mrz.MrzNotFoundException;
import com.innovatrics.mrz.MrzParseException;
import com.innovatrics.mrz.types.MrzFormat;
import java.util.regex.Pattern;

public final class MrzFinderUtil {
    private static final Pattern MRZFIRSTLINE = Pattern.compile("[P|V|A|C|I][A-Z0-9<]([A-Z]{3}|D<<)[A-Z0-9<]{25,39}");
    private static final Pattern MRZCHARS = Pattern.compile("[A-Z0-9<]{30,44}");

    private MrzFinderUtil() {
    }

    public static String findMrz(String input) throws MrzNotFoundException, MrzParseException {
        if (input == null) {
            throw new MrzNotFoundException();
        }
        String mrz = MrzFinderUtil.extractMrz(input);
        if (mrz.isEmpty()) {
            throw new MrzNotFoundException();
        }
        MrzFormat.get(mrz);
        return mrz;
    }

    private static String extractMrz(String input) {
        String[] lines = input.split("\n");
        StringBuilder mrz = new StringBuilder();
        boolean found = false;
        for (String line : lines) {
            String test = line.trim();
            if (found) {
                if (!MRZCHARS.matcher(test).matches()) break;
                mrz.append("\n");
                mrz.append(test);
                continue;
            }
            if (!MRZFIRSTLINE.matcher(test).matches()) continue;
            found = true;
            mrz.append(line);
        }
        return mrz.toString();
    }
}

