/*
 * Decompiled with CFR 0.152.
 */
package com.innovatrics.mrz;

import com.innovatrics.mrz.MrzParseException;
import com.innovatrics.mrz.MrzParser;
import com.innovatrics.mrz.MrzRange;
import com.innovatrics.mrz.types.MrzDate;
import com.innovatrics.mrz.types.MrzDocumentCode;
import com.innovatrics.mrz.types.MrzFormat;
import com.innovatrics.mrz.types.MrzSex;
import java.io.Serializable;

public abstract class MrzRecord
implements Serializable {
    private final MrzFormat format;
    private final String recordName;
    private MrzDocumentCode code;
    private char code1;
    private char code2;
    private String issuingCountry;
    private String documentNumber;
    private String surname;
    private String givenNames;
    private MrzDate dateOfBirth;
    private MrzSex sex;
    private MrzDate expirationDate;
    private String nationality;
    private boolean validDocumentNumber = true;
    private boolean validDateOfBirth = true;
    private boolean validExpirationDate = true;
    private boolean validComposite = true;

    protected MrzRecord(MrzFormat format, String recordName) {
        this.format = format;
        this.recordName = recordName;
    }

    public final MrzFormat getFormat() {
        return this.format;
    }

    public final String getRecordName() {
        return this.recordName;
    }

    public void fromMrz(String mrz) throws MrzParseException {
        if (this.getFormat() != MrzFormat.get(mrz)) {
            throw new MrzParseException("Invalid format: " + (Object)((Object)MrzFormat.get(mrz)), mrz, new MrzRange(0, 0, 0), this.getFormat());
        }
        this.setCode(MrzDocumentCode.parse(mrz));
        this.setCode1(mrz.charAt(0));
        this.setCode2(mrz.charAt(1));
        this.setIssuingCountry(new MrzParser(mrz).parseString(new MrzRange(2, 5, 0)));
    }

    protected final void setName(String[] name) {
        this.setSurname(name[0]);
        this.setGivenNames(name[1]);
    }

    public abstract String toMrz();

    public MrzDocumentCode getCode() {
        return this.code;
    }

    public void setCode(MrzDocumentCode code) {
        this.code = code;
    }

    public char getCode1() {
        return this.code1;
    }

    public void setCode1(char code1) {
        this.code1 = code1;
    }

    public char getCode2() {
        return this.code2;
    }

    public void setCode2(char code2) {
        this.code2 = code2;
    }

    public String getIssuingCountry() {
        return this.issuingCountry;
    }

    public void setIssuingCountry(String issuingCountry) {
        this.issuingCountry = issuingCountry;
    }

    public String getDocumentNumber() {
        return this.documentNumber;
    }

    public void setDocumentNumber(String documentNumber) {
        this.documentNumber = documentNumber;
    }

    public String getSurname() {
        return this.surname;
    }

    public void setSurname(String surname) {
        this.surname = surname;
    }

    public String getGivenNames() {
        return this.givenNames;
    }

    public void setGivenNames(String givenNames) {
        this.givenNames = givenNames;
    }

    public MrzDate getDateOfBirth() {
        return this.dateOfBirth;
    }

    public void setDateOfBirth(MrzDate dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }

    public MrzSex getSex() {
        return this.sex;
    }

    public void setSex(MrzSex sex) {
        this.sex = sex;
    }

    public MrzDate getExpirationDate() {
        return this.expirationDate;
    }

    public void setExpirationDate(MrzDate expirationDate) {
        this.expirationDate = expirationDate;
    }

    public String getNationality() {
        return this.nationality;
    }

    public void setNationality(String nationality) {
        this.nationality = nationality;
    }

    public boolean isValidDocumentNumber() {
        return this.validDocumentNumber;
    }

    protected void setValidDocumentNumber(boolean validDocumentNumber) {
        this.validDocumentNumber = validDocumentNumber;
    }

    public boolean isValidDateOfBirth() {
        return this.validDateOfBirth;
    }

    protected void setValidDateOfBirth(boolean validDateOfBirth) {
        this.validDateOfBirth = validDateOfBirth;
    }

    public boolean isValidExpirationDate() {
        return this.validExpirationDate;
    }

    protected void setValidExpirationDate(boolean validExpirationDate) {
        this.validExpirationDate = validExpirationDate;
    }

    public boolean isValidComposite() {
        return this.validComposite;
    }

    protected void setValidComposite(boolean validComposite) {
        this.validComposite = validComposite;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getRecordName());
        sb.append("{");
        this.buildToString(sb);
        sb.append("}");
        return sb.toString();
    }

    protected void buildToString(StringBuilder sb) {
        sb.append("code=").append((Object)this.getCode());
        sb.append('[').append(this.getCode1()).append(this.getCode2()).append(']');
        sb.append(", issuingCountry=").append(this.getIssuingCountry());
        sb.append(", documentNumber=").append(this.getDocumentNumber());
        sb.append(", surname=").append(this.getSurname());
        sb.append(", givenNames=").append(this.getGivenNames());
        sb.append(", dateOfBirth=").append(this.getDateOfBirth());
        sb.append(", sex=").append((Object)this.getSex());
        sb.append(", expirationDate=").append(this.getExpirationDate());
        sb.append(", nationality=").append(this.getNationality());
    }
}

