/*
 * Decompiled with CFR 0.152.
 */
package com.innovatrics.mrz.types;

import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MrzDate
implements Serializable,
Comparable<MrzDate> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(MrzDate.class);
    private final int year;
    private final int month;
    private final int day;
    private final String mrz;
    private final boolean dateValid;

    public MrzDate(int year, int month, int day) {
        this.year = year;
        this.month = month;
        this.day = day;
        this.dateValid = this.check();
        this.mrz = null;
    }

    public MrzDate(int year, int month, int day, String raw) {
        this.year = year;
        this.month = month;
        this.day = day;
        this.dateValid = this.check();
        this.mrz = raw;
    }

    public final int getYear() {
        return this.year;
    }

    public final int getMonth() {
        return this.month;
    }

    public final int getDay() {
        return this.day;
    }

    public final String getMrz() {
        return this.mrz;
    }

    public final boolean isDateValid() {
        return this.dateValid;
    }

    public String toMrz() {
        if (this.getMrz() != null) {
            return this.getMrz();
        }
        return String.format("%02d%02d%02d", this.getYear(), this.getMonth(), this.getDay());
    }

    private boolean check() {
        if (this.getYear() < 0 || this.getYear() > 99) {
            LOG.debug("Parameter year: invalid value " + this.getYear() + ": must be 0..99");
            return false;
        }
        if (this.getMonth() < 1 || this.getMonth() > 12) {
            LOG.debug("Parameter month: invalid value " + this.getMonth() + ": must be 1..12");
            return false;
        }
        if (this.getDay() < 1 || this.getDay() > 31) {
            LOG.debug("Parameter day: invalid value " + this.getDay() + ": must be 1..31");
            return false;
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MrzDate other = (MrzDate)obj;
        if (this.getYear() != other.getYear()) {
            return false;
        }
        if (this.getMonth() != other.getMonth()) {
            return false;
        }
        return this.getDay() == other.getDay();
    }

    public int hashCode() {
        int hash = 7;
        hash = 11 * hash + this.getYear();
        hash = 11 * hash + this.getMonth();
        hash = 11 * hash + this.getDay();
        return hash;
    }

    @Override
    public int compareTo(MrzDate o) {
        return Integer.valueOf(this.getYear() * 10000 + this.getMonth() * 100 + this.getDay()).compareTo(o.getYear() * 10000 + o.getMonth() * 100 + o.getDay());
    }

    public String toString() {
        return "{" + this.getDay() + "/" + this.getMonth() + "/" + this.getYear() + '}';
    }
}

