/*
 * Decompiled with CFR 0.152.
 */
package com.innovatrics.mrz.types;

import com.innovatrics.mrz.MrzParseException;
import com.innovatrics.mrz.MrzRange;

public enum MrzDocumentCode {
    PASSPORT,
    TYPE_I,
    TYPE_A,
    CREW_MEMBER,
    TYPE_C,
    TYPE_V,
    MIGRANT;


    public static MrzDocumentCode parse(String mrz) throws MrzParseException {
        String code;
        switch (code = mrz.substring(0, 2)) {
            case "IV": {
                throw new MrzParseException("IV document code is not allowed", mrz, new MrzRange(0, 2, 0), null);
            }
            case "AC": {
                return CREW_MEMBER;
            }
            case "ME": {
                return MIGRANT;
            }
            case "TD": {
                return MIGRANT;
            }
            case "IP": {
                return PASSPORT;
            }
        }
        switch (code.charAt(0)) {
            case 'P': 
            case 'T': {
                return PASSPORT;
            }
            case 'A': {
                return TYPE_A;
            }
            case 'C': {
                return TYPE_C;
            }
            case 'V': {
                return TYPE_V;
            }
            case 'I': {
                return TYPE_I;
            }
            case 'R': {
                return MIGRANT;
            }
        }
        throw new MrzParseException("Unsupported document code: " + code, mrz, new MrzRange(0, 2, 0), null);
    }
}

