/*
 * Decompiled with CFR 0.152.
 */
package com.innovatrics.mrz;

import com.innovatrics.mrz.MrzParseException;
import com.innovatrics.mrz.MrzParser;
import com.innovatrics.mrz.MrzRange;
import com.innovatrics.mrz.MrzRecord;
import java.awt.Component;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;

public class Demo {
    private static int toPos(int col, int row, String text) {
        int currentRow = 0;
        int currentCol = 0;
        for (int pos = 0; text.length() > pos; ++pos) {
            if (row == currentRow && currentCol == col) {
                return pos;
            }
            if (text.charAt(pos) == '\n') {
                ++currentRow;
                currentCol = 0;
                continue;
            }
            ++currentCol;
        }
        return -1;
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("MRZDemo");
        frame.setDefaultCloseOperation(3);
        JTextArea mrz = new JTextArea(5, 44);
        JButton parse = new JButton("Parse");
        parse.addActionListener(event -> {
            String m = mrz.getText();
            try {
                MrzRecord record = MrzParser.parse(m);
                JOptionPane.showMessageDialog(frame, "Parse successfull: " + record);
            }
            catch (MrzParseException ex) {
                JOptionPane.showMessageDialog(frame, "Parse failed: " + ex);
                MrzRange r = ex.getRange();
                mrz.select(Demo.toPos(r.getColumn(), r.getRow(), m), Demo.toPos(r.getColumnTo(), r.getRow(), m));
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(frame, "Parse failed: " + ex);
            }
        });
        frame.getContentPane().add((Component)mrz, "Center");
        frame.getContentPane().add((Component)parse, "South");
        frame.pack();
        frame.setVisible(true);
    }
}

