/*
 * Decompiled with CFR 0.152.
 */
package com.github.bordertech.taskmaster.servlet.combo;

import com.github.bordertech.taskmaster.servlet.combo.AbstractComboFilter;
import com.github.bordertech.taskmaster.servlet.combo.ComboFilterChain;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;

public class AbstractComboFilterTest {
    @Rule
    public MockitoRule initRule = MockitoJUnit.rule();

    @Test(expected=IllegalArgumentException.class)
    public void testConstructor1NullFilter() {
        new AbstractComboFilter(null, new Filter[0]){};
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConstructor1NullArrayEntry() {
        Filter testFilter = (Filter)Mockito.mock(Filter.class);
        new AbstractComboFilter(testFilter, new Filter[]{null}){};
    }

    @Test
    public void testConstructor1SingleFilter() {
        Filter testFilter = (Filter)Mockito.mock(Filter.class);
        AbstractComboFilter filter = new AbstractComboFilter(testFilter, new Filter[0]){};
        Assert.assertEquals((String)"Backing filters should contain one entry", (long)1L, (long)filter.getFilters().size());
        Assert.assertSame((String)"Backing filters should contain single filter", (Object)testFilter, filter.getFilters().get(0));
    }

    @Test
    public void testConstructor1MultiFilters() {
        Filter testFilter1 = (Filter)Mockito.mock(Filter.class);
        Filter testFilter2 = (Filter)Mockito.mock(Filter.class);
        Filter testFilter3 = (Filter)Mockito.mock(Filter.class);
        AbstractComboFilter filter = new AbstractComboFilter(testFilter1, new Filter[]{testFilter2, testFilter3}){};
        Assert.assertEquals((String)"Backing filters should contain three entries", (long)3L, (long)filter.getFilters().size());
        Assert.assertSame((String)"Backing filters should contain first filter", (Object)testFilter1, filter.getFilters().get(0));
        Assert.assertSame((String)"Backing filters should contain second filter", (Object)testFilter2, filter.getFilters().get(1));
        Assert.assertSame((String)"Backing filters should contain third filter", (Object)testFilter3, filter.getFilters().get(2));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConstructor2NullList() {
        new AbstractComboFilter(null){};
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConstructor2EmptyList() {
        new AbstractComboFilter(new ArrayList()){};
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConstructor2NullEntry() {
        new AbstractComboFilter(Arrays.asList(new Filter[]{null})){};
    }

    @Test
    public void testConstructor2MultiFilters() {
        Filter testFilter1 = (Filter)Mockito.mock(Filter.class);
        Filter testFilter2 = (Filter)Mockito.mock(Filter.class);
        Filter testFilter3 = (Filter)Mockito.mock(Filter.class);
        List<Filter> testFilters = Arrays.asList(testFilter1, testFilter2, testFilter3);
        AbstractComboFilter filter = new AbstractComboFilter(testFilters){};
        Assert.assertEquals((String)"Backing filters should match test filters", testFilters, (Object)filter.getFilters());
    }

    @Test
    public void testInitFilter() throws ServletException {
        FilterConfig config = (FilterConfig)Mockito.mock(FilterConfig.class);
        Filter testFilter1 = (Filter)Mockito.mock(Filter.class);
        Filter testFilter2 = (Filter)Mockito.mock(Filter.class);
        AbstractComboFilter filter = new AbstractComboFilter(testFilter1, new Filter[]{testFilter2}){};
        filter.init(config);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{testFilter1, testFilter2});
        ((Filter)inOrder.verify((Object)testFilter1)).init(config);
        ((Filter)inOrder.verify((Object)testFilter2)).init(config);
    }

    @Test
    public void testDestroyFilter() {
        Filter testFilter1 = (Filter)Mockito.mock(Filter.class);
        Filter testFilter2 = (Filter)Mockito.mock(Filter.class);
        AbstractComboFilter filter = new AbstractComboFilter(testFilter1, new Filter[]{testFilter2}){};
        filter.destroy();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{testFilter2, testFilter1});
        ((Filter)inOrder.verify((Object)testFilter2)).destroy();
        ((Filter)inOrder.verify((Object)testFilter1)).destroy();
    }

    @Test
    public void testDoFilter() throws IOException, ServletException {
        ServletRequest request = (ServletRequest)Mockito.mock(ServletRequest.class);
        ServletResponse response = (ServletResponse)Mockito.mock(ServletResponse.class);
        FilterChain chain = (FilterChain)Mockito.mock(FilterChain.class);
        Filter testFilter1 = (Filter)Mockito.mock(MyFilter.class);
        Filter testFilter2 = (Filter)Mockito.mock(MyFilter.class);
        ((Filter)Mockito.doCallRealMethod().when((Object)testFilter1)).doFilter((ServletRequest)Mockito.any(), (ServletResponse)Mockito.any(), (FilterChain)Mockito.any(ComboFilterChain.class));
        ((Filter)Mockito.doCallRealMethod().when((Object)testFilter2)).doFilter((ServletRequest)Mockito.any(), (ServletResponse)Mockito.any(), (FilterChain)Mockito.any(ComboFilterChain.class));
        AbstractComboFilter filter = new AbstractComboFilter(testFilter1, new Filter[]{testFilter2}){};
        filter.doFilter(request, response, chain);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{testFilter1, testFilter2, chain});
        ((Filter)inOrder.verify((Object)testFilter1)).doFilter((ServletRequest)Mockito.eq((Object)request), (ServletResponse)Mockito.eq((Object)response), (FilterChain)Mockito.any(ComboFilterChain.class));
        ((Filter)inOrder.verify((Object)testFilter2)).doFilter((ServletRequest)Mockito.eq((Object)request), (ServletResponse)Mockito.eq((Object)response), (FilterChain)Mockito.any(ComboFilterChain.class));
        ((FilterChain)inOrder.verify((Object)chain)).doFilter(request, response);
    }

    private static class MyFilter
    implements Filter {
        private MyFilter() {
        }

        public void init(FilterConfig filterConfig) throws ServletException {
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            chain.doFilter(request, response);
        }

        public void destroy() {
        }
    }
}

