/*
 * Decompiled with CFR 0.152.
 */
package com.github.bordertech.taskmaster.servlet.combo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractComboServletListener
implements ServletContextListener {
    private static final Log LOGGER = LogFactory.getLog(AbstractComboServletListener.class);
    private final List<ServletContextListener> listeners;

    protected AbstractComboServletListener(ServletContextListener listener, ServletContextListener ... listeners) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener cannot be null");
        }
        boolean hasNull = Arrays.stream(listeners).anyMatch(Objects::isNull);
        if (hasNull) {
            throw new IllegalArgumentException("Listeners cannot contain a null listener");
        }
        ArrayList<ServletContextListener> backing = new ArrayList<ServletContextListener>();
        backing.add(listener);
        backing.addAll(Arrays.asList(listeners));
        this.listeners = Collections.unmodifiableList(backing);
    }

    protected AbstractComboServletListener(List<ServletContextListener> listeners) {
        if (listeners == null || listeners.isEmpty()) {
            throw new IllegalArgumentException("List of listeners cannot be null or empty");
        }
        boolean hasNull = listeners.stream().anyMatch(Objects::isNull);
        if (hasNull) {
            throw new IllegalArgumentException("Listeners list cannot contain a null listener");
        }
        this.listeners = Collections.unmodifiableList(listeners);
    }

    public final List<ServletContextListener> getListeners() {
        return this.listeners;
    }

    public void contextInitialized(ServletContextEvent sce) {
        for (ServletContextListener listener : this.getListeners()) {
            try {
                listener.contextInitialized(sce);
            }
            catch (Exception e) {
                LOGGER.error((Object)("Error calling initialized servlet context listener [" + listener.getClass().getName() + "]. " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        for (ServletContextListener listener : this.getListeners()) {
            try {
                listener.contextDestroyed(sce);
            }
            catch (Exception e) {
                LOGGER.error((Object)("Error calling destroyed servlet context listener [" + listener.getClass().getName() + "]. " + e.getMessage()), (Throwable)e);
            }
        }
    }
}

