/*
 * Decompiled with CFR 0.152.
 */
package com.github.braisdom.objsql;

import com.github.braisdom.objsql.AbstractPersistence;
import com.github.braisdom.objsql.Databases;
import com.github.braisdom.objsql.DomainModelDescriptor;
import com.github.braisdom.objsql.PersistenceException;
import com.github.braisdom.objsql.Quoter;
import com.github.braisdom.objsql.Tables;
import com.github.braisdom.objsql.annotations.PrimaryKey;
import com.github.braisdom.objsql.reflection.PropertyUtils;
import com.github.braisdom.objsql.transition.ColumnTransitional;
import com.github.braisdom.objsql.util.ArrayUtil;
import com.github.braisdom.objsql.util.FunctionWithThrowable;
import com.github.braisdom.objsql.util.StringUtil;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Objects;

public class DefaultPersistence<T>
extends AbstractPersistence<T> {
    public DefaultPersistence(Class<T> domainClass) {
        super(domainClass);
    }

    public DefaultPersistence(DomainModelDescriptor domainModelDescriptor) {
        super(domainModelDescriptor);
    }

    @Override
    public void save(T dirtyObject, boolean skipValidation) throws SQLException {
        Objects.requireNonNull(dirtyObject, "The dirtyObject cannot be null");
        Object primaryValue = this.domainModelDescriptor.getPrimaryValue(dirtyObject);
        if (primaryValue == null) {
            this.insert(dirtyObject, skipValidation);
        } else {
            this.update(primaryValue, dirtyObject, skipValidation);
        }
    }

    @Override
    public T insert(T dirtyObject, boolean skipValidation) throws SQLException {
        Objects.requireNonNull(dirtyObject, "The dirtyObject cannot be null");
        if (!skipValidation) {
            Tables.validate(dirtyObject);
        }
        return (T)Databases.execute((connection, sqlExecutor) -> {
            String[] columnNames = this.domainModelDescriptor.getInsertableColumns();
            String tableName = this.domainModelDescriptor.getTableName();
            String sql = this.formatInsertSql(tableName, columnNames);
            Object[] values = Arrays.stream(columnNames).map(FunctionWithThrowable.castFunctionWithThrowable(columnName -> {
                String fieldName = this.domainModelDescriptor.getFieldName((String)columnName);
                ColumnTransitional columnTransitional = this.domainModelDescriptor.getColumnTransition(fieldName);
                if (columnTransitional != null) {
                    return columnTransitional.sinking(connection.getMetaData(), dirtyObject, this.domainModelDescriptor, fieldName, PropertyUtils.readDirectly(dirtyObject, fieldName));
                }
                return PropertyUtils.readDirectly(dirtyObject, fieldName);
            })).toArray(Object[]::new);
            return sqlExecutor.insert(connection, sql, this.domainModelDescriptor, values);
        });
    }

    @Override
    public int[] insert(T[] dirtyObjects, boolean skipValidation) throws SQLException {
        Objects.requireNonNull(dirtyObjects, "The dirtyObject cannot be null");
        if (!skipValidation) {
            Tables.validate(dirtyObjects);
        }
        return Databases.execute((connection, sqlExecutor) -> {
            String[] columnNames = this.domainModelDescriptor.getInsertableColumns();
            Object[][] values = new Object[dirtyObjects.length][columnNames.length];
            for (int i = 0; i < dirtyObjects.length; ++i) {
                for (int t = 0; t < columnNames.length; ++t) {
                    String fieldName = this.domainModelDescriptor.getFieldName(columnNames[t]);
                    ColumnTransitional columnTransitional = this.domainModelDescriptor.getColumnTransition(fieldName);
                    values[i][t] = columnTransitional != null ? columnTransitional.sinking(connection.getMetaData(), dirtyObjects[i], this.domainModelDescriptor, fieldName, PropertyUtils.readDirectly(dirtyObjects[i], fieldName)) : PropertyUtils.readDirectly(dirtyObjects[i], fieldName);
                }
            }
            String tableName = this.domainModelDescriptor.getTableName();
            String sql = this.formatInsertSql(tableName, columnNames);
            return sqlExecutor.insert(connection, sql, this.domainModelDescriptor, values);
        });
    }

    @Override
    public int update(Object id, T dirtyObject, boolean skipValidation) throws SQLException {
        Objects.requireNonNull(id, "The id cannot be null");
        Objects.requireNonNull(dirtyObject, "The dirtyObject cannot be null");
        if (!skipValidation) {
            Tables.validate(dirtyObject);
        }
        PrimaryKey primaryKey = this.domainModelDescriptor.getPrimaryKey();
        this.ensurePrimaryKeyNotNull(primaryKey);
        return Databases.execute((connection, sqlExecutor) -> {
            String[] rawColumnNames = this.domainModelDescriptor.getUpdatableColumns();
            String[] columnNames = (String[])Arrays.stream(rawColumnNames).filter(rawColumnName -> {
                if (this.domainModelDescriptor.skipNullOnUpdate()) {
                    String fieldName = this.domainModelDescriptor.getFieldName((String)rawColumnName);
                    return PropertyUtils.readDirectly(dirtyObject, fieldName) != null;
                }
                return true;
            }).toArray(String[]::new);
            A[] values = Arrays.stream(columnNames).map(FunctionWithThrowable.castFunctionWithThrowable(columnName -> {
                String fieldName = this.domainModelDescriptor.getFieldName((String)columnName);
                ColumnTransitional columnTransitional = this.domainModelDescriptor.getColumnTransition(fieldName);
                if (columnTransitional != null) {
                    return columnTransitional.sinking(connection.getMetaData(), dirtyObject, this.domainModelDescriptor, fieldName, PropertyUtils.readDirectly(dirtyObject, fieldName));
                }
                return PropertyUtils.readDirectly(dirtyObject, fieldName);
            })).toArray(Object[]::new);
            StringBuilder updatesSql = new StringBuilder();
            Arrays.stream(columnNames).forEach(columnName -> updatesSql.append((String)columnName).append("=").append("?").append(","));
            this.ensureNotBlank(updatesSql.toString(), "updates");
            updatesSql.delete(updatesSql.length() - 1, updatesSql.length());
            String sql = this.formatUpdateSql(this.domainModelDescriptor.getTableName(), updatesSql.toString(), String.format("%s = ?", primaryKey.name()));
            return sqlExecutor.execute(connection, sql, ArrayUtil.appendElement(Object.class, values, id));
        });
    }

    @Override
    public int update(String updates, String predication) throws SQLException {
        Objects.requireNonNull(updates, "The updates cannot be null");
        Objects.requireNonNull(predication, "The predication cannot be null");
        this.ensureNotBlank(updates, "updates");
        this.ensureNotBlank(updates, "predication");
        return Databases.execute((connection, sqlExecutor) -> {
            String sql = this.formatUpdateSql(this.domainModelDescriptor.getTableName(), updates, predication);
            return sqlExecutor.execute(connection, sql, new Object[0]);
        });
    }

    @Override
    public int delete(String predication) throws SQLException {
        Objects.requireNonNull(predication, "The criteria cannot be null");
        this.ensureNotBlank(predication, "predication");
        return Databases.execute((connection, sqlExecutor) -> {
            String sql = this.formatDeleteSql(this.domainModelDescriptor.getTableName(), predication);
            return sqlExecutor.execute(connection, sql, new Object[0]);
        });
    }

    @Override
    public int delete(Object id) throws SQLException {
        Objects.requireNonNull(id, "The id cannot be null");
        PrimaryKey primaryKey = this.domainModelDescriptor.getPrimaryKey();
        this.ensurePrimaryKeyNotNull(primaryKey);
        return Databases.execute((connection, sqlExecutor) -> {
            Quoter quoter = Databases.getQuoter();
            String sql = this.formatDeleteSql(this.domainModelDescriptor.getTableName(), String.format("%s = %s", quoter.quoteColumn(primaryKey.name()), quoter.quoteValue(id)));
            return sqlExecutor.execute(connection, sql, new Object[0]);
        });
    }

    @Override
    public int execute(String sql) throws SQLException {
        Objects.requireNonNull(sql, "The sql cannot be null");
        return Databases.execute((connection, sqlExecutor) -> sqlExecutor.execute(connection, sql, new Object[0]));
    }

    private void ensurePrimaryKeyNotNull(PrimaryKey primaryKey) throws PersistenceException {
        if (primaryKey == null) {
            throw new PersistenceException(String.format("The %s has no primary key", this.domainModelDescriptor.getTableName()));
        }
    }

    private void ensureNotBlank(String string, String name) throws PersistenceException {
        if (StringUtil.isBlank(string)) {
            throw new PersistenceException(String.format("Empty %s for %s ", name, this.domainModelDescriptor.getTableName()));
        }
    }
}

