/*
 * Decompiled with CFR 0.152.
 */
package com.github.braisdom.objsql.apt;

import com.github.braisdom.objsql.apt.MethodBuilder;
import com.github.braisdom.objsql.apt.StatementBuilder;
import com.github.braisdom.objsql.apt.Utils;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import java.util.ArrayList;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;

public final class APTBuilder {
    private final JCTree.JCClassDecl classDecl;
    private final Element element;
    private final JCTree ast;
    private final TreeMaker treeMaker;
    private final Names names;
    private final Messager messager;

    public APTBuilder(JCTree.JCClassDecl classDecl, Element element, JCTree ast, TreeMaker treeMaker, Names names, Messager messager) {
        this.classDecl = classDecl;
        this.element = element;
        this.ast = ast;
        this.treeMaker = treeMaker;
        this.names = names;
        this.messager = messager;
    }

    public MethodBuilder createMethodBuilder() {
        return new MethodBuilder(this);
    }

    public StatementBuilder createStatementBuilder() {
        return new StatementBuilder(this);
    }

    public JCTree get() {
        return this.ast;
    }

    public String getClassName() {
        return this.classDecl.name.toString();
    }

    public TreeMaker getTreeMaker() {
        return this.treeMaker;
    }

    public ElementKind getKind() {
        return this.element.getKind();
    }

    public Name toName(String name) {
        return this.names.fromString(name);
    }

    public JCTree.JCExpression typeRef(Class clazz) {
        String className = clazz.getName().replace("$", ".");
        return this.typeRef(className);
    }

    public void inject(JCTree.JCVariableDecl variableDecl) {
        this.classDecl.defs = this.classDecl.defs.append(variableDecl);
    }

    public void inject(JCTree.JCClassDecl classDecl) {
        this.classDecl.defs = this.classDecl.defs.append(classDecl);
    }

    public void inject(JCTree.JCMethodDecl methodDecl) {
        if (!Utils.containsMethod(this.classDecl.sym, methodDecl, false)) {
            this.classDecl.defs = this.classDecl.defs.append(methodDecl);
        }
    }

    public void injectForce(JCTree.JCMethodDecl methodDecl) {
        this.classDecl.defs = this.classDecl.defs.append(methodDecl);
    }

    public JCTree.JCExpression typeRef(String complexName) {
        String[] parts = complexName.split("\\.");
        if (parts.length > 2 && parts[0].equals("java") && parts[1].equals("lang")) {
            String[] subParts = new String[parts.length - 2];
            System.arraycopy(parts, 2, subParts, 0, subParts.length);
            return this.javaLangTypeRef(subParts);
        }
        return this.chainDots(parts);
    }

    public JCTree.JCExpression javaLangTypeRef(String ... simpleNames) {
        return this.chainDots((String)null, (String)null, simpleNames);
    }

    public JCTree.JCExpression chainDots(String elem1, String elem2, String ... elems) {
        return this.chainDots(-1, elem1, elem2, elems);
    }

    public JCTree.JCExpression chainDots(String ... elems) {
        assert (elems != null);
        JCTree.JCExpression e = null;
        for (String elem : elems) {
            e = e == null ? this.treeMaker.Ident(this.toName(elem)) : this.treeMaker.Select(e, this.toName(elem));
        }
        return e;
    }

    public JCTree.JCExpression chainDots(int pos, String elem1, String elem2, String ... elems) {
        assert (elems != null);
        TreeMaker treeMaker = this.getTreeMaker();
        if (pos != -1) {
            treeMaker = treeMaker.at(pos);
        }
        JCTree.JCIdent e = null;
        if (elem1 != null) {
            e = treeMaker.Ident(this.toName(elem1));
        }
        if (elem2 != null) {
            e = e == null ? treeMaker.Ident(this.toName(elem2)) : treeMaker.Select((JCTree.JCExpression)e, this.toName(elem2));
        }
        for (int i = 0; i < elems.length; ++i) {
            e = e == null ? treeMaker.Ident(this.toName(elems[i])) : treeMaker.Select((JCTree.JCExpression)e, this.toName(elems[i]));
        }
        assert (e != null);
        return e;
    }

    public JCTree.JCClassDecl classDef(int modifiers, String name, Class clazz) {
        return this.treeMaker.ClassDef(this.treeMaker.Modifiers(modifiers), this.toName(name), List.nil(), this.typeRef(clazz), List.nil(), List.nil());
    }

    public JCTree.JCMethodDecl createConstructor(int modifiers, List<JCTree.JCVariableDecl> parameters, List<JCTree.JCStatement> statements) {
        return this.treeMaker.MethodDef(this.treeMaker.Modifiers(modifiers), this.names.init, null, List.nil(), parameters, List.nil(), this.treeMaker.Block(0L, statements), null);
    }

    public JCTree.JCExpression staticMethodCall(Class<?> clazz, String methodName, JCTree.JCExpression ... params) {
        return this.treeMaker.Apply(List.nil(), this.treeMaker.Select(this.typeRef(clazz.getName()), this.toName(methodName)), List.from(params));
    }

    public JCTree.JCMethodInvocation methodCall(String methodName, JCTree.JCExpression ... params) {
        return this.treeMaker.Apply(List.nil(), this.treeMaker.Ident(this.toName(methodName)), List.from(params));
    }

    public JCTree.JCMethodInvocation methodCall(String varName, String methodName, JCTree.JCExpression ... params) {
        return this.treeMaker.Apply(List.nil(), this.treeMaker.Select((JCTree.JCExpression)this.treeMaker.Ident(this.toName(varName)), this.toName(methodName)), List.from(params));
    }

    public JCTree.JCVariableDecl newVar(int modifiers, Class<?> clazz, String name, JCTree.JCExpression init) {
        return this.treeMaker.VarDef(this.treeMaker.Modifiers(modifiers), this.toName(name), this.typeRef(clazz), init);
    }

    public JCTree.JCVariableDecl newVar(Class<?> clazz, String name) {
        return this.treeMaker.VarDef(this.treeMaker.Modifiers(0x200000000L), this.toName(name), this.typeRef(clazz), null);
    }

    public JCTree.JCVariableDecl newVar(JCTree.JCExpression varType, String name) {
        return this.treeMaker.VarDef(this.treeMaker.Modifiers(0x200000000L), this.toName(name), varType, null);
    }

    public JCTree.JCExpression newGenericsType(Class typeClass, JCTree.JCExpression ... genericTypes) {
        return this.treeMaker.TypeApply(this.typeRef(typeClass), List.from(genericTypes));
    }

    public JCTree.JCExpression newGenericsType(Class typeClass, Class<?> ... genericTypeClasses) {
        ListBuffer<JCTree.JCExpression> genericTypes = new ListBuffer<JCTree.JCExpression>();
        for (Class<?> genericTypeClass : genericTypeClasses) {
            genericTypes.append(this.typeRef(genericTypeClass));
        }
        return this.treeMaker.TypeApply(this.typeRef(typeClass), genericTypes.toList());
    }

    public JCTree.JCExpression newGenericsType(Class typeClass, String classSimpleName) {
        return this.treeMaker.TypeApply(this.typeRef(typeClass), List.of(this.treeMaker.Ident(this.toName(classSimpleName))));
    }

    public JCTree.JCExpression newArrayType(String typeName) {
        return this.treeMaker.TypeArray(this.treeMaker.Ident(this.toName(typeName)));
    }

    public JCTree.JCExpression newArrayType(Class typeClass) {
        return this.treeMaker.TypeArray(this.typeRef(typeClass));
    }

    public JCTree.JCExpression newArrayType(JCTree.JCExpression type) {
        return this.treeMaker.TypeArray(type);
    }

    public JCTree.JCExpression newArray(Class type) {
        return this.treeMaker.NewArray(this.typeRef(type), List.of(this.treeMaker.Literal(0)), null);
    }

    public JCTree.JCExpression varRef(String name) {
        return this.treeMaker.Ident(this.toName(name));
    }

    public JCTree.JCExpression classRef(String name) {
        return this.treeMaker.Select((JCTree.JCExpression)this.treeMaker.Ident(this.toName(name)), this.toName("class"));
    }

    public JCTree.JCExpression classRef(Class<?> clazz) {
        return this.treeMaker.Select(this.typeRef(clazz), this.toName("class"));
    }

    public static boolean isBoolean(JCTree.JCExpression varType) {
        return varType != null && varType.toString().equalsIgnoreCase("boolean");
    }

    public boolean isStatic(JCTree.JCModifiers modifiers) {
        return (modifiers.flags & 8L) != 0L;
    }

    public JCTree.JCVariableDecl[] getFields() {
        ArrayList<JCTree.JCVariableDecl> fields = new ArrayList<JCTree.JCVariableDecl>();
        List<JCTree> members = this.classDecl.defs;
        for (JCTree member : members) {
            if (!(member instanceof JCTree.JCVariableDecl)) continue;
            fields.add((JCTree.JCVariableDecl)member);
        }
        return fields.toArray(new JCTree.JCVariableDecl[0]);
    }

    public JCTree.JCMethodDecl newGetter(JCTree.JCVariableDecl field) {
        String fieldName = field.name.toString();
        String getterName = APTBuilder.isBoolean(field.vartype) ? Utils.camelize(String.format("%s_%s", "is", fieldName), true) : Utils.camelize(String.format("%s_%s", "get", fieldName), true);
        JCTree.JCReturn returnStatement = this.treeMaker.Return(this.treeMaker.Select(this.varRef("this"), this.toName(fieldName)));
        return this.treeMaker.MethodDef(this.treeMaker.Modifiers(17L), this.toName(getterName), field.vartype, List.nil(), List.nil(), List.nil(), this.treeMaker.Block(0L, List.of(returnStatement)), null);
    }

    public JCTree.JCMethodDecl newSetter(JCTree.JCVariableDecl field, boolean returnThis) {
        String fieldName = field.name.toString();
        String setterName = Utils.camelize(String.format("%s_%s", "set", fieldName), true);
        ListBuffer<JCTree.JCStatement> statements = new ListBuffer<JCTree.JCStatement>();
        JCTree.JCFieldAccess fieldRef = this.treeMaker.Select(this.varRef("this"), this.toName(fieldName));
        JCTree.JCAssign assign = this.treeMaker.Assign(fieldRef, this.treeMaker.Ident(field.name));
        JCTree.JCVariableDecl parameter = this.treeMaker.VarDef(this.treeMaker.Modifiers(0x200000000L), this.toName(fieldName), field.vartype, null);
        JCTree.JCExpression returnType = this.treeMaker.TypeIdent(TypeTag.VOID);
        statements.append(this.treeMaker.Exec(assign));
        if (returnThis) {
            returnType = this.typeRef(this.classDecl.name.toString());
            statements.append(this.treeMaker.Return(this.varRef("this")));
        }
        return this.treeMaker.MethodDef(this.treeMaker.Modifiers(17L), this.toName(setterName), returnType, List.nil(), List.of(parameter), List.nil(), this.treeMaker.Block(0L, statements.toList()), null);
    }
}

