/*
 * Decompiled with CFR 0.152.
 */
package com.github.braisdom.objsql.apt;

import com.github.braisdom.objsql.apt.APTBuilder;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;

public class StatementBuilder {
    private final TreeMaker treeMaker;
    private final APTBuilder aptBuilder;
    private final ListBuffer<JCTree.JCStatement> jcStatements;

    StatementBuilder(APTBuilder aptBuilder) {
        this.treeMaker = aptBuilder.getTreeMaker();
        this.aptBuilder = aptBuilder;
        this.jcStatements = new ListBuffer();
    }

    public StatementBuilder append(JCTree.JCExpression varType, String varName, Class invokedClass, String method, List<JCTree.JCExpression> params) {
        JCTree.JCMethodInvocation methodInvocation = this.treeMaker.Apply(List.nil(), this.treeMaker.Select(this.aptBuilder.typeRef(invokedClass), this.aptBuilder.toName(method)), params);
        this.jcStatements.append(this.treeMaker.VarDef(this.treeMaker.Modifiers(0x200000000L), this.aptBuilder.toName(varName), varType, methodInvocation));
        return this;
    }

    public StatementBuilder append(String varName, String methodName, JCTree.JCExpression ... params) {
        JCTree.JCFieldAccess methodRef = this.treeMaker.Select(this.aptBuilder.varRef(varName), this.aptBuilder.toName(methodName));
        this.jcStatements.append(this.treeMaker.Exec(this.treeMaker.Apply(List.nil(), methodRef, List.from(params))));
        return this;
    }

    public StatementBuilder append(String methodName, JCTree.JCExpression ... params) {
        JCTree.JCIdent methodRef = this.treeMaker.Ident(this.aptBuilder.toName(methodName));
        this.jcStatements.append(this.treeMaker.Exec(this.treeMaker.Apply(List.nil(), methodRef, List.from(params))));
        return this;
    }

    public StatementBuilder append(Class clazz, String methodName, JCTree.JCExpression ... params) {
        JCTree.JCFieldAccess methodRef = this.treeMaker.Select(this.aptBuilder.typeRef(clazz), this.aptBuilder.toName(methodName));
        this.jcStatements.append(this.treeMaker.Exec(this.treeMaker.Apply(List.nil(), methodRef, List.from(params))));
        return this;
    }

    public StatementBuilder append(Class typeClass, String name, Class invokedClass, String method, JCTree.JCExpression ... params) {
        this.append(this.aptBuilder.typeRef(typeClass), name, invokedClass.getName(), method, params);
        return this;
    }

    public StatementBuilder append(JCTree.JCExpression varType, String name, Class invokedClass, String method, JCTree.JCExpression ... params) {
        this.append(varType, name, invokedClass.getName(), method, params);
        return this;
    }

    public StatementBuilder append(JCTree.JCExpression varType, String name, String invokedClassName, String method, JCTree.JCExpression ... params) {
        JCTree.JCMethodInvocation methodInvoke = this.treeMaker.Apply(List.nil(), this.treeMaker.Select(this.aptBuilder.typeRef(invokedClassName), this.aptBuilder.toName(method)), List.from(params));
        this.jcStatements.append(this.treeMaker.VarDef(this.treeMaker.Modifiers(0x200000000L), this.aptBuilder.toName(name), varType, methodInvoke));
        return this;
    }

    public StatementBuilder append(JCTree.JCExpression varType, String name, String instanceMethodName, JCTree.JCExpression ... params) {
        JCTree.JCMethodInvocation methodInvoke = this.treeMaker.Apply(List.nil(), this.aptBuilder.varRef(instanceMethodName), List.from(params));
        this.jcStatements.append(this.treeMaker.VarDef(this.treeMaker.Modifiers(0x200000000L), this.aptBuilder.toName(name), varType, methodInvoke));
        return this;
    }

    public StatementBuilder append(String varName, String methodName, List<JCTree.JCExpression> params) {
        this.jcStatements.append(this.treeMaker.Exec(this.treeMaker.Apply(List.nil(), this.treeMaker.Select(this.aptBuilder.varRef(varName), this.aptBuilder.toName(methodName)), params)));
        return this;
    }

    public StatementBuilder append(JCTree.JCExpression varType, String name, JCTree.JCExpression init) {
        this.jcStatements.append(this.treeMaker.VarDef(this.treeMaker.Modifiers(0x200000000L), this.aptBuilder.toName(name), varType, init));
        return this;
    }

    public StatementBuilder append(JCTree.JCStatement statement) {
        this.jcStatements.append(statement);
        return this;
    }

    public StatementBuilder append(JCTree.JCStatement ... statements) {
        this.jcStatements.appendList(List.from(statements));
        return this;
    }

    public StatementBuilder append(List<JCTree.JCStatement> statements) {
        this.jcStatements.appendList(statements);
        return this;
    }

    public List<JCTree.JCStatement> build() {
        return this.jcStatements.toList();
    }
}

