/*
 * Decompiled with CFR 0.152.
 */
package com.github.braisdom.objsql.apt;

import com.github.braisdom.objsql.Databases;
import com.github.braisdom.objsql.annotations.Transactional;
import com.github.braisdom.objsql.apt.APTBuilder;
import com.github.braisdom.objsql.apt.AnnotationValues;
import com.github.braisdom.objsql.apt.DomainModelProcessor;
import com.github.braisdom.objsql.apt.MethodBuilder;
import com.github.braisdom.objsql.apt.StatementBuilder;
import com.github.braisdom.objsql.jdbc.DbUtils;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import java.lang.annotation.Annotation;
import java.sql.Connection;

public class TransactionalCodeGenerator
extends DomainModelProcessor {
    @Override
    protected Class<? extends Annotation> getAnnotationClass() {
        return Transactional.class;
    }

    @Override
    protected void handle(AnnotationValues annotationValues, JCTree ast, APTBuilder aptBuilder) {
        JCTree.JCMethodDecl methodDecl = (JCTree.JCMethodDecl)aptBuilder.get();
        if (ast == null || methodDecl == null) {
            return;
        }
        String originalMethodName = methodDecl.name.toString();
        methodDecl.name = methodDecl.name.append(aptBuilder.toName("InTransaction"));
        MethodBuilder methodBuilder = aptBuilder.createMethodBuilder();
        for (JCTree.JCExpression throwExpression : methodDecl.getThrows()) {
            methodBuilder.addThrowsClauses(throwExpression);
        }
        methodBuilder.addParameter(methodDecl.params.toArray(new JCTree.JCVariableDecl[0]));
        methodBuilder.setReturnType(methodDecl.restype);
        methodBuilder.addStatements(this.createBody(methodDecl, aptBuilder));
        aptBuilder.injectForce(methodBuilder.build(originalMethodName, (int)methodDecl.getModifiers().flags));
    }

    private List<JCTree.JCStatement> createBody(JCTree.JCMethodDecl methodDecl, APTBuilder aptBuilder) {
        TreeMaker treeMaker = aptBuilder.getTreeMaker();
        java.util.List exceptions = methodDecl.getThrows();
        ListBuffer<JCTree.JCCatch> catchStatement = new ListBuffer<JCTree.JCCatch>();
        StatementBuilder bodyStatement = aptBuilder.createStatementBuilder();
        StatementBuilder tryStatement = aptBuilder.createStatementBuilder();
        bodyStatement.append(aptBuilder.typeRef(Connection.class), "connection", (JCTree.JCExpression)treeMaker.Literal(TypeTag.BOT, null));
        JCTree.JCExpression[] originalParams = (JCTree.JCExpression[])methodDecl.params.stream().map(param -> aptBuilder.varRef(param.name.toString())).toArray(JCTree.JCExpression[]::new);
        JCTree.JCIdent invokeMethodRef = treeMaker.Ident(methodDecl.name);
        JCTree.JCMethodInvocation originalMethodInvocation = treeMaker.Apply(List.nil(), invokeMethodRef, List.from(originalParams));
        JCTree.JCFieldAccess getConnectionCall = treeMaker.Select((JCTree.JCExpression)treeMaker.Apply(List.nil(), treeMaker.Select(aptBuilder.typeRef(Databases.class), aptBuilder.toName("getConnectionFactory")), List.nil()), aptBuilder.toName("getConnection"));
        tryStatement.append((JCTree.JCStatement)treeMaker.Exec(treeMaker.Assign(aptBuilder.varRef("connection"), treeMaker.Apply(List.nil(), getConnectionCall, List.nil()))));
        tryStatement.append((JCTree.JCStatement)treeMaker.Exec(treeMaker.Apply(List.nil(), treeMaker.Select(aptBuilder.varRef("connection"), aptBuilder.toName("setAutoCommit")), List.of(treeMaker.Literal(false)))));
        JCTree.JCFieldAccess threadLocalSetCall = treeMaker.Select((JCTree.JCExpression)treeMaker.Apply(List.nil(), treeMaker.Select(aptBuilder.typeRef(Databases.class), aptBuilder.toName("getConnectionThreadLocal")), List.nil()), aptBuilder.toName("set"));
        tryStatement.append((JCTree.JCStatement)treeMaker.Exec(treeMaker.Apply(List.nil(), threadLocalSetCall, List.of(aptBuilder.varRef("connection")))));
        if (methodDecl.restype.type.getTag().equals((Object)TypeTag.VOID)) {
            tryStatement.append((JCTree.JCStatement)treeMaker.Exec(originalMethodInvocation));
            tryStatement.append((JCTree.JCStatement)treeMaker.Exec(treeMaker.Apply(List.nil(), treeMaker.Select(aptBuilder.varRef("connection"), aptBuilder.toName("commit")), List.nil())));
        } else {
            tryStatement.append(methodDecl.restype, "res", (JCTree.JCExpression)originalMethodInvocation);
            tryStatement.append((JCTree.JCStatement)treeMaker.Exec(treeMaker.Apply(List.nil(), treeMaker.Select(aptBuilder.varRef("connection"), aptBuilder.toName("commit")), List.nil())));
            tryStatement.append((JCTree.JCStatement)treeMaker.Return(aptBuilder.varRef("res")));
        }
        for (JCTree.JCExpression exception : exceptions) {
            ListBuffer<JCTree.JCStatement> catchBodyStatement = new ListBuffer<JCTree.JCStatement>();
            catchBodyStatement.append(treeMaker.Exec(treeMaker.Apply(List.nil(), treeMaker.Select(aptBuilder.typeRef(DbUtils.class), aptBuilder.toName("rollback")), List.of(aptBuilder.varRef("connection")))));
            catchBodyStatement.append(treeMaker.Throw(aptBuilder.varRef("ex")));
            catchStatement.append(treeMaker.Catch(aptBuilder.newVar(exception, "ex"), treeMaker.Block(0L, catchBodyStatement.toList())));
        }
        JCTree.JCFieldAccess threadLocalRemoveCall = treeMaker.Select((JCTree.JCExpression)treeMaker.Apply(List.nil(), treeMaker.Select(aptBuilder.typeRef(Databases.class), aptBuilder.toName("getConnectionThreadLocal")), List.nil()), aptBuilder.toName("remove"));
        JCTree.JCExpressionStatement finallyStatement = treeMaker.Exec(treeMaker.Apply(List.nil(), threadLocalRemoveCall, List.nil()));
        JCTree.JCExpressionStatement closeQuietlyStatement = treeMaker.Exec(treeMaker.Apply(List.nil(), treeMaker.Select(aptBuilder.typeRef(DbUtils.class), aptBuilder.toName("closeQuietly")), List.of(aptBuilder.varRef("connection"))));
        JCTree.JCTry jcTry = treeMaker.Try(treeMaker.Block(0L, tryStatement.build()), catchStatement.toList(), treeMaker.Block(0L, List.of(finallyStatement, closeQuietlyStatement)));
        bodyStatement.append((JCTree.JCStatement)jcTry);
        return bodyStatement.build();
    }
}

