/*
 * Decompiled with CFR 0.152.
 */
package com.github.braisdom.objsql.relation;

import com.github.braisdom.objsql.DomainModelException;
import com.github.braisdom.objsql.Tables;
import com.github.braisdom.objsql.annotations.PrimaryKey;
import com.github.braisdom.objsql.annotations.Relation;
import com.github.braisdom.objsql.reflection.PropertyUtils;
import com.github.braisdom.objsql.relation.BelongsToProcessor;
import com.github.braisdom.objsql.relation.HasAnyProcessor;
import com.github.braisdom.objsql.relation.RelationProcessor;
import com.github.braisdom.objsql.relation.RelationType;
import com.github.braisdom.objsql.relation.RelationalException;
import com.github.braisdom.objsql.util.StringUtil;
import com.github.braisdom.objsql.util.WordUtil;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public final class Relationship {
    private final Class baseClass;
    private final Field relationField;
    private final Relation relation;

    public Relationship(Class baseClass, Field relationField, Relation relation) {
        Objects.requireNonNull(relationField, "The relationField cannot be null");
        Objects.requireNonNull(relation, String.format("The %s has no relation annotation", relationField.getName()));
        this.baseClass = baseClass;
        this.relationField = relationField;
        this.relation = relation;
    }

    public Class getBaseClass() {
        return this.baseClass;
    }

    public Class getRelatedClass() {
        if (Collection.class.isAssignableFrom(this.relationField.getType())) {
            ParameterizedType parameterizedType = (ParameterizedType)this.relationField.getGenericType();
            Type[] genericTypes = parameterizedType.getActualTypeArguments();
            if (genericTypes.length == 0) {
                throw new RelationalException(String.format("The %s of %s has no generic type", this.relationField.getName(), this.getBaseClass().getSimpleName()));
            }
            try {
                return Class.forName(genericTypes[0].getTypeName());
            }
            catch (ClassNotFoundException e) {
                throw new RelationalException(e.getMessage(), e);
            }
        }
        return this.relationField.getType();
    }

    public Field getRelationField() {
        return this.relationField;
    }

    public String getRelationCondition() {
        return this.relation.condition();
    }

    public String getPrimaryKey() {
        if (StringUtil.isBlank(this.relation.primaryKey())) {
            if (this.isBelongsTo()) {
                PrimaryKey primaryKey = Tables.getPrimaryKey(this.getBaseClass());
                if (primaryKey == null) {
                    throw new DomainModelException(String.format("The %s has no primary key", this.getBaseClass().getSimpleName()));
                }
                return primaryKey.name();
            }
            PrimaryKey primaryKey = Tables.getPrimaryKey(this.getRelatedClass());
            if (primaryKey == null) {
                throw new DomainModelException(String.format("The %s has no primary key", this.getRelatedClass().getSimpleName()));
            }
            return primaryKey.name();
        }
        return this.relation.primaryKey();
    }

    public String getForeignKey() {
        if (StringUtil.isBlank(this.relation.foreignKey())) {
            if (this.isBelongsTo()) {
                String rawForeignKey = this.getRelatedClass().getSimpleName();
                return Tables.encodeDefaultKey(WordUtil.underscore(rawForeignKey));
            }
            String rawForeignKey = this.baseClass.getSimpleName();
            return Tables.encodeDefaultKey(WordUtil.underscore(rawForeignKey));
        }
        return this.relation.foreignKey();
    }

    public String getPrimaryAssociationFieldName() {
        if (StringUtil.isBlank(this.relation.primaryFieldName())) {
            if (this.isBelongsTo()) {
                return Tables.getPrimaryField(this.getRelatedClass()).getName();
            }
            return Tables.getPrimaryField(this.getBaseClass()).getName();
        }
        return this.relation.primaryFieldName();
    }

    public String getForeignFieldName() {
        if (StringUtil.isBlank(this.relation.foreignFieldName())) {
            if (this.isBelongsTo()) {
                String rawForeignFieldName = WordUtil.underscore(this.getRelatedClass().getSimpleName());
                return WordUtil.camelize(Tables.encodeDefaultKey(rawForeignFieldName), true);
            }
            String rawForeignFieldName = WordUtil.underscore(this.getBaseClass().getSimpleName());
            return WordUtil.camelize(Tables.encodeDefaultKey(rawForeignFieldName), true);
        }
        return this.relation.foreignFieldName();
    }

    public boolean isBelongsTo() {
        return RelationType.BELONGS_TO.equals((Object)this.relation.relationType());
    }

    public RelationProcessor createProcessor() {
        if (this.isBelongsTo()) {
            return new BelongsToProcessor();
        }
        return new HasAnyProcessor();
    }

    public static void setRelationalObjects(Relationship relationship, Object row, String fieldName, List associatedObjects) {
        if (relationship.isBelongsTo()) {
            if (associatedObjects.size() > 1) {
                throw new RelationalException(String.format("The %s[belongs_to] has too many relations", fieldName));
            }
            if (associatedObjects.size() == 1) {
                PropertyUtils.writeDirectly(row, fieldName, associatedObjects.get(0));
            } else {
                PropertyUtils.writeDirectly(row, fieldName, null);
            }
        } else {
            PropertyUtils.writeDirectly(row, fieldName, (Object)associatedObjects);
        }
    }

    public static final Relationship createRelation(Class baseClass, String fieldName) {
        try {
            Field field = baseClass.getDeclaredField(fieldName);
            Relation relation = field.getAnnotation(Relation.class);
            if (relation == null) {
                throw new RelationalException(String.format("The %s has not relation", field));
            }
            return new Relationship(baseClass, field, relation);
        }
        catch (NoSuchFieldException ex) {
            throw new RelationalException(String.format("The %s has no field '%s' (%s)", baseClass.getSimpleName(), fieldName, ex.getMessage()), ex);
        }
    }
}

