/*
 * Decompiled with CFR 0.152.
 */
package com.github.braisdom.objsql.apt;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AnnotationValues {
    private final Map<String, AnnotationValue> values = new HashMap<String, AnnotationValue>();
    private final ClassLoader classLoader;

    public AnnotationValues(Tree tree, ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.extractAnnotation(tree);
    }

    private void extractAnnotation(Tree tree) {
        List<Object> annotations = Collections.emptyList();
        if (tree instanceof ClassTree) {
            annotations = ((ClassTree)tree).getModifiers().getAnnotations();
        } else if (tree instanceof VariableTree) {
            annotations = ((VariableTree)tree).getModifiers().getAnnotations();
        }
        for (JCTree.JCAnnotation annotation : annotations) {
            this.values.put(annotation.getAnnotationType().type.toString(), new AnnotationValue(annotation));
        }
    }

    public <A> A getAnnotationValue(Class<A> annotationClass) {
        return (A)Proxy.newProxyInstance(annotationClass.getClassLoader(), new Class[]{annotationClass}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                AnnotationValue annotationValue = (AnnotationValue)AnnotationValues.this.values.get(method.getDeclaringClass().getName());
                if (annotationValue == null) {
                    return method.getDefaultValue();
                }
                Object value = annotationValue.getValue(method);
                if (value == null) {
                    return method.getDefaultValue();
                }
                return value;
            }
        });
    }

    private class AnnotationValue {
        private Map<String, Object> annotationValueMap = new HashMap<String, Object>();

        public AnnotationValue(JCTree.JCAnnotation annotation) {
            this.extractAnnotationValue(annotation);
        }

        private void extractAnnotationValue(JCTree.JCAnnotation annotation) {
            for (JCTree.JCExpression expression : annotation.getArguments()) {
                if (!(expression instanceof JCTree.JCAssign)) continue;
                JCTree.JCAssign assign = (JCTree.JCAssign)expression;
                String attributeName = ((JCTree.JCIdent)assign.lhs).name.toString();
                if (assign.rhs instanceof JCTree.JCFieldAccess) {
                    String className;
                    JCTree.JCFieldAccess fieldAccess = (JCTree.JCFieldAccess)assign.rhs;
                    if ("java.lang.Class".equalsIgnoreCase(expression.type.tsym.toString())) {
                        className = ((Type.ClassType)fieldAccess.type).allparams_field.get(0).toString();
                        try {
                            this.annotationValueMap.put(attributeName, Class.forName(className, true, AnnotationValues.this.classLoader));
                        }
                        catch (ClassNotFoundException ex) {
                            this.annotationValueMap.put(attributeName, className);
                        }
                        continue;
                    }
                    className = assign.rhs.type.toString();
                    try {
                        Class<?> enumClass = Class.forName(className);
                        this.annotationValueMap.put(attributeName, this.getEnumValue(enumClass, ((JCTree.JCFieldAccess)assign.rhs).name.toString()));
                    }
                    catch (ClassNotFoundException ex) {
                        this.annotationValueMap.put(attributeName, className);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    continue;
                }
                if (!(assign.rhs instanceof JCTree.JCLiteral)) continue;
                this.annotationValueMap.put(attributeName, ((JCTree.JCLiteral)assign.rhs).value);
            }
        }

        private Object getEnumValue(Class enumClass, String value) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
            Method method = enumClass.getDeclaredMethod("valueOf", String.class);
            return method.invoke(null, value);
        }

        private Object getValue(Method method) {
            return this.annotationValueMap.get(method.getName());
        }
    }
}

