/*
 * Decompiled with CFR 0.152.
 */
package com.github.braisdom.objsql.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Objects;

public final class ArrayUtil {
    private static final int CACHE_SIZE = 73;
    private static Object[] sCache = new Object[73];

    private ArrayUtil() {
    }

    public static boolean equals(byte[] array1, byte[] array2, int length) {
        if (length < 0) {
            throw new IllegalArgumentException();
        }
        if (array1 == array2) {
            return true;
        }
        if (array1 == null || array2 == null || array1.length < length || array2.length < length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (array1[i] == array2[i]) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean isEmpty(T[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(int[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(long[] array) {
        return array == null || array.length == 0;
    }

    public static <T> boolean contains(T[] array, T value) {
        return ArrayUtil.indexOf(array, value) != -1;
    }

    public static <T> int indexOf(T[] array, T value) {
        if (array == null) {
            return -1;
        }
        for (int i = 0; i < array.length; ++i) {
            if (!Objects.equals(array[i], value)) continue;
            return i;
        }
        return -1;
    }

    public static <T> boolean containsAll(T[] array, T[] check) {
        if (check == null) {
            return true;
        }
        for (T checkItem : check) {
            if (ArrayUtil.contains(array, checkItem)) continue;
            return false;
        }
        return true;
    }

    public static boolean contains(int[] array, int value) {
        if (array == null) {
            return false;
        }
        for (int element : array) {
            if (element != value) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(long[] array, long value) {
        if (array == null) {
            return false;
        }
        for (long element : array) {
            if (element != value) continue;
            return true;
        }
        return false;
    }

    public static long total(long[] array) {
        long total = 0L;
        for (long value : array) {
            total += value;
        }
        return total;
    }

    public static <T> T[] appendElement(Class<T> kind, T[] array, T element) {
        Object[] result;
        int end;
        if (array != null) {
            end = array.length;
            result = (Object[])Array.newInstance(kind, end + 1);
            System.arraycopy(array, 0, result, 0, end);
        } else {
            end = 0;
            result = (Object[])Array.newInstance(kind, 1);
        }
        result[end] = element;
        return result;
    }

    public static <T> T[] removeElement(Class<T> kind, T[] array, T element) {
        if (array != null) {
            if (!ArrayUtil.contains(array, element)) {
                return array;
            }
            int length = array.length;
            for (int i = 0; i < length; ++i) {
                if (!Objects.equals(array[i], element)) continue;
                if (length == 1) {
                    return null;
                }
                Object[] result = (Object[])Array.newInstance(kind, length - 1);
                System.arraycopy(array, 0, result, 0, i);
                System.arraycopy(array, i + 1, result, i, length - i - 1);
                return result;
            }
        }
        return array;
    }

    public static int[] appendInt(int[] cur, int val) {
        if (cur == null) {
            return new int[]{val};
        }
        int N = cur.length;
        for (int i = 0; i < N; ++i) {
            if (cur[i] != val) continue;
            return cur;
        }
        int[] ret = new int[N + 1];
        System.arraycopy(cur, 0, ret, 0, N);
        ret[N] = val;
        return ret;
    }

    public static int[] removeInt(int[] cur, int val) {
        if (cur == null) {
            return null;
        }
        int N = cur.length;
        for (int i = 0; i < N; ++i) {
            if (cur[i] != val) continue;
            int[] ret = new int[N - 1];
            if (i > 0) {
                System.arraycopy(cur, 0, ret, 0, i);
            }
            if (i < N - 1) {
                System.arraycopy(cur, i + 1, ret, i, N - i - 1);
            }
            return ret;
        }
        return cur;
    }

    public static long[] appendLong(long[] cur, long val) {
        if (cur == null) {
            return new long[]{val};
        }
        int N = cur.length;
        for (int i = 0; i < N; ++i) {
            if (cur[i] != val) continue;
            return cur;
        }
        long[] ret = new long[N + 1];
        System.arraycopy(cur, 0, ret, 0, N);
        ret[N] = val;
        return ret;
    }

    public static long[] removeLong(long[] cur, long val) {
        if (cur == null) {
            return null;
        }
        int N = cur.length;
        for (int i = 0; i < N; ++i) {
            if (cur[i] != val) continue;
            long[] ret = new long[N - 1];
            if (i > 0) {
                System.arraycopy(cur, 0, ret, 0, i);
            }
            if (i < N - 1) {
                System.arraycopy(cur, i + 1, ret, i, N - i - 1);
            }
            return ret;
        }
        return cur;
    }

    public static long[] cloneOrNull(long[] array) {
        return array != null ? (long[])array.clone() : null;
    }

    public static <T> ArrayList<T> add(ArrayList<T> cur, T val) {
        if (cur == null) {
            cur = new ArrayList();
        }
        cur.add(val);
        return cur;
    }

    public static <T> ArrayList<T> remove(ArrayList<T> cur, T val) {
        if (cur == null) {
            return null;
        }
        cur.remove(val);
        if (cur.isEmpty()) {
            return null;
        }
        return cur;
    }

    public static <T> boolean contains(ArrayList<T> cur, T val) {
        return cur != null ? cur.contains(val) : false;
    }

    public static <T> boolean referenceEquals(ArrayList<T> a, ArrayList<T> b) {
        if (a == b) {
            return true;
        }
        int sizeA = a.size();
        int sizeB = b.size();
        if (a == null || b == null || sizeA != sizeB) {
            return false;
        }
        boolean diff = false;
        for (int i = 0; i < sizeA && !diff; diff |= a.get(i) != b.get(i), ++i) {
        }
        return !diff;
    }
}

