/*
 * Decompiled with CFR 0.152.
 */
package com.github.braisdom.objsql;

import com.github.braisdom.objsql.ConnectionFactory;
import com.github.braisdom.objsql.DefaultPersistence;
import com.github.braisdom.objsql.DefaultQuery;
import com.github.braisdom.objsql.DefaultSQLExecutor;
import com.github.braisdom.objsql.Logger;
import com.github.braisdom.objsql.LoggerFactory;
import com.github.braisdom.objsql.LoggerImpl;
import com.github.braisdom.objsql.Persistence;
import com.github.braisdom.objsql.PersistenceFactory;
import com.github.braisdom.objsql.Query;
import com.github.braisdom.objsql.QueryFactory;
import com.github.braisdom.objsql.Quoter;
import com.github.braisdom.objsql.RollbackCauseException;
import com.github.braisdom.objsql.SQLExecutor;
import com.github.braisdom.objsql.jdbc.DbUtils;
import com.github.braisdom.objsql.transition.DefaultJDBCDataTypeRiser;
import com.github.braisdom.objsql.transition.JDBCDataTypeRiser;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Objects;

public final class Databases {
    private static LoggerFactory loggerFactory = new LoggerFactory(){

        @Override
        public Logger create(Class<?> clazz) {
            return new LoggerImpl(clazz);
        }
    };
    private static SQLExecutor sqlExecutor = new DefaultSQLExecutor();
    private static JDBCDataTypeRiser jdbcDataTypeRiser = new DefaultJDBCDataTypeRiser();
    private static ConnectionFactory connectionFactory;
    private static ThreadLocal<Connection> connectionThreadLocal;
    private static QueryFactory queryFactory;
    private static Quoter quoter;
    private static PersistenceFactory persistenceFactory;

    public static ThreadLocal<Connection> getConnectionThreadLocal() {
        return connectionThreadLocal;
    }

    public static void installConnectionFactory(ConnectionFactory connectionFactory) {
        Objects.requireNonNull(connectionFactory, "The connectionFactory cannot be null");
        Databases.connectionFactory = connectionFactory;
    }

    public static void installSqlExecutor(SQLExecutor sqlExecutor) {
        Objects.requireNonNull(sqlExecutor, "The sqlExecutor cannot be null");
        Databases.sqlExecutor = sqlExecutor;
    }

    public static void installQueryFacotry(QueryFactory queryFactory) {
        Objects.requireNonNull(sqlExecutor, "The queryFactory cannot be null");
        Databases.queryFactory = queryFactory;
    }

    public static void installPersistenceFactory(PersistenceFactory persistenceFactory) {
        Objects.requireNonNull(sqlExecutor, "The persistenceFactory cannot be null");
        Databases.persistenceFactory = persistenceFactory;
    }

    public static void installLoggerFactory(LoggerFactory loggerFactory) {
        Objects.requireNonNull(sqlExecutor, "The loggerFactory cannot be null");
        Databases.loggerFactory = loggerFactory;
    }

    public static void installQuoter(Quoter quoter) {
        Objects.requireNonNull(sqlExecutor, "The quoter cannot be null");
        Databases.quoter = quoter;
    }

    public static void installStandardDataTypeRiser(JDBCDataTypeRiser JDBCDataTypeRiser2) {
        jdbcDataTypeRiser = JDBCDataTypeRiser2;
    }

    public static <R> R executeTransactionally(TransactionalExecutor<R> executor) throws SQLException {
        Connection connection = null;
        try {
            connection = Databases.getConnectionFactory().getConnection();
            connection.setAutoCommit(false);
            connectionThreadLocal.set(connection);
            R result = executor.apply();
            connection.commit();
            R r = result;
            return r;
        }
        catch (SQLException ex) {
            DbUtils.rollback(connection);
            throw ex;
        }
        catch (Throwable ex) {
            DbUtils.rollback(connection);
            throw new RollbackCauseException(ex.getMessage(), ex);
        }
        finally {
            connectionThreadLocal.remove();
            DbUtils.closeQuietly(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, R> R execute(DatabaseInvoke<T, R> databaseInvoke) throws SQLException {
        Connection connection = connectionThreadLocal.get();
        SQLExecutor sqlExecutor = Databases.getSqlExecutor();
        if (connection == null) {
            try {
                connection = Databases.getConnectionFactory().getConnection();
                R r = databaseInvoke.apply(connection, sqlExecutor);
                return r;
            }
            finally {
                DbUtils.closeQuietly(connection);
            }
        }
        return databaseInvoke.apply(connection, sqlExecutor);
    }

    public static <R> R sqlBenchmarking(Benchmarkable<R> benchmarkable, Logger logger, String message, Object ... params) throws SQLException {
        try {
            long begin = System.currentTimeMillis();
            R result = benchmarkable.apply();
            logger.info(System.currentTimeMillis() - begin, message, params);
            return result;
        }
        catch (Exception ex) {
            if (ex instanceof SQLException) {
                throw (SQLException)ex;
            }
            if (ex instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)ex;
            }
            logger.error(ex.getMessage(), ex);
            throw new IllegalStateException(ex.getMessage(), ex);
        }
    }

    public static QueryFactory getQueryFactory() {
        return queryFactory;
    }

    public static PersistenceFactory getPersistenceFactory() {
        return persistenceFactory;
    }

    public static SQLExecutor getSqlExecutor() {
        return sqlExecutor;
    }

    public static Quoter getQuoter() {
        return quoter;
    }

    public static LoggerFactory getLoggerFactory() {
        return loggerFactory;
    }

    public static JDBCDataTypeRiser getJdbcDataTypeRiser() {
        return jdbcDataTypeRiser;
    }

    public static ConnectionFactory getConnectionFactory() {
        if (connectionFactory == null) {
            throw new IllegalStateException("The connectionFactory cannot be null");
        }
        return connectionFactory;
    }

    static {
        connectionThreadLocal = new ThreadLocal();
        queryFactory = new QueryFactory(){

            @Override
            public <T> Query<T> createQuery(Class<T> clazz) {
                return new DefaultQuery<T>(clazz);
            }
        };
        quoter = new Quoter(){

            @Override
            public String quoteColumn(String columnName) {
                return columnName;
            }

            @Override
            public String quoteValue(Object ... values) {
                StringBuilder sb = new StringBuilder();
                for (Object value : values) {
                    if (value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double) {
                        sb.append(value);
                    } else {
                        sb.append(String.format("'%s'", String.valueOf(value)));
                    }
                    sb.append(",");
                }
                if (sb.length() > 0) {
                    sb.delete(sb.length() - 1, sb.length());
                }
                return sb.toString();
            }
        };
        persistenceFactory = new PersistenceFactory(){

            @Override
            public <T> Persistence<T> createPersistence(Class<T> clazz) {
                return new DefaultPersistence<T>(clazz);
            }
        };
    }

    @FunctionalInterface
    public static interface Benchmarkable<R> {
        public R apply() throws Exception;
    }

    @FunctionalInterface
    public static interface TransactionalExecutor<R> {
        public R apply() throws Exception;
    }

    @FunctionalInterface
    public static interface DatabaseInvoke<T, R> {
        public R apply(Connection var1, SQLExecutor<T> var2) throws SQLException;
    }
}

